/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.web.rest;

import com.suncode.plugin.pzmodule.api.dto.configuration.ConfigurationDto;
import com.suncode.plugin.pzmodule.api.dto.document.DocumentDto;
import com.suncode.plugin.pzmodule.api.factory.GsonFactory;
import com.suncode.plugin.pzmodule.audit.AuditType;
import com.suncode.plugin.pzmodule.service.activity.ActivityService;
import com.suncode.plugin.pzmodule.service.configuration.ConfigurationService;
import com.suncode.plugin.pzmodule.service.document.DocumentService;
import com.suncode.plugin.pzmodule.translation.Translator;
import com.suncode.plugin.pzmodule.web.rest.support.RestUtils;
import com.suncode.plugin.pzmodule.web.rest.support.View;
import com.suncode.pwfl.audit.builder.ManualAuditBuilder;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jooq.tools.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/"})
public class PzModuleController {
    private static final String CONFIGURATION_ERROR = "pzmodule.program.configuration.error";
    private static final String BACK = "pzmodule.program.back";
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private DocumentService documentService;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private Translator translator;

    @RequestMapping
    public ModelAndView program(@RequestParam String configurationId, @RequestParam String processId, @RequestParam String activityId, @RequestParam(required=false) String parentConfigurationId, @RequestParam(required=false) String parentProcessId, @RequestParam Map<String, Object> extraParameters) {
        Map<String, Object> activityContext;
        ModelAndView modelAndView = null;
        Date started = new Date();
        String userId = RestUtils.getUserIdFromSession();
        ConfigurationDto configuration = this.getConfiguration(userId, configurationId, activityContext = this.activityService.getContext(processId, activityId), extraParameters);
        if (configuration != null) {
            modelAndView = new ModelAndView(View.PROGRAM.getName());
            modelAndView.addObject("configuration", (Object)this.buildObjectAsString(configuration));
            modelAndView.addObject("documents", (Object)this.buildDocumentsAsString(configuration, processId, activityId));
            modelAndView.addObject("externalScripts", configuration.getExternalJavaScriptFiles());
            modelAndView.addObject("userId", (Object)userId);
            modelAndView.addObject("processId", (Object)processId);
            modelAndView.addObject("activityId", (Object)activityId);
            modelAndView.addObject("parentConfigurationId", (Object)parentConfigurationId);
            modelAndView.addObject("parentProcessId", (Object)parentProcessId);
            modelAndView.addObject("activityContext", (Object)this.buildObjectAsString(activityContext));
            modelAndView.addObject("extraParameters", (Object)this.buildObjectAsString(extraParameters));
            this.logPluginOpenAudit(userId, started, true, configurationId, processId, activityId);
        } else {
            modelAndView = new ModelAndView(View.CONFIGURATION_ERROR.getName());
            modelAndView.addObject("configurationErrorMessage", (Object)this.buildConfigurationErrorMessage());
            modelAndView.addObject("backText", (Object)this.buildBackText());
            this.logPluginOpenAudit(userId, started, false, configurationId, processId, activityId);
        }
        return modelAndView;
    }

    @RequestMapping(value={"administration"})
    public ModelAndView administration() {
        ModelAndView modelAndView = new ModelAndView(View.ADMINISTRATION.getName());
        return modelAndView;
    }

    @RequestMapping(value={"close"}, method={RequestMethod.GET})
    public ResponseEntity<Void> close(HttpServletRequest request) {
        Date started = new Date();
        String userId = RestUtils.getUserIdFromSession();
        this.logPluginCloseAudit(userId, started);
        return new ResponseEntity(HttpStatus.OK);
    }

    private void logPluginCloseAudit(String userId, Date started) {
        ManualAuditBuilder.getInstance().type(AuditType.AUDIT_PLUGIN_CLOSE.getValue()).username(userId).success(true).params(new LinkedHashMap()).started(started).stopped(new Date()).build().log();
    }

    private ConfigurationDto getConfiguration(String userId, String configurationId, Map<String, Object> activityContext, Map<String, Object> extraParameters) {
        return this.configurationService.get(userId, configurationId, activityContext, extraParameters);
    }

    private String buildDocumentsAsString(ConfigurationDto configuration, String processId, String activityId) {
        List<DocumentDto> documents = this.documentService.getActivityDocuments(configuration, processId, activityId);
        return this.buildObjectAsString(documents);
    }

    private String buildObjectAsString(Object object) {
        String json = GsonFactory.getGson().toJson(object);
        return JSONObject.escape((String)json);
    }

    private String buildConfigurationErrorMessage() {
        return this.translator.translateMessage(CONFIGURATION_ERROR);
    }

    private String buildBackText() {
        return this.translator.translateMessage(BACK);
    }

    private void logPluginOpenAudit(String userId, Date started, boolean success, String configurationId, String processId, String activityId) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("pzmodule.program.audit.plugin.run.param.configurationid", configurationId);
        params.put("pzmodule.program.audit.plugin.run.param.processid", processId);
        params.put("pzmodule.program.audit.plugin.run.param.activityid", activityId);
        ManualAuditBuilder.getInstance().type(AuditType.AUDIT_PLUGIN_RUN.getValue()).username(userId).success(success).params(params).started(started).stopped(new Date()).build().log();
    }
}

