/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.web.rest;

import com.suncode.plugin.pzmodule.exception.ImportAttachedException;
import com.suncode.plugin.pzmodule.service.partialattachment.PartialAttachmentAdministrationService;
import com.suncode.plugin.pzmodule.web.rest.support.Result;
import com.suncode.plugin.pzmodule.web.rest.support.builder.ResultBuilder;
import com.suncode.plugin.pzmodule.web.rest.support.form.ImportAttachedForm;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

@Controller
@RequestMapping(value={"/api/administration/partialattachment"})
public class PartialAttachmentAdministrationController {
    public static final Logger log = Logger.getLogger(PartialAttachmentAdministrationController.class);
    private static final String TEMPLATE_FILE_NAME = "pzmodule-template.xlsx";
    @Autowired
    private PartialAttachmentAdministrationService partialAttachmentAdministrationService;
    @Autowired
    private ResultBuilder resultBuilder;

    @RequestMapping(value={"/template"}, method={RequestMethod.POST})
    @ResponseBody
    public HttpEntity<byte[]> downloadTemplate() {
        byte[] template = this.generateTemplate();
        HttpHeaders responseHeaders = this.buildDownloadTemplateHeaders(template);
        return new HttpEntity((Object)template, (MultiValueMap)responseHeaders);
    }

    @RequestMapping(value={"/import"}, method={RequestMethod.POST})
    @ResponseBody
    public Result importFromExcel(ImportAttachedForm form) {
        try {
            this.partialAttachmentAdministrationService.importFromExcel(this.getInputStream(form), form.isOverrideData());
        }
        catch (ImportAttachedException exception) {
            return this.buildErrorResult(exception.getMessage());
        }
        return this.buildSuccessResult();
    }

    private byte[] generateTemplate() {
        return this.partialAttachmentAdministrationService.generateTemplate();
    }

    private HttpHeaders buildDownloadTemplateHeaders(byte[] template) {
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(this.buildTemplateMediaType());
        responseHeaders.setContentLength((long)ArrayUtils.getLength((Object)template));
        responseHeaders.setContentDispositionFormData("attachment", TEMPLATE_FILE_NAME);
        return responseHeaders;
    }

    private MediaType buildTemplateMediaType() {
        return MediaType.parseMediaType((String)"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
    }

    private InputStream getInputStream(ImportAttachedForm form) {
        try {
            CommonsMultipartFile file = form.getFile();
            return file.getInputStream();
        }
        catch (IOException exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    private Result buildSuccessResult() {
        return this.resultBuilder.build();
    }

    private Result buildErrorResult(String message) {
        return this.resultBuilder.buildError(message);
    }
}

