/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.service.xml;

import com.suncode.plugin.pzmodule.api.enumeration.ColumnAlignment;
import com.suncode.plugin.pzmodule.api.enumeration.ColumnType;
import com.suncode.plugin.pzmodule.api.enumeration.RecordLocation;
import com.suncode.plugin.pzmodule.api.enumeration.SaveActionType;
import com.suncode.plugin.pzmodule.model.configuration.Button;
import com.suncode.plugin.pzmodule.model.configuration.Column;
import com.suncode.plugin.pzmodule.model.configuration.Configuration;
import com.suncode.plugin.pzmodule.model.configuration.DocumentFilter;
import com.suncode.plugin.pzmodule.model.configuration.ExternalJavaScriptFile;
import com.suncode.plugin.pzmodule.model.configuration.FilterInit;
import com.suncode.plugin.pzmodule.model.configuration.FilterRelation;
import com.suncode.plugin.pzmodule.model.configuration.FiltersInit;
import com.suncode.plugin.pzmodule.model.configuration.GroupSum;
import com.suncode.plugin.pzmodule.model.configuration.Grouper;
import com.suncode.plugin.pzmodule.model.configuration.GroupingConfiguration;
import com.suncode.plugin.pzmodule.model.configuration.JavaScriptActions;
import com.suncode.plugin.pzmodule.model.configuration.PanelsConfiguration;
import com.suncode.plugin.pzmodule.model.configuration.PartialAttachmentConfiguration;
import com.suncode.plugin.pzmodule.model.configuration.RelatedFilter;
import com.suncode.plugin.pzmodule.model.configuration.Save;
import com.suncode.plugin.pzmodule.model.configuration.SaveAction;
import com.suncode.plugin.pzmodule.model.configuration.SaveActionParameter;
import com.suncode.plugin.pzmodule.model.configuration.Search;
import com.suncode.plugin.pzmodule.model.configuration.SearchCriterion;
import com.suncode.plugin.pzmodule.model.configuration.SearchLocation;
import com.suncode.plugin.pzmodule.model.configuration.Sorter;
import com.suncode.plugin.pzmodule.model.configuration.ToolbarField;
import com.suncode.plugin.pzmodule.service.xml.ConfigurationMarshaller;
import java.beans.ConstructorProperties;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Component
public class ConfigurationMarshallerImpl
implements ConfigurationMarshaller {
    private static final Logger LOG = Logger.getLogger(ConfigurationMarshallerImpl.class);
    private static final String INDENT = "4";

    @Override
    public ByteArrayOutputStream marshall(Configuration configuration) {
        try {
            Document document = ConfigurationMarshallerImpl.createDocument();
            Element root = ConfigurationMarshallerImpl.marshallRoot(document);
            document.appendChild(root);
            Element importJavaScriptElement = ConfigurationMarshallerImpl.marshallExternalJavaScripts(document, configuration.getExternalJavaScriptFiles());
            root.appendChild(importJavaScriptElement);
            Element javaScriptActionsElement = ConfigurationMarshallerImpl.marshallJavaScriptActions(document, configuration.getJavaScriptActions());
            root.appendChild(javaScriptActionsElement);
            Element searchElement = ConfigurationMarshallerImpl.marshallSearch(document, configuration.getSearch());
            root.appendChild(searchElement);
            if (configuration.getTableFontSize() != null) {
                ConfigurationMarshallerImpl.appendTextElement(document, root, "TableFontSize", configuration.getTableFontSize());
            }
            ConfigurationMarshallerImpl.marshallPanelsConfiguration(document, root, configuration.getPanelsConfiguration());
            Element columnsElement = ConfigurationMarshallerImpl.marshallColumns(document, configuration);
            root.appendChild(columnsElement);
            Element attachmentElement = ConfigurationMarshallerImpl.marshallAttachment(document, configuration);
            root.appendChild(attachmentElement);
            ConfigurationMarshallerImpl.appendTextElement(document, root, "NewWindowDocumentPreview", configuration.getNewWindowDocumentPreview());
            ConfigurationMarshallerImpl.appendTextElement(document, root, "DecimalSeparator", configuration.getDecimalSeparator());
            ConfigurationMarshallerImpl.appendTextElement(document, root, "LiveFiltering", configuration.getLiveFiltering());
            ConfigurationMarshallerImpl.appendTextElement(document, root, "EnableDuplicateChoice", configuration.getEnableDuplicateChoice());
            Element buttonsElement = ConfigurationMarshallerImpl.marshallButtons(document, configuration.getButtons());
            root.appendChild(buttonsElement);
            Element toolbarFieldsElement = ConfigurationMarshallerImpl.marshallToolbarFields(document, configuration.getToolbarFields());
            root.appendChild(toolbarFieldsElement);
            Element filterRelationsElement = ConfigurationMarshallerImpl.marshallFilterRelations(document, configuration.getFilterRelations());
            root.appendChild(filterRelationsElement);
            ConfigurationMarshallerImpl.marshallPartialAttachment(document, root, configuration.getPartialAttachmentConfiguration());
            Element saveElement = ConfigurationMarshallerImpl.marshallSave(document, configuration.getSave());
            root.appendChild(saveElement);
            return ConfigurationMarshallerImpl.convertToOutputStream(document);
        }
        catch (Exception exception) {
            LOG.error((Object)exception.getMessage(), (Throwable)exception);
            return new ByteArrayOutputStream();
        }
    }

    private static Document createDocument() throws ParserConfigurationException {
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
        return domBuilder.newDocument();
    }

    private static Element marshallRoot(Document document) {
        return document.createElement("PZModuleConfig");
    }

    private static Element marshallExternalJavaScripts(Document document, List<ExternalJavaScriptFile> externalJavaScriptFiles) {
        Element element = document.createElement("ImportJavaScript");
        externalJavaScriptFiles.stream().sorted(Comparator.comparingLong(ExternalJavaScriptFile::getId)).forEach(js -> ConfigurationMarshallerImpl.appendTextElement(document, element, "JavaScriptFile", js.getFileName()));
        return element;
    }

    private static Element marshallJavaScriptActions(Document document, JavaScriptActions actions) {
        Element element = document.createElement("JavaScriptActions");
        if (actions != null) {
            ConfigurationMarshallerImpl.setElementAttribute(element, new Attribute("beforerender", actions.getBoxReady()));
            ConfigurationMarshallerImpl.setElementAttribute(element, new Attribute("selectPZ", actions.getSelect()));
            ConfigurationMarshallerImpl.setElementAttribute(element, new Attribute("deselectPZ", actions.getDeselect()));
            ConfigurationMarshallerImpl.setElementAttribute(element, new Attribute("attachPZ", actions.getAttach()));
            ConfigurationMarshallerImpl.setElementAttribute(element, new Attribute("detachPZ", actions.getDetach()));
        }
        return element;
    }

    private static Element marshallSearch(Document document, Search search) {
        Element element = document.createElement("Search");
        if (search != null) {
            ConfigurationMarshallerImpl.setElementAttributes(element, Arrays.asList(new Attribute("class", search.getCustomClass()), new Attribute("whereClauseClass", search.getWhereClauseClass())));
            Element locationElement = ConfigurationMarshallerImpl.marshallSearchLocation(document, search.getLocation());
            element.appendChild(locationElement);
            search.getNotAttachedCriteria().stream().sorted(Comparator.comparingLong(SearchCriterion::getId)).forEach(c -> {
                Element searchCriterion = ConfigurationMarshallerImpl.marshallSearchCriterion(document, c, Boolean.FALSE);
                element.appendChild(searchCriterion);
            });
            search.getAttachedCriteria().stream().sorted(Comparator.comparingLong(SearchCriterion::getId)).forEach(c -> {
                Element searchCriterion = ConfigurationMarshallerImpl.marshallSearchCriterion(document, c, Boolean.TRUE);
                element.appendChild(searchCriterion);
            });
        }
        return element;
    }

    private static Element marshallSearchLocation(Document document, SearchLocation location) {
        Element element = document.createElement("Location");
        ConfigurationMarshallerImpl.appendTextElement(document, element, "Type", location.getType());
        if (ConfigurationMarshallerImpl.isDocumentClassRecordLocation(location.getType())) {
            ConfigurationMarshallerImpl.appendTextElement(document, element, "Name", location.getNotAttachedName());
            ConfigurationMarshallerImpl.appendTextElement(document, element, "AttachedName", location.getAttachedName());
        } else {
            ConfigurationMarshallerImpl.appendTextElement(document, element, "TableName", location.getNotAttachedName());
            ConfigurationMarshallerImpl.appendTextElement(document, element, "AttachedTableName", location.getAttachedName());
        }
        ConfigurationMarshallerImpl.appendTextElementWithAttribute(document, element, "PrimaryKey", location.getPrimaryKey().getName(), new Attribute("type", location.getPrimaryKey().getType()));
        return element;
    }

    private static boolean isDocumentClassRecordLocation(String locationType) {
        RecordLocation recordLocation = RecordLocation.getByName(locationType);
        return recordLocation.equals((Object)RecordLocation.DOCUMENT_CLASS);
    }

    private static Element marshallSearchCriterion(Document document, SearchCriterion criterion, boolean attachedValue) {
        Element element = document.createElement("Criteria");
        ConfigurationMarshallerImpl.appendTextElement(document, element, "Attached", attachedValue);
        ConfigurationMarshallerImpl.appendTextElement(document, element, "Type", criterion.getType());
        ConfigurationMarshallerImpl.appendTextElement(document, element, "Value", criterion.getValue());
        ConfigurationMarshallerImpl.appendTextElement(document, element, "Mapping", criterion.getMapping());
        ConfigurationMarshallerImpl.appendTextElement(document, element, "Required", criterion.getRequired());
        ConfigurationMarshallerImpl.appendTextElement(document, element, "AllowBlank", criterion.getAllowEmpty());
        ConfigurationMarshallerImpl.appendTextElement(document, element, "Operator", criterion.getOperator());
        return element;
    }

    private static void marshallPanelsConfiguration(Document document, Element parent, PanelsConfiguration panels) {
        if (panels != null) {
            if (panels.getNotAttachedPageSize() != null) {
                ConfigurationMarshallerImpl.appendTextElement(document, parent, "NotAttachedTabPageSize", panels.getNotAttachedPageSize());
            }
            if (panels.getNotAttachedPagingDisabled() != null) {
                ConfigurationMarshallerImpl.appendTextElement(document, parent, "NotAttachedPagingDisabled", panels.getNotAttachedPagingDisabled());
            }
            ConfigurationMarshallerImpl.appendTextElement(document, parent, "NotAttachedTabTitle", panels.getNotAttachedTitle());
            ConfigurationMarshallerImpl.appendTextElement(document, parent, "AttachedTabTitle", panels.getAttachedTitle());
            ConfigurationMarshallerImpl.appendTextElement(document, parent, "NotAttachedTabFiltersType", panels.getNotAttachedFiltersType());
            ConfigurationMarshallerImpl.appendTextElementWithAttribute(document, parent, "RightTabPanel", panels.getRightTitle(), new Attribute("show", panels.getRightVisible()));
            ConfigurationMarshallerImpl.appendTextElement(document, parent, "AttachButtonText", panels.getAttachButtonText());
            ConfigurationMarshallerImpl.appendTextElement(document, parent, "DetachButtonText", panels.getDetachButtonText());
            ConfigurationMarshallerImpl.appendTextElement(document, parent, "DetachAllButtonText", panels.getDetachAllButtonText());
            ConfigurationMarshallerImpl.appendTextElement(document, parent, "SaveButtonText", panels.getSaveButtonText());
            ConfigurationMarshallerImpl.appendTextElement(document, parent, "CloseButtonText", panels.getCloseButtonText());
            ConfigurationMarshallerImpl.appendTextElement(document, parent, "SelectionButtonsInMenu", panels.getSelectionButtonsInMenu());
            ConfigurationMarshallerImpl.appendTextElement(document, parent, "ToggleGroupsButtonEnabled", panels.getToggleGroupsButtonEnabled());
            Element documentFiltersElement = ConfigurationMarshallerImpl.marshallDocumentFilters(document, panels.getDocumentFilters());
            parent.appendChild(documentFiltersElement);
        }
    }

    private static Element marshallDocumentFilters(Document document, List<DocumentFilter> documentFilters) {
        Element element = document.createElement("DocumentFilters");
        documentFilters.stream().sorted(Comparator.comparingLong(DocumentFilter::getId)).forEach(df -> {
            Element documentFilterElement = ConfigurationMarshallerImpl.marshallDocumentFilter(document, df);
            element.appendChild(documentFilterElement);
        });
        return element;
    }

    private static Element marshallDocumentFilter(Document document, DocumentFilter documentFilter) {
        Element element = document.createElement("DocumentFilter");
        ConfigurationMarshallerImpl.appendTextElement(document, element, "Type", documentFilter.getType());
        ConfigurationMarshallerImpl.appendTextElement(document, element, "Value", documentFilter.getValue());
        return element;
    }

    private static Element marshallColumns(Document document, Configuration configuration) {
        Element element = document.createElement("Columns");
        configuration.getNotAttachedColumns().stream().sorted(Comparator.comparingLong(Column::getId)).forEach(c -> {
            Element columnElement = ConfigurationMarshallerImpl.marshallColumn(document, c, configuration.getAttachedColumns());
            element.appendChild(columnElement);
        });
        GroupingConfiguration grouping = configuration.getGroupingConfiguration();
        if (grouping != null) {
            ConfigurationMarshallerImpl.marshallGroupers(document, element, grouping, grouping.getNotAttachedGroupers(), "GroupNotAttachedBy", grouping.getNotAttachedGroupSums());
        }
        ConfigurationMarshallerImpl.marshallSorters(document, element, configuration.getNotAttachedSorters(), "SortNotAttachedBy");
        if (grouping != null) {
            ConfigurationMarshallerImpl.marshallGroupers(document, element, grouping, grouping.getAttachedGroupers(), "GroupAttachedBy", grouping.getAttachedGroupSums());
        }
        ConfigurationMarshallerImpl.marshallSorters(document, element, configuration.getAttachedSorters(), "SortAttachedBy");
        return element;
    }

    private static Element marshallColumn(Document document, Column column, List<Column> attachedColumns) {
        Element element = document.createElement("Column");
        ConfigurationMarshallerImpl.appendTextElement(document, element, "Id", column.getColumnId());
        ConfigurationMarshallerImpl.appendTextElement(document, element, "Name", column.getName());
        ConfigurationMarshallerImpl.appendTextElementWithAttributes(document, element, "Type", column.getType(), Arrays.asList(new Attribute("format", column.getFormat()), new Attribute("inputFormat", column.getInputFormat())));
        ConfigurationMarshallerImpl.appendTextElement(document, element, "Filter", column.getFilterable());
        ConfigurationMarshallerImpl.appendTextElement(document, element, "Hidden", column.getHidden());
        ConfigurationMarshallerImpl.appendTextElement(document, element, "HiddenInAttached", ConfigurationMarshallerImpl.isHiddenInAttached(column.getColumnId(), attachedColumns));
        ConfigurationMarshallerImpl.appendTextElement(document, element, "WordWrap", column.getWordWrap());
        ConfigurationMarshallerImpl.appendTextElement(document, element, "CellTooltip", column.getCellTooltip());
        ConfigurationMarshallerImpl.appendTextElement(document, element, "Width", column.getWidth());
        ConfigurationMarshallerImpl.appendTextElement(document, element, "Align", ConfigurationMarshallerImpl.buildAlign(column));
        ConfigurationMarshallerImpl.appendTextElement(document, element, "Expression", column.getExpression());
        FiltersInit filtersInit = column.getFiltersInit();
        if (filtersInit != null) {
            Element filtersInitElement = ConfigurationMarshallerImpl.marshallFiltersInit(document, filtersInit);
            element.appendChild(filtersInitElement);
        }
        return element;
    }

    private static Boolean isHiddenInAttached(String columnId, List<Column> attachedColumns) {
        return attachedColumns.stream().filter(c -> StringUtils.equals((CharSequence)c.getColumnId(), (CharSequence)columnId)).findFirst().map(Column::getHidden).orElse(Boolean.FALSE);
    }

    private static String buildAlign(Column column) {
        if (column.getAlign() != null) {
            return column.getAlign();
        }
        switch (ColumnType.getByName(column.getType())) {
            case INT: 
            case FLOAT: {
                return ColumnAlignment.RIGHT.getName();
            }
            case DATE: 
            case DATE_STRING: {
                return ColumnAlignment.CENTER.getName();
            }
        }
        return ColumnAlignment.LEFT.getName();
    }

    private static Element marshallFiltersInit(Document document, FiltersInit filtersInit) {
        Element element = document.createElement("FiltersInit");
        ConfigurationMarshallerImpl.marshallFilterInit(document, element, "Eq", filtersInit.getEq());
        ConfigurationMarshallerImpl.marshallFilterInit(document, element, "Gt", filtersInit.getGt());
        ConfigurationMarshallerImpl.marshallFilterInit(document, element, "Lt", filtersInit.getLt());
        return element;
    }

    private static void marshallFilterInit(Document document, Element parent, String nodeName, FilterInit filterInit) {
        if (filterInit != null) {
            ConfigurationMarshallerImpl.appendTextElementWithAttribute(document, parent, nodeName, filterInit.getValue(), new Attribute("type", filterInit.getType()));
        }
    }

    private static void marshallGroupers(Document document, Element parent, GroupingConfiguration grouping, List<Grouper> groupers, String nodeName, List<GroupSum> groupSums) {
        groupers.forEach(g -> ConfigurationMarshallerImpl.appendTextElementWithAttributes(document, parent, nodeName, g.getColumnId(), Arrays.asList(new Attribute("direction", g.getDirection()), new Attribute("startCollapsed", grouping.getNotAttachedStartCollapsed()), new Attribute("enableMenu", grouping.getNotAttachedMenuEnabled()), new Attribute("sumColumns", ConfigurationMarshallerImpl.marshallGroupSums(groupSums)))));
    }

    private static String marshallGroupSums(List<GroupSum> groupSums) {
        return groupSums.stream().map(GroupSum::getColumnId).collect(Collectors.joining(","));
    }

    private static void marshallSorters(Document document, Element parent, List<Sorter> sorters, String nodeName) {
        sorters.forEach(s -> ConfigurationMarshallerImpl.appendTextElementWithAttribute(document, parent, nodeName, s.getColumnId(), new Attribute("direction", s.getDirection())));
    }

    private static Element marshallAttachment(Document document, Configuration configuration) {
        Element element = document.createElement("Attaching");
        ConfigurationMarshallerImpl.setElementAttribute(element, new Attribute("window", configuration.getAttachmentWindow()));
        configuration.getAttachedColumns().stream().filter(Column::getEditable).forEach(c -> ConfigurationMarshallerImpl.appendTextElement(document, element, "Column", c.getColumnId()));
        return element;
    }

    private static Element marshallButtons(Document document, List<Button> buttons) {
        Element element = document.createElement("Buttons");
        buttons.stream().sorted(Comparator.comparingLong(Button::getId)).forEach(b -> {
            Element buttonElement = ConfigurationMarshallerImpl.marshallButton(document, b);
            element.appendChild(buttonElement);
        });
        return element;
    }

    private static Element marshallButton(Document document, Button button) {
        Element element = document.createElement("Button");
        ConfigurationMarshallerImpl.appendTextElement(document, element, "Location", button.getLocation());
        ConfigurationMarshallerImpl.appendTextElement(document, element, "Name", button.getName());
        ConfigurationMarshallerImpl.appendTextElement(document, element, "Action", button.getAction());
        return element;
    }

    private static Element marshallToolbarFields(Document document, List<ToolbarField> toolbarFields) {
        Element element = document.createElement("ToolbarFields");
        toolbarFields.stream().sorted(Comparator.comparingLong(ToolbarField::getId)).forEach(f -> {
            Element toolbarFieldElement = ConfigurationMarshallerImpl.marshallToolbarField(document, f);
            element.appendChild(toolbarFieldElement);
        });
        return element;
    }

    private static Element marshallToolbarField(Document document, ToolbarField toolbarField) {
        Element element = document.createElement("ToolbarField");
        ConfigurationMarshallerImpl.appendTextElement(document, element, "Location", toolbarField.getLocation());
        ConfigurationMarshallerImpl.appendTextElement(document, element, "Id", toolbarField.getFieldId());
        ConfigurationMarshallerImpl.appendTextElement(document, element, "Label", toolbarField.getLabel());
        ConfigurationMarshallerImpl.appendTextElement(document, element, "Operation", toolbarField.getOperation());
        ConfigurationMarshallerImpl.appendTextElement(document, element, "ColumnId", toolbarField.getColumnId());
        ConfigurationMarshallerImpl.appendTextElement(document, element, "VariableId", toolbarField.getVariableId());
        ConfigurationMarshallerImpl.appendTextElement(document, element, "Width", toolbarField.getWidth());
        return element;
    }

    private static Element marshallFilterRelations(Document document, List<FilterRelation> filterRelations) {
        Element element = document.createElement("FilterRelations");
        filterRelations.stream().forEach(f -> {
            Element filterRelationElement = ConfigurationMarshallerImpl.marshallFilterRelation(document, f);
            element.appendChild(filterRelationElement);
        });
        return element;
    }

    private static Element marshallFilterRelation(Document document, FilterRelation filterRelation) {
        Element element = document.createElement("FilterRelation");
        filterRelation.getRelatedFilters().stream().forEach(f -> {
            Element relatedFilterElement = ConfigurationMarshallerImpl.marshallRelatedFilter(document, f);
            element.appendChild(relatedFilterElement);
        });
        return element;
    }

    private static Element marshallRelatedFilter(Document document, RelatedFilter relatedFilter) {
        Element element = document.createElement("RelatedFilter");
        ConfigurationMarshallerImpl.appendTextElement(document, element, "Id", relatedFilter.getFilterId());
        return element;
    }

    private static void marshallPartialAttachment(Document document, Element parent, PartialAttachmentConfiguration partialAttachment) {
        if (partialAttachment != null) {
            ConfigurationMarshallerImpl.appendTextElementWithAttributes(document, parent, "PartialAttachment", partialAttachment.getAmountColumnId(), Arrays.asList(new Attribute("showMySeparated", partialAttachment.getShowMySeparated()), new Attribute("validate", partialAttachment.getValidate()), new Attribute("allowNegative", partialAttachment.getAllowNegative()), new Attribute("controlSubflows", partialAttachment.getControlSubflows())));
        }
    }

    private static Element marshallSave(Document document, Save save) {
        Element element = document.createElement("Save");
        if (save != null) {
            ConfigurationMarshallerImpl.setElementAttributes(element, Arrays.asList(new Attribute("class", save.getCustomClass()), new Attribute("askBeforeSave", save.getAskBeforeSave()), new Attribute("askBeforeClose", save.getAskBeforeClose())));
            save.getActions().stream().sorted(Comparator.comparingLong(SaveAction::getId)).forEach(a -> {
                Element actionElement = ConfigurationMarshallerImpl.marshallSaveAction(document, a);
                element.appendChild(actionElement);
            });
        }
        return element;
    }

    private static Element marshallSaveAction(Document document, SaveAction saveAction) {
        SaveActionType saveActionType = SaveActionType.getByName(saveAction.getType());
        Element element = document.createElement(saveActionType.getXmlName());
        ConfigurationMarshallerImpl.setElementAttribute(element, new Attribute("active", Boolean.TRUE));
        if (saveActionType == SaveActionType.SUMMARY) {
            ConfigurationMarshallerImpl.setElementAttributes(element, Arrays.asList(new Attribute("docClassName", saveAction.getDocumentClassName()), new Attribute("templateName", saveAction.getTemplateName()), new Attribute("userName", saveAction.getUserName()), new Attribute("description", saveAction.getDescription()), new Attribute("horizontalOrientation", saveAction.getHorizontalOrientation()), new Attribute("sortOrder", saveAction.getSortOrder())));
        }
        saveAction.getParameters().stream().sorted(Comparator.comparingLong(SaveActionParameter::getId)).forEach(p -> {
            Element parameterElement = ConfigurationMarshallerImpl.marshallSaveActionParameter(document, p);
            element.appendChild(parameterElement);
        });
        return element;
    }

    private static Element marshallSaveActionParameter(Document document, SaveActionParameter parameter) {
        Element element = document.createElement("Variable");
        ConfigurationMarshallerImpl.setElementAttributes(element, Arrays.asList(new Attribute("type", parameter.getType()), new Attribute("operation", parameter.getOperation()), new Attribute("from", parameter.getFromValue()), new Attribute("to", parameter.getToValue())));
        return element;
    }

    private static void appendTextElement(Document document, Element parent, String elementName, Object text) {
        Element element = document.createElement(elementName);
        element.appendChild(document.createTextNode(ConfigurationMarshallerImpl.defaultString(text)));
        parent.appendChild(element);
    }

    private static void appendTextElementWithAttribute(Document document, Element parent, String elementName, Object text, Attribute attribute) {
        ConfigurationMarshallerImpl.appendTextElementWithAttributes(document, parent, elementName, text, Arrays.asList(attribute));
    }

    private static void appendTextElementWithAttributes(Document document, Element parent, String elementName, Object text, List<Attribute> attributes) {
        Element element = document.createElement(elementName);
        element.appendChild(document.createTextNode(ConfigurationMarshallerImpl.defaultString(text)));
        parent.appendChild(element);
        ConfigurationMarshallerImpl.setElementAttributes(element, attributes);
    }

    private static void setElementAttribute(Element element, Attribute attribute) {
        ConfigurationMarshallerImpl.setElementAttributes(element, Arrays.asList(attribute));
    }

    private static void setElementAttributes(Element element, List<Attribute> attributes) {
        attributes.forEach(a -> element.setAttribute(a.getName(), ConfigurationMarshallerImpl.defaultString(a.getValue())));
    }

    private static String defaultString(Object value) {
        return value != null ? StringUtils.defaultString((String)value.toString()) : "";
    }

    private static ByteArrayOutputStream convertToOutputStream(Document document) throws TransformerException {
        DOMSource source = new DOMSource(document);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(outputStream);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("standalone", "no");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", INDENT);
        transformer.transform(source, result);
        return outputStream;
    }

    private static class Attribute {
        private final String name;
        private final Object value;

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Attribute)) {
                return false;
            }
            Attribute other = (Attribute)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Object this$value = this.getValue();
            Object other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Attribute;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Object $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "ConfigurationMarshallerImpl.Attribute(name=" + this.getName() + ", value=" + this.getValue() + ")";
        }

        @ConstructorProperties(value={"name", "value"})
        public Attribute(String name, Object value) {
            this.name = name;
            this.value = value;
        }
    }
}

