/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.service.partialattachment;

import com.suncode.plugin.pzmodule.dao.partialattachment.PartialAttachmentDao;
import com.suncode.plugin.pzmodule.exception.ImportAttachedException;
import com.suncode.plugin.pzmodule.exception.TemplateGenerationException;
import com.suncode.plugin.pzmodule.model.partialattachment.PartialAttachment;
import com.suncode.plugin.pzmodule.service.partialattachment.PartialAttachmentAdministrationService;
import com.suncode.plugin.pzmodule.translation.Translator;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PartialAttachmentAdministrationServiceImpl
implements PartialAttachmentAdministrationService {
    public static Logger log = Logger.getLogger(PartialAttachmentAdministrationServiceImpl.class);
    private static final List<String> HEADERS = Arrays.asList("configuration_id", "process_id", "string_primary_key_value", "int_primary_key_value", "float_primary_key_value", "amount");
    private static final String EMPTY_STRING_VALUE = "";
    private static final Long EMPTY_INT_VALUE = -1L;
    private static final Double EMPTY_FLOAT_VALUE = -1.0;
    @Autowired
    private PartialAttachmentDao partialAttachmentDao;
    @Autowired
    private Translator translator;

    @Override
    public byte[] generateTemplate() {
        XSSFWorkbook workbook = new XSSFWorkbook();
        this.fillHeader((Workbook)workbook);
        return this.convertToBytes((Workbook)workbook);
    }

    private void fillHeader(Workbook workbook) {
        Sheet sheet = workbook.createSheet();
        CellStyle headerStyle = this.buildHeaderStyle(workbook);
        Row row = sheet.createRow(0);
        int columnNo = 0;
        for (String header : HEADERS) {
            this.buildHeaderCell(row, columnNo, header, headerStyle);
            ++columnNo;
        }
    }

    private CellStyle buildHeaderStyle(Workbook workbook) {
        CellStyle style = workbook.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setFillForegroundColor(IndexedColors.DARK_BLUE.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setFont(this.buildHeaderFont(workbook));
        return style;
    }

    private Font buildHeaderFont(Workbook workbook) {
        Font font = workbook.createFont();
        font.setColor(IndexedColors.WHITE.getIndex());
        font.setBold(true);
        return font;
    }

    private void buildHeaderCell(Row row, int columnNo, String text, CellStyle style) {
        Cell cell = row.createCell(columnNo);
        cell.setCellValue(text);
        cell.setCellStyle(style);
    }

    private byte[] convertToBytes(Workbook workbook) throws TemplateGenerationException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            workbook.write((OutputStream)outputStream);
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        catch (IOException exception) {
            throw new TemplateGenerationException(exception);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
    }

    @Override
    @Transactional
    public void importFromExcel(InputStream inputStream, boolean overrideData) throws ImportAttachedException {
        List<PartialAttachment> partialAttachments = this.readFromExcel(inputStream);
        if (overrideData) {
            this.removeAll();
            this.partialAttachmentDao.flushSession();
        }
        if (CollectionUtils.isNotEmpty(partialAttachments)) {
            this.addAll(partialAttachments);
        }
    }

    private List<PartialAttachment> readFromExcel(InputStream inputStream) throws ImportAttachedException {
        ArrayList<PartialAttachment> partialAttachments = new ArrayList<PartialAttachment>();
        try {
            Workbook workbook = this.createWorkbook(inputStream);
            Iterator<Row> rows = this.getRows(workbook);
            FormulaEvaluator evaluator = workbook.getCreationHelper().createFormulaEvaluator();
            int rowCounter = 1;
            if (rows.hasNext()) {
                rows.next();
                ++rowCounter;
                while (rows.hasNext()) {
                    Row row = rows.next();
                    PartialAttachment partialAttachment = this.readPartialAttachment(row, evaluator);
                    this.validatePartialAttachment(partialAttachment, rowCounter);
                    partialAttachments.add(partialAttachment);
                    ++rowCounter;
                }
            }
            return partialAttachments;
        }
        catch (ImportAttachedException exception) {
            throw exception;
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            String errorMessage = this.buildGlobalErrorMessage();
            throw new ImportAttachedException(errorMessage);
        }
    }

    private Workbook createWorkbook(InputStream inputStream) throws ImportAttachedException, IOException {
        BufferedInputStream wrappedStream = new BufferedInputStream(inputStream);
        return WorkbookFactory.create((InputStream)wrappedStream);
    }

    private Iterator<Row> getRows(Workbook workbook) {
        return workbook.getSheetAt(0).iterator();
    }

    private PartialAttachment readPartialAttachment(Row row, FormulaEvaluator evaluator) {
        PartialAttachment partialAttachment = new PartialAttachment();
        partialAttachment.setConfigurationId(this.getCellValue(row, 0));
        partialAttachment.setProcessId(this.getCellValue(row, 1));
        partialAttachment.setStringPrimaryKeyValue(this.readStringPrimaryKeyValue(this.getCell(row, 2), evaluator));
        partialAttachment.setIntPrimaryKeyValue(this.readIntPrimaryKeyValue(this.getCell(row, 3), evaluator));
        partialAttachment.setFloatPrimaryKeyValue(this.readFloatPrimaryKeyValue(this.getCell(row, 4), evaluator));
        partialAttachment.setAmount(this.readAmount(this.getCell(row, 5), evaluator));
        return partialAttachment;
    }

    private Cell getCell(Row row, int cellNum) {
        return row.getCell(cellNum);
    }

    private String getCellValue(Row row, int cellNum) {
        return Optional.ofNullable(row.getCell(cellNum)).map(c -> c.getStringCellValue()).orElse(EMPTY_STRING_VALUE);
    }

    private String readStringPrimaryKeyValue(Cell cell, FormulaEvaluator evaluator) {
        if (this.isStringCellValue(cell, evaluator)) {
            return StringUtils.defaultString((String)cell.getStringCellValue(), (String)EMPTY_STRING_VALUE);
        }
        if (this.isNumericCellValue(cell, evaluator)) {
            BigDecimal doubleValue = BigDecimal.valueOf(cell.getNumericCellValue());
            return StringUtils.defaultString((String)doubleValue.toPlainString(), (String)EMPTY_STRING_VALUE);
        }
        return EMPTY_STRING_VALUE;
    }

    private Long readIntPrimaryKeyValue(Cell cell, FormulaEvaluator evaluator) {
        if (this.isNumericCellValue(cell, evaluator)) {
            return Double.valueOf(cell.getNumericCellValue()).longValue();
        }
        return EMPTY_INT_VALUE;
    }

    private Double readFloatPrimaryKeyValue(Cell cell, FormulaEvaluator evaluator) {
        if (this.isNumericCellValue(cell, evaluator)) {
            return cell.getNumericCellValue();
        }
        return EMPTY_FLOAT_VALUE;
    }

    private Double readAmount(Cell cell, FormulaEvaluator evaluator) {
        if (this.isNumericCellValue(cell, evaluator)) {
            return cell.getNumericCellValue();
        }
        if (this.isStringCellValue(cell, evaluator)) {
            String stringValue = StringUtils.replace((String)cell.getStringCellValue(), (String)",", (String)".");
            return Double.valueOf(stringValue);
        }
        return null;
    }

    private boolean isStringCellValue(Cell cell, FormulaEvaluator evaluator) {
        return evaluator.evaluateInCell(cell).getCellType() == CellType.STRING;
    }

    private boolean isNumericCellValue(Cell cell, FormulaEvaluator evaluator) {
        return evaluator.evaluateInCell(cell).getCellType() == CellType.NUMERIC;
    }

    private void validatePartialAttachment(PartialAttachment partialAttachment, int rowCounter) throws ImportAttachedException {
        if (this.isAnyDataEmpty(partialAttachment)) {
            String errorMessage = this.buildEmptyDataErrorMessage(rowCounter);
            throw new ImportAttachedException(errorMessage);
        }
    }

    private boolean isAnyDataEmpty(PartialAttachment partialAttachment) {
        return StringUtils.isBlank((CharSequence)partialAttachment.getConfigurationId()) || StringUtils.isBlank((CharSequence)partialAttachment.getProcessId()) || partialAttachment.getAmount() == null;
    }

    private String buildGlobalErrorMessage() {
        return this.translator.translateMessage("pzmodule.administration.importattached.globalerror");
    }

    private String buildUnknownExcelFileErrorMessage() {
        return this.translator.translateMessage("pzmodule.administration.importattached.unknownfile");
    }

    private String buildEmptyDataErrorMessage(int rowCounter) {
        String pattern = this.translator.translateMessage("pzmodule.administration.importattached.emptydata");
        return MessageFormat.format(pattern, rowCounter);
    }

    private void removeAll() {
        this.partialAttachmentDao.deleteAll();
    }

    private void addAll(List<PartialAttachment> partialAttachments) {
        this.partialAttachmentDao.addAll(partialAttachments);
    }
}

