/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.service.configuration;

import com.suncode.plugin.pzmodule.api.dto.configuration.ConfigurationDto;
import com.suncode.plugin.pzmodule.dao.configuration.ConfigurationDao;
import com.suncode.plugin.pzmodule.exception.ManageConfigurationException;
import com.suncode.plugin.pzmodule.holder.ConfigurationDtoHolder;
import com.suncode.plugin.pzmodule.model.configuration.Configuration;
import com.suncode.plugin.pzmodule.service.configuration.AdministrationConfigurationService;
import com.suncode.plugin.pzmodule.service.settings.SettingsService;
import com.suncode.plugin.pzmodule.service.xml.ConfigurationMarshaller;
import com.suncode.plugin.pzmodule.service.xml.ConfigurationUnmarshaller;
import com.suncode.plugin.pzmodule.translation.Translator;
import com.suncode.plugin.pzmodule.web.rest.support.DatumResult;
import com.suncode.plugin.pzmodule.web.rest.support.builder.DatumResultBuilder;
import com.suncode.plugin.pzmodule.web.rest.support.form.ManageConfigurationForm;
import com.suncode.plugin.pzmodule.web.support.dto.configuration.builder.ConfigurationDtoBuilder;
import java.io.ByteArrayOutputStream;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

@Service
public class AdministrationConfigurationServiceImpl
implements AdministrationConfigurationService {
    private static final Logger LOG = Logger.getLogger(AdministrationConfigurationServiceImpl.class);
    private static final String CONFIGURATION_NOT_FOUND_MESSAGE = "pzmodule.program.configuration.notfound";
    private static final String DUPLICATE_CONFIGURATION_ID_MESSAGE = "pzmodule.administration.configuration.duplicate";
    private static final String INVALID_CONFIGURATION_MESSAGE = "pzmodule.administration.configuration.invalid";
    @Autowired
    private ConfigurationDao configurationDao;
    @Autowired
    private ConfigurationDtoBuilder configurationDtoBuilder;
    @Autowired
    private DatumResultBuilder<ConfigurationDto> configurationDatumResultBuilder;
    @Autowired
    private ConfigurationUnmarshaller configurationUnmarshaller;
    @Autowired
    private SettingsService settingsService;
    @Autowired
    private ConfigurationMarshaller configurationMarshaller;
    @Autowired
    private Translator translator;

    @Override
    @Transactional(readOnly=true)
    public List<ConfigurationDto> findAll() {
        List configurations = this.configurationDao.getAll(new String[0]);
        return this.configurationDtoBuilder.buildBasic(configurations);
    }

    @Override
    @Transactional(readOnly=true)
    public ConfigurationDto find(String configurationId) {
        if (StringUtils.isBlank((CharSequence)configurationId)) {
            LOG.warn((Object)"Nie podano identyfikatora konfiguracji modulu PZ");
            return null;
        }
        ConfigurationDto dto = this.getConfiguration(configurationId);
        if (dto == null) {
            Configuration configuration = this.configurationDao.getByConfigurationId(configurationId);
            if (configuration == null) {
                LOG.warn((Object)("Nie istnieje konfiguracja modulu PZ o identyfikatorze " + configurationId));
                return null;
            }
            dto = this.configurationDtoBuilder.build(configuration);
            this.storeConfiguration(configurationId, dto);
        }
        return dto;
    }

    @Override
    @Transactional(readOnly=true)
    public DatumResult<ConfigurationDto> find(Long id) {
        Configuration configuration = (Configuration)this.configurationDao.get(id);
        if (configuration != null) {
            ConfigurationDto dto = this.configurationDtoBuilder.buildBasic(configuration);
            return this.configurationDatumResultBuilder.build(dto);
        }
        return this.configurationDatumResultBuilder.buildError(this.buildConfigurationNotFoundMessage());
    }

    @Override
    @Transactional
    public void add(ManageConfigurationForm form) throws ManageConfigurationException {
        String configurationId = form.getConfigurationId();
        Configuration configuration = this.configurationDao.getByConfigurationId(configurationId);
        if (configuration != null) {
            String message = this.buildDuplicateConfigurationIdMessage();
            throw new ManageConfigurationException(message);
        }
        this.addAndStore(form);
    }

    private void addAndStore(ManageConfigurationForm form) throws ManageConfigurationException {
        Configuration configuration = this.convertXmlToConfiguration(form);
        configuration.setConfigurationId(form.getConfigurationId());
        configuration.setName(form.getName());
        configuration.setDescription(form.getDescription());
        Long id = (Long)this.configurationDao.save(configuration);
        if (id != null) {
            configuration = (Configuration)this.configurationDao.get(id);
            this.storeConfiguration(form.getConfigurationId(), configuration);
        }
    }

    @Override
    @Transactional
    public void edit(Long id, ManageConfigurationForm form) throws ManageConfigurationException {
        Configuration configuration = (Configuration)this.configurationDao.get(id);
        if (configuration == null) {
            String message = this.buildConfigurationNotFoundMessage();
            throw new ManageConfigurationException(message);
        }
        this.edit(configuration, form);
    }

    private void edit(Configuration configuration, ManageConfigurationForm form) throws ManageConfigurationException {
        if (BooleanUtils.isTrue((Boolean)form.getUseFile())) {
            this.removeAndReset(configuration);
            this.configurationDao.flush();
            this.addAndStore(form);
        } else {
            configuration.setName(form.getName());
            configuration.setDescription(form.getDescription());
            this.configurationDao.update(configuration);
        }
    }

    private Configuration convertXmlToConfiguration(ManageConfigurationForm form) throws ManageConfigurationException {
        Configuration configuration = new Configuration();
        return this.convertXmlToConfiguration(configuration, form);
    }

    private Configuration convertXmlToConfiguration(Configuration configuration, ManageConfigurationForm form) throws ManageConfigurationException {
        CommonsMultipartFile file = form.getFile();
        try {
            return this.configurationUnmarshaller.unmarshall(configuration, file.getInputStream());
        }
        catch (Exception exception) {
            LOG.error((Object)exception.getMessage(), (Throwable)exception);
            String message = this.buildInvalidConfigurationMessage();
            throw new ManageConfigurationException(message);
        }
    }

    @Override
    @Transactional
    public void remove(Long id) {
        Configuration configuration = (Configuration)this.configurationDao.get(id);
        if (configuration != null) {
            String configurationId = configuration.getConfigurationId();
            this.removeAndReset(configuration);
            this.settingsService.remove(configurationId);
        }
    }

    private void removeAndReset(Configuration configuration) {
        String configurationId = configuration.getConfigurationId();
        this.configurationDao.delete(configuration);
        this.removeConfiguration(configurationId);
    }

    @Override
    @Transactional(readOnly=true)
    public byte[] download(Long id) {
        Configuration configuration = (Configuration)this.configurationDao.get(id);
        ByteArrayOutputStream outputStream = this.configurationMarshaller.marshall(configuration);
        return outputStream.toByteArray();
    }

    private String buildConfigurationNotFoundMessage() {
        return this.translator.translateMessage(CONFIGURATION_NOT_FOUND_MESSAGE);
    }

    private String buildDuplicateConfigurationIdMessage() {
        return this.translator.translateMessage(DUPLICATE_CONFIGURATION_ID_MESSAGE);
    }

    private String buildInvalidConfigurationMessage() {
        return this.translator.translateMessage(INVALID_CONFIGURATION_MESSAGE);
    }

    private ConfigurationDto getConfiguration(String configurationId) {
        return ConfigurationDtoHolder.get(configurationId);
    }

    private void storeConfiguration(String configurationId, Configuration configuration) {
        ConfigurationDto dto = this.configurationDtoBuilder.build(configuration);
        ConfigurationDtoHolder.store(configurationId, dto);
    }

    private void storeConfiguration(String configurationId, ConfigurationDto dto) {
        ConfigurationDtoHolder.store(configurationId, dto);
    }

    private void removeConfiguration(String configurationId) {
        ConfigurationDtoHolder.remove(configurationId);
    }
}

