/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.resolver.recordsaver;

import com.suncode.plugin.pzmodule.api.dto.configuration.PrimaryKeyDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.SaveActionParameterDto;
import com.suncode.plugin.pzmodule.api.enumeration.ColumnType;
import com.suncode.plugin.pzmodule.api.enumeration.PrimaryKeyType;
import com.suncode.plugin.pzmodule.api.record.Record;
import com.suncode.plugin.pzmodule.api.util.QueryUtils;
import com.suncode.plugin.pzmodule.evaluator.SaveActionParameterEvaluator;
import com.suncode.plugin.pzmodule.exception.SaveActionExecutorException;
import com.suncode.plugin.pzmodule.resolver.recordsaver.UpdateTableQueryResolver;
import com.suncode.plugin.pzmodule.translation.Translator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UpdateTableQueryResolverImpl
implements UpdateTableQueryResolver {
    private static final Logger LOG = Logger.getLogger(UpdateTableQueryResolverImpl.class);
    private static final String CONFIGURATION_ERROR_MESSAGE = "pzmodule.program.configuration.error";
    @Autowired
    private SaveActionParameterEvaluator saveActionParameterEvaluator;
    @Autowired
    private Translator translator;

    @Override
    public String resolve(String tableName, PrimaryKeyDto primaryKey, Map<String, ColumnType> columnTypes, List<SaveActionParameterDto> saveActionParameters, Record record, List<Record> records, Map<String, Object> activityContext) throws SaveActionExecutorException {
        ArrayList<String> updateValues = new ArrayList<String>();
        String primaryKeyName = primaryKey.getName();
        PrimaryKeyType primaryKeyType = PrimaryKeyType.getByName(primaryKey.getType());
        String primaryKeyValue = record.getValue(primaryKeyName);
        for (SaveActionParameterDto saveActionParameter : saveActionParameters) {
            updateValues.add(this.resolveUpdateValuePart(columnTypes, saveActionParameter, record, records, activityContext));
        }
        StringBuilder query = new StringBuilder("UPDATE ");
        query.append(tableName);
        query.append(" SET ");
        query.append(StringUtils.join(updateValues, (String)", "));
        query.append(" WHERE ");
        query.append(primaryKeyName);
        query.append("=");
        query.append(primaryKeyType.getConditionSuffix());
        query.append(QueryUtils.getSafeValue(primaryKeyValue));
        query.append(primaryKeyType.getConditionSuffix());
        return query.toString();
    }

    private String buildConfigurationErrorMessage() {
        return this.translator.translateMessage(CONFIGURATION_ERROR_MESSAGE);
    }

    private String resolveUpdateValuePart(Map<String, ColumnType> columnTypes, SaveActionParameterDto saveActionParameter, Record record, List<Record> records, Map<String, Object> activityContext) throws SaveActionExecutorException {
        StringBuilder part = new StringBuilder();
        String to = saveActionParameter.getToValue();
        if (this.isIncorrectToValue(columnTypes, to)) {
            LOG.error((Object)"Brak wartosci docelowej lub niepoprawna wartosc dla parametru akcji zapisu");
            throw new SaveActionExecutorException(this.buildConfigurationErrorMessage());
        }
        ColumnType columnType = columnTypes.get(to);
        String value = this.saveActionParameterEvaluator.evaluate(saveActionParameter, record, records, activityContext);
        part.append(to);
        part.append("=");
        part.append(columnType.getConditionSuffix());
        part.append(QueryUtils.getSafeValue(value));
        part.append(columnType.getConditionSuffix());
        return part.toString();
    }

    private boolean isIncorrectToValue(Map<String, ColumnType> columnTypes, String to) {
        return StringUtils.isBlank((CharSequence)to) || !columnTypes.containsKey(to);
    }
}

