/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.resolver.recordsaver;

import com.suncode.plugin.pzmodule.api.dto.configuration.SaveActionParameterDto;
import com.suncode.plugin.pzmodule.api.record.Record;
import com.suncode.plugin.pzmodule.evaluator.SaveActionParameterEvaluator;
import com.suncode.plugin.pzmodule.exception.SaveActionExecutorException;
import com.suncode.plugin.pzmodule.resolver.recordsaver.IndexValueResolver;
import com.suncode.pwfl.archive.DocumentClassIndex;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IndexValueResolverImpl
implements IndexValueResolver {
    @Autowired
    private SaveActionParameterEvaluator saveActionParameterEvaluator;

    @Override
    public Object resolve(DocumentClassIndex index, SaveActionParameterDto saveActionParameter, List<Record> attachedRecords, Map<String, Object> activityContext) throws SaveActionExecutorException {
        Record emptyRecord = new Record();
        String value = this.saveActionParameterEvaluator.evaluate(saveActionParameter, emptyRecord, attachedRecords, activityContext);
        switch (index.getType()) {
            case LONG: {
                return this.resolveLongIndexValue(value);
            }
            case DOUBLE: {
                return this.resolveDoubleIndexValue(value);
            }
            case DATE: {
                return this.resolveDateIndexValue(value);
            }
        }
        return this.resolveStringIndexValue(value);
    }

    private Long resolveLongIndexValue(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return new Long(0L);
        }
        return new Long(value);
    }

    private Float resolveDoubleIndexValue(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return new Float(0.0f);
        }
        value = value.replaceAll("[\\\\]", "");
        value = value.replaceAll("[,]", ".");
        value = value.replaceAll("[ ]", "");
        return new Float(value);
    }

    private Date resolveDateIndexValue(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return new Date(0L);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return dateFormat.parse(value);
        }
        catch (ParseException exception) {
            return new Date(0L);
        }
    }

    private String resolveStringIndexValue(String value) {
        return StringUtils.defaultString((String)value);
    }
}

