/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.resolver.recordprovider;

import com.suncode.plugin.pzmodule.api.dto.configuration.ConfigurationDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.PartialAttachmentConfigurationDto;
import com.suncode.plugin.pzmodule.api.exception.RecordProviderException;
import com.suncode.plugin.pzmodule.api.info.SearchInfo;
import com.suncode.plugin.pzmodule.api.result.GroupSumResult;
import com.suncode.plugin.pzmodule.api.result.SumAllResult;
import com.suncode.plugin.pzmodule.api.translation.ColumnTranslation;
import com.suncode.plugin.pzmodule.api.util.MathUtils;
import com.suncode.plugin.pzmodule.resolver.recordprovider.DataResultResolver;
import com.suncode.plugin.pzmodule.resolver.recordprovider.RecordSumResolver;
import com.suncode.plugin.pzmodule.translation.Translator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.type.AbstractStandardBasicType;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RecordSumResolverImpl
implements RecordSumResolver {
    private static final Logger LOG = Logger.getLogger(RecordSumResolverImpl.class);
    private static final String DATA_SEARCH_ERROR_MESSAGE = "pzmodule.program.record.datasearcherror";
    @Autowired
    private SessionFactory sessionFactory;
    @Autowired
    private DataResultResolver dataResultResolver;
    @Autowired
    private Translator translator;

    @Override
    public List<GroupSumResult> resolveSumInGroups(String sumsQuery, ConfigurationDto configuration, List<String> resultColumnIds, Map<String, AbstractStandardBasicType<?>> scalars, SearchInfo searchInfo, ColumnTranslation columnTranslation) throws RecordProviderException {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.sessionFactory.openSession();
            transaction = session.beginTransaction();
            List<GroupSumResult> sums = this.getSums(session, sumsQuery, configuration, resultColumnIds, scalars, searchInfo, columnTranslation);
            transaction.commit();
            List<GroupSumResult> list = sums;
            return list;
        }
        catch (Exception exception) {
            LOG.error((Object)exception.getMessage(), (Throwable)exception);
            if (transaction != null && session.isOpen()) {
                transaction.rollback();
            }
            throw new RecordProviderException(this.buildDataSearchErrorMessage());
        }
        finally {
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }

    private List<GroupSumResult> getSums(Session session, String query, ConfigurationDto configuration, List<String> resultColumnIds, Map<String, AbstractStandardBasicType<?>> scalars, SearchInfo searchInfo, ColumnTranslation columnTranslation) {
        SQLQuery sumsSqlQuery = session.createSQLQuery(query);
        sumsSqlQuery.setReadOnly(true);
        for (String scalarId : scalars.keySet()) {
            sumsSqlQuery.addScalar(scalarId, (Type)scalars.get(scalarId));
        }
        List<Object[]> dataResult = this.dataResultResolver.resolve(sumsSqlQuery);
        return this.getSums(dataResult, configuration, resultColumnIds, searchInfo, columnTranslation);
    }

    private List<GroupSumResult> getSums(List<Object[]> dataResult, ConfigurationDto configuration, List<String> resultColumnIds, SearchInfo searchInfo, ColumnTranslation columnTranslation) {
        ArrayList<GroupSumResult> sums = new ArrayList<GroupSumResult>();
        if (CollectionUtils.isNotEmpty(dataResult)) {
            for (int i = 0; i < resultColumnIds.size(); ++i) {
                String columnId = resultColumnIds.get(i);
                String dataIndex = columnTranslation.getRealName(columnId);
                Double sum = 0.0;
                for (Object[] datumResult : dataResult) {
                    Double oneSum = (Double)datumResult[i];
                    sum = MathUtils.add(sum, oneSum);
                }
                if (this.isPartialAttachmentShowMySeparatedActiveForGroupSum(configuration, dataIndex)) {
                    sum = MathUtils.subtract(sum, searchInfo.getGroupAmount());
                }
                sums.add(this.buildGroupSumResult(dataIndex, sum));
            }
        }
        return sums;
    }

    private boolean isPartialAttachmentShowMySeparatedActiveForGroupSum(ConfigurationDto configuration, String dataIndex) {
        PartialAttachmentConfigurationDto partialAttachmentConfiguration = configuration.getPartialAttachmentConfiguration();
        return BooleanUtils.isTrue((Boolean)partialAttachmentConfiguration.getShowMySeparated()) && StringUtils.equals((CharSequence)partialAttachmentConfiguration.getAmountColumnId(), (CharSequence)dataIndex);
    }

    private GroupSumResult buildGroupSumResult(String dataIndex, Double sum) {
        GroupSumResult result = new GroupSumResult();
        result.setColumnId(dataIndex);
        result.setSum(sum);
        return result;
    }

    private String buildDataSearchErrorMessage() {
        return this.translator.translateMessage(DATA_SEARCH_ERROR_MESSAGE);
    }

    @Override
    public SumAllResult resolveSumAll(String sumsQuery, ConfigurationDto configuration, String resultColumnId, Map<String, AbstractStandardBasicType<?>> scalars, SearchInfo searchInfo, ColumnTranslation columnTranslation) throws RecordProviderException {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.sessionFactory.openSession();
            transaction = session.beginTransaction();
            SumAllResult sum = this.getSum(session, sumsQuery, configuration, resultColumnId, scalars, searchInfo, columnTranslation);
            transaction.commit();
            SumAllResult sumAllResult = sum;
            return sumAllResult;
        }
        catch (Exception exception) {
            LOG.error((Object)exception.getMessage(), (Throwable)exception);
            if (transaction != null && session.isOpen()) {
                transaction.rollback();
            }
            throw new RecordProviderException(this.buildDataSearchErrorMessage());
        }
        finally {
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }

    private SumAllResult getSum(Session session, String query, ConfigurationDto configuration, String resultColumnId, Map<String, AbstractStandardBasicType<?>> scalars, SearchInfo searchInfo, ColumnTranslation columnTranslation) {
        SQLQuery sumSqlQuery = session.createSQLQuery(query);
        sumSqlQuery.setReadOnly(true);
        for (String scalarId : scalars.keySet()) {
            sumSqlQuery.addScalar(scalarId, (Type)scalars.get(scalarId));
        }
        List<Object[]> dataResult = this.dataResultResolver.resolve(sumSqlQuery);
        return this.getSum(dataResult, configuration, resultColumnId, searchInfo, columnTranslation);
    }

    private SumAllResult getSum(List<Object[]> dataResult, ConfigurationDto configuration, String resultColumnId, SearchInfo searchInfo, ColumnTranslation columnTranslation) {
        String dataIndex = columnTranslation.getRealName(resultColumnId);
        Double sum = 0.0;
        for (Object[] datumResult : dataResult) {
            Double oneSum = (Double)datumResult[0];
            sum = MathUtils.add(sum, oneSum);
        }
        if (this.isPartialAttachmentShowMySeparatedActiveForGroupSum(configuration, dataIndex)) {
            sum = MathUtils.subtract(sum, searchInfo.getGroupAmount());
        }
        return this.buildSumAllResult(sum);
    }

    private SumAllResult buildSumAllResult(Double sum) {
        SumAllResult result = new SumAllResult();
        result.setSum(sum);
        return result;
    }
}

