/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.resolver.recordprovider;

import com.suncode.plugin.pzmodule.api.dto.configuration.ConfigurationDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.PanelsConfigurationDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.PartialAttachmentConfigurationDto;
import com.suncode.plugin.pzmodule.api.exception.RecordProviderException;
import com.suncode.plugin.pzmodule.api.info.PagingInfo;
import com.suncode.plugin.pzmodule.api.info.SearchInfo;
import com.suncode.plugin.pzmodule.api.record.Record;
import com.suncode.plugin.pzmodule.api.record.RecordPage;
import com.suncode.plugin.pzmodule.api.translation.ColumnTranslation;
import com.suncode.plugin.pzmodule.api.util.MathUtils;
import com.suncode.plugin.pzmodule.evaluator.RecordExpressionEvaluator;
import com.suncode.plugin.pzmodule.resolver.recordprovider.BindedColumn;
import com.suncode.plugin.pzmodule.resolver.recordprovider.Binding;
import com.suncode.plugin.pzmodule.resolver.recordprovider.DataResultResolver;
import com.suncode.plugin.pzmodule.resolver.recordprovider.RecordPageResolver;
import com.suncode.plugin.pzmodule.translation.Translator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.type.AbstractStandardBasicType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RecordPageResolverImpl
implements RecordPageResolver {
    private static final Logger LOG = Logger.getLogger(RecordPageResolverImpl.class);
    private static final String ZERO = "0";
    private static final String DATA_SEARCH_ERROR_MESSAGE = "pzmodule.program.record.datasearcherror";
    @Autowired
    private SessionFactory sessionFactory;
    @Autowired
    private DataResultResolver dataResultResolver;
    @Autowired
    private RecordExpressionEvaluator recordExpressionEvaluator;
    @Autowired
    private Translator translator;

    @Override
    public RecordPage resolve(boolean attached, String dataQuery, String countQuery, ConfigurationDto configuration, List<String> resultColumnIds, Map<String, AbstractStandardBasicType<?>> scalars, Map<String, String> expressions, Map<String, String> dateStringInputFormats, Binding binding, SearchInfo searchInfo, PagingInfo pagingInfo, ColumnTranslation columnTranslation) throws RecordProviderException {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.sessionFactory.openSession();
            transaction = session.beginTransaction();
            List<Record> data = this.getData(session, attached, dataQuery, configuration, resultColumnIds, scalars, expressions, dateStringInputFormats, binding, searchInfo, pagingInfo, columnTranslation);
            long total = this.getTotal(session, countQuery, configuration.getPanelsConfiguration(), searchInfo, data);
            transaction.commit();
            RecordPage recordPage = new RecordPage(data, total);
            return recordPage;
        }
        catch (Exception exception) {
            LOG.error((Object)exception.getMessage(), (Throwable)exception);
            if (transaction != null && session.isOpen()) {
                transaction.rollback();
            }
            throw new RecordProviderException(this.buildDataSearchErrorMessage());
        }
        finally {
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }

    private List<Record> getData(Session session, boolean attached, String query, ConfigurationDto configuration, List<String> resultColumnIds, Map<String, AbstractStandardBasicType<?>> scalars, Map<String, String> expressions, Map<String, String> dateStringInputFormats, Binding binding, SearchInfo searchInfo, PagingInfo pagingInfo, ColumnTranslation columnTranslation) {
        SQLQuery dataSqlQuery = session.createSQLQuery(query);
        dataSqlQuery.setReadOnly(true);
        if (this.shouldApplyPaging(attached, configuration.getPanelsConfiguration())) {
            dataSqlQuery.setFirstResult(pagingInfo.getStart().intValue());
            dataSqlQuery.setMaxResults(pagingInfo.getLimit().intValue());
        }
        for (String scalarId : scalars.keySet()) {
            dataSqlQuery.addScalar(scalarId, (Type)scalars.get(scalarId));
        }
        List<Object[]> dataResult = this.dataResultResolver.resolve(dataSqlQuery);
        return this.getData(dataResult, configuration, resultColumnIds, expressions, dateStringInputFormats, binding, searchInfo, columnTranslation);
    }

    private boolean shouldApplyPaging(boolean attached, PanelsConfigurationDto panelsConfiguration) {
        return !attached && BooleanUtils.isNotTrue((Boolean)panelsConfiguration.getNotAttachedPagingDisabled());
    }

    private List<Record> getData(List<Object[]> dataResult, ConfigurationDto configuration, List<String> resultColumnIds, Map<String, String> expressions, Map<String, String> dateStringInputFormats, Binding binding, SearchInfo searchInfo, ColumnTranslation columnTranslation) {
        ArrayList<Record> data = new ArrayList<Record>();
        if (CollectionUtils.isNotEmpty(dataResult)) {
            Map<String, Double> amounts = searchInfo.getAmounts();
            for (Object[] datumResult : dataResult) {
                data.add(this.getDatum(datumResult, configuration, resultColumnIds, expressions, dateStringInputFormats, binding, searchInfo, amounts, columnTranslation));
            }
        }
        return data;
    }

    private Record getDatum(Object[] datumResult, ConfigurationDto configuration, List<String> resultColumnIds, Map<String, String> expressions, Map<String, String> dateStringInputFormats, Binding binding, SearchInfo searchInfo, Map<String, Double> amounts, ColumnTranslation columnTranslation) {
        Record record = new Record();
        PartialAttachmentConfigurationDto partialAttachmentConfiguration = configuration.getPartialAttachmentConfiguration();
        String primaryKeyName = configuration.getSearch().getLocation().getPrimaryKey().getName();
        for (int i = 0; i < resultColumnIds.size(); ++i) {
            String columnId = resultColumnIds.get(i);
            String dataIndex = columnTranslation.getRealName(columnId);
            Object value = datumResult[i];
            String stringValue = this.getValueAsString(value, dataIndex, dateStringInputFormats);
            record.setValue(dataIndex, stringValue);
        }
        if (CollectionUtils.isNotEmpty(binding.getBindedColumns())) {
            Map<String, Object> activityContext = searchInfo.getActivityContext();
            binding.getBindedColumns().forEach(bindedColumn -> this.bindValueToRecord(record, (BindedColumn)bindedColumn, binding.getPrimaryKeyVariableId(), primaryKeyName, activityContext, dateStringInputFormats));
        }
        if (BooleanUtils.isNotTrue((Boolean)searchInfo.getPreventAmount()) && this.isPartialAttachmentActive(partialAttachmentConfiguration)) {
            String primaryKeyValue;
            Double currentAmount;
            String stringPartialAmount = (String)StringUtils.defaultIfBlank((CharSequence)record.getValue("PZ_PARTIAL_AMOUNT"), (CharSequence)ZERO);
            Double newAmount = Double.valueOf(stringPartialAmount);
            if (BooleanUtils.isTrue((Boolean)partialAttachmentConfiguration.getShowMySeparated()) && (currentAmount = amounts.get(primaryKeyValue = (String)record.get(primaryKeyName))) != null) {
                newAmount = MathUtils.subtract(newAmount, currentAmount);
            }
            record.setValue(partialAttachmentConfiguration.getAmountColumnId(), newAmount.toString());
        }
        return this.evaluateExpressions(record, searchInfo, expressions);
    }

    private void bindValueToRecord(Record record, BindedColumn bindedColumn, String primaryKeyVariableId, String primaryKeyName, Map<String, Object> activityContext, Map<String, String> dateStringInputFormats) {
        if (this.shouldBindDtValue(bindedColumn, primaryKeyVariableId)) {
            this.bindValueFromDtToRecord(record, bindedColumn, primaryKeyVariableId, primaryKeyName, activityContext, dateStringInputFormats);
        } else {
            this.bindValueFromFormToRecord(record, bindedColumn, activityContext, dateStringInputFormats);
        }
    }

    private boolean shouldBindDtValue(BindedColumn bindedColumn, String primaryKeyVariableId) {
        return bindedColumn.isInDt() && StringUtils.isNotBlank((CharSequence)primaryKeyVariableId);
    }

    private void bindValueFromDtToRecord(Record record, BindedColumn bindedColumn, String primaryKeyVariableId, String primaryKeyName, Map<String, Object> activityContext, Map<String, String> dateStringInputFormats) {
        String[] activityVariableValues;
        String[] activityPrimaryKeyValues;
        String recordPrimaryKeyValue = record.getValue(primaryKeyName);
        int valueIndex = this.getValueIndex(recordPrimaryKeyValue, activityPrimaryKeyValues = this.splitActivityValue(activityContext, primaryKeyVariableId));
        if (valueIndex != -1 && (activityVariableValues = this.splitActivityValue(activityContext, bindedColumn.getVariableId())).length > valueIndex) {
            String activityVariableValue = activityVariableValues[valueIndex];
            this.bindValueToRecord(record, bindedColumn, activityVariableValue, dateStringInputFormats);
        }
    }

    private void bindValueFromFormToRecord(Record record, BindedColumn bindedColumn, Map<String, Object> activityContext, Map<String, String> dateStringInputFormats) {
        Object value = activityContext.get(bindedColumn.getVariableId());
        this.bindValueToRecord(record, bindedColumn, value, dateStringInputFormats);
    }

    private String[] splitActivityValue(Map<String, Object> activityContext, String variableId) {
        Object value = activityContext.get(variableId);
        if (value != null) {
            return value.toString().split(";");
        }
        return new String[0];
    }

    private int getValueIndex(String referenceValue, String[] allValues) {
        return IntStream.range(0, allValues.length).filter(index -> StringUtils.equals((CharSequence)referenceValue, (CharSequence)allValues[index])).findFirst().orElse(-1);
    }

    private void bindValueToRecord(Record record, BindedColumn bindedColumn, Object value, Map<String, String> dateStringInputFormats) {
        String dataIndex = bindedColumn.getColumnDataIndex();
        String stringValue = this.getValueAsString(value, dataIndex, dateStringInputFormats);
        record.setValue(dataIndex, stringValue);
    }

    private String getValueAsString(Object value, String dataIndex, Map<String, String> dateStringInputFormats) {
        if (this.shouldConvertDateString(value, dataIndex, dateStringInputFormats)) {
            return this.convertDateString(value.toString(), dateStringInputFormats.get(dataIndex));
        }
        if (value != null) {
            return value.toString();
        }
        return "";
    }

    private boolean isPartialAttachmentActive(PartialAttachmentConfigurationDto partialAttachmentConfiguration) {
        return StringUtils.isNotBlank((CharSequence)partialAttachmentConfiguration.getAmountColumnId());
    }

    private Record evaluateExpressions(Record record, SearchInfo searchInfo, Map<String, String> expressions) {
        return this.recordExpressionEvaluator.evaluate(record, searchInfo.getActivityContext(), searchInfo.getExtraParameters(), expressions);
    }

    private boolean shouldConvertDateString(Object value, String columnId, Map<String, String> dateStringInputFormats) {
        return value != null && dateStringInputFormats.containsKey(columnId);
    }

    private String convertDateString(String value, String inputFormat) {
        if (StringUtils.isBlank((CharSequence)value) || StringUtils.isBlank((CharSequence)inputFormat)) {
            return value;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat();
        dateFormat.applyPattern(inputFormat);
        try {
            Date date = dateFormat.parse(value);
            dateFormat.applyPattern("yyyy-MM-dd");
            return dateFormat.format(date);
        }
        catch (ParseException exception) {
            LOG.error((Object)exception.getMessage(), (Throwable)exception);
            return value;
        }
    }

    private long getTotal(Session session, String query, PanelsConfigurationDto panelsConfiguration, SearchInfo searchInfo, List<Record> data) {
        if (this.shouldExecuteCountQuery(panelsConfiguration, searchInfo)) {
            return this.getTotal(session, query);
        }
        return CollectionUtils.size(data);
    }

    private boolean shouldExecuteCountQuery(PanelsConfigurationDto panelsConfiguration, SearchInfo searchInfo) {
        return BooleanUtils.isNotTrue((Boolean)panelsConfiguration.getNotAttachedPagingDisabled()) && BooleanUtils.isNotTrue((Boolean)searchInfo.getPreventCount());
    }

    private long getTotal(Session session, String query) {
        SQLQuery countSqlQuery = session.createSQLQuery(query);
        countSqlQuery.setReadOnly(true);
        countSqlQuery.addScalar("PZ_TOTAL_COUNT", (Type)StandardBasicTypes.LONG);
        return (Long)countSqlQuery.uniqueResult();
    }

    private String buildDataSearchErrorMessage() {
        return this.translator.translateMessage(DATA_SEARCH_ERROR_MESSAGE);
    }
}

