/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.executor.save.record;

import com.suncode.plugin.pzmodule.api.dto.configuration.ConfigurationDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.SaveActionDto;
import com.suncode.plugin.pzmodule.api.enumeration.RecordLocation;
import com.suncode.plugin.pzmodule.api.info.SaveInfo;
import com.suncode.plugin.pzmodule.api.record.Record;
import com.suncode.plugin.pzmodule.exception.SaveActionExecutorException;
import com.suncode.plugin.pzmodule.executor.save.record.SaveActionExecutor;
import com.suncode.plugin.pzmodule.web.rest.support.RestUtils;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.FileFinder;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.enhydra.shark.api.SharkTransaction;
import org.hibernate.Session;
import org.springframework.stereotype.Component;

@Component(value="attachToProcessSaveActionExecutor")
public class AttachToProcessSaveActionExecutorImpl
implements SaveActionExecutor {
    @Override
    public void execute(SharkTransaction sharkTransaction, Session session, ConfigurationDto configuration, SaveActionDto saveAction, SaveInfo saveInfo, List<Record> attachedRecords) throws SaveActionExecutorException {
        if (this.isDocumentClassRecordLocation(configuration)) {
            String processId = saveInfo.getProcessId();
            List<String> processFileIds = this.getProcessFileIds(processId);
            List<String> attachedFileIds = this.getAttachedFileIds(attachedRecords);
            DocumentService documentService = ServiceFactory.getDocumentService();
            for (String fileId : processFileIds) {
                if (!attachedFileIds.contains(fileId)) {
                    WfDocument document = documentService.getDocument(Long.valueOf(fileId));
                    documentService.detachDocumentFromProcess(document, processId);
                    continue;
                }
                attachedFileIds.remove(fileId);
            }
            if (CollectionUtils.isNotEmpty(attachedFileIds)) {
                String userId = RestUtils.getUserIdFromSession();
                String activityId = saveInfo.getActivityId();
                for (String fileId : attachedFileIds) {
                    WfDocument document = documentService.getDocument(new Long(fileId));
                    documentService.attachDocumentToProcess(document, userId, processId, activityId);
                }
            }
        }
    }

    private boolean isDocumentClassRecordLocation(ConfigurationDto configuration) {
        RecordLocation recordLocation = RecordLocation.getByName(configuration.getSearch().getLocation().getType());
        return recordLocation.equals((Object)RecordLocation.DOCUMENT_CLASS);
    }

    private List<String> getProcessFileIds(String processId) {
        ArrayList<String> processFileIds = new ArrayList<String>();
        FileFinder fileFinder = FinderFactory.getFileFinder();
        List files = fileFinder.getDocumentsFromProcess(processId, new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)files)) {
            for (WfFile file : files) {
                processFileIds.add(this.getProcessFileId(file));
            }
        }
        return processFileIds;
    }

    private String getProcessFileId(WfFile file) {
        return String.valueOf(file.getId());
    }

    private List<String> getAttachedFileIds(List<Record> attachedRecords) {
        ArrayList<String> attachedFileIds = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(attachedRecords)) {
            for (Record record : attachedRecords) {
                attachedFileIds.add(this.getAttachedFileId(record));
            }
        }
        return attachedFileIds;
    }

    private String getAttachedFileId(Record record) {
        return record.getValue("fileid");
    }
}

