/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.evaluator;

import com.suncode.plugin.pzmodule.api.record.Record;
import com.suncode.plugin.pzmodule.evaluator.ExpressionEvaluator;
import com.suncode.plugin.pzmodule.evaluator.RecordExpressionEvaluator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RecordExpressionEvaluatorImpl
implements RecordExpressionEvaluator {
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\[\\$(.+?)\\]");
    private static final Pattern RECORD_PATTERN = Pattern.compile("\\[(.+?)\\]");
    private static final String ZERO = "0";
    @Autowired
    private ExpressionEvaluator expressionEvaluator;

    @Override
    public Record evaluate(Record record, Map<String, Object> activityContext, Map<String, Object> extraParameters, Map<String, String> expressions) {
        if (MapUtils.isNotEmpty(expressions)) {
            for (Map.Entry<String, String> entry : expressions.entrySet()) {
                String columnId = entry.getKey();
                String expression = entry.getValue();
                record.setValue(columnId, this.evaluateExpression(record, activityContext, extraParameters, expression));
            }
        }
        return record;
    }

    public String evaluateExpression(Record record, Map<String, Object> activityContext, Map<String, Object> extraParameters, String expression) {
        Map<String, Object> variablesMap = this.buildVariablesMap(activityContext, extraParameters);
        String filledExpression = this.fillExpression(variablesMap, expression, VARIABLE_PATTERN);
        filledExpression = this.fillExpression(record, filledExpression, RECORD_PATTERN);
        return this.expressionEvaluator.evaluate(filledExpression);
    }

    private Map<String, Object> buildVariablesMap(Map<String, Object> activityContext, Map<String, Object> extraParameters) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.putAll(activityContext);
        map.putAll(extraParameters);
        return map;
    }

    private String fillExpression(Map<?, ?> dataSource, String expression, Pattern pattern) {
        Matcher matcher = pattern.matcher(expression);
        String filledExpression = new String(expression);
        while (matcher.find()) {
            String phrase = matcher.group();
            String columnId = matcher.group(1);
            String value = Optional.ofNullable(dataSource.get(columnId)).map(Object::toString).orElse(null);
            if (StringUtils.isNotBlank((CharSequence)value)) {
                value = value.replaceAll(",", ".").replaceAll(" ", "");
                filledExpression = filledExpression.replace(phrase, value);
                continue;
            }
            filledExpression = filledExpression.replace(phrase, ZERO);
        }
        return filledExpression;
    }
}

