/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.api.enumeration;

import com.suncode.plugin.pzmodule.api.record.Record;
import com.suncode.plugin.pzmodule.api.util.MathUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

public enum SaveActionParameterOperation {
    CURRENT("current"){

        @Override
        public String calculate(String from, Record record, List<Record> attachedRecords, Map<String, Object> activityContext, String valueJoiner, boolean accumulate) {
            Assert.hasText((String)from);
            return record.getValue(from);
        }
    }
    ,
    VALUE("value"){

        @Override
        public String calculate(String from, Record record, List<Record> attachedRecords, Map<String, Object> activityContext, String valueJoiner, boolean accumulate) {
            Assert.hasText((String)from);
            ArrayList<String> values = new ArrayList<String>();
            if (2.hasRecords(attachedRecords)) {
                for (Record attachedRecord : attachedRecords) {
                    values.add(attachedRecord.getValue(from));
                }
            }
            return StringUtils.join(values, (String)valueJoiner);
        }
    }
    ,
    FIXED("fixed"){

        @Override
        public String calculate(String from, Record record, List<Record> attachedRecords, Map<String, Object> activityContext, String valueJoiner, boolean accumulate) {
            return this.accumulateResult(from, valueJoiner, accumulate);
        }
    }
    ,
    SUM_INT("sumint"){

        @Override
        public String calculate(String from, Record record, List<Record> attachedRecords, Map<String, Object> activityContext, String valueJoiner, boolean accumulate) {
            Assert.hasText((String)from);
            Double result = this.sum(from, attachedRecords);
            result = MathUtils.round(result, INTEGER_ACCURACY);
            String stringResult = result.toString();
            return this.accumulateResult(stringResult, valueJoiner, accumulate);
        }
    }
    ,
    SUM_FLOAT("sumfloat"){

        @Override
        public String calculate(String from, Record record, List<Record> attachedRecords, Map<String, Object> activityContext, String valueJoiner, boolean accumulate) {
            Assert.hasText((String)from);
            Double result = this.sum(from, attachedRecords);
            String stringResult = result.toString();
            return this.accumulateResult(stringResult, valueJoiner, accumulate);
        }
    }
    ,
    MULTIPLY_INT("multiplyint"){

        @Override
        public String calculate(String from, Record record, List<Record> attachedRecords, Map<String, Object> activityContext, String valueJoiner, boolean accumulate) {
            Assert.hasText((String)from);
            Double result = this.multiply(from, attachedRecords);
            result = MathUtils.round(result, INTEGER_ACCURACY);
            String stringResult = result.toString();
            return this.accumulateResult(stringResult, valueJoiner, accumulate);
        }
    }
    ,
    MULTIPLY_FLOAT("multiplyfloat"){

        @Override
        public String calculate(String from, Record record, List<Record> attachedRecords, Map<String, Object> activityContext, String valueJoiner, boolean accumulate) {
            Assert.hasText((String)from);
            Double result = this.multiply(from, attachedRecords);
            String stringResult = result.toString();
            return this.accumulateResult(stringResult, valueJoiner, accumulate);
        }
    }
    ,
    AVERAGE("avg"){

        @Override
        public String calculate(String from, Record record, List<Record> attachedRecords, Map<String, Object> activityContext, String valueJoiner, boolean accumulate) {
            Assert.hasText((String)from);
            Double result = this.sum(from, attachedRecords);
            double total = new Double(attachedRecords.size());
            result = MathUtils.divide(result, total);
            String stringResult = result.toString();
            return this.accumulateResult(stringResult, valueJoiner, accumulate);
        }
    }
    ,
    AMOUNT("amount"){

        @Override
        public String calculate(String from, Record record, List<Record> attachedRecords, Map<String, Object> activityContext, String valueJoiner, boolean accumulate) {
            String stringResult = String.valueOf(attachedRecords.size());
            return this.accumulateResult(stringResult, valueJoiner, accumulate);
        }
    }
    ,
    VARIABLE("variable"){

        @Override
        public String calculate(String from, Record record, List<Record> attachedRecords, Map<String, Object> activityContext, String valueJoiner, boolean accumulate) {
            Assert.hasText((String)from);
            String stringResult = "";
            Object result = activityContext.get(from);
            if (result != null) {
                stringResult = result.toString();
            }
            return this.accumulateResult(stringResult, valueJoiner, accumulate);
        }
    }
    ,
    UNKNOWN(""){

        @Override
        public String calculate(String from, Record record, List<Record> attachedRecords, Map<String, Object> activityContext, String valueJoiner, boolean accumulate) {
            return null;
        }
    };

    private String name;
    private static final int INTEGER_ACCURACY;

    private SaveActionParameterOperation(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static SaveActionParameterOperation getByName(String name) {
        for (SaveActionParameterOperation saveActionParameterOperation : SaveActionParameterOperation.values()) {
            if (!StringUtils.equals((CharSequence)name, (CharSequence)saveActionParameterOperation.getName())) continue;
            return saveActionParameterOperation;
        }
        return UNKNOWN;
    }

    public abstract String calculate(String var1, Record var2, List<Record> var3, Map<String, Object> var4, String var5, boolean var6);

    public Double sum(String from, List<Record> attachedRecords) {
        Double result = new Double(0.0);
        if (SaveActionParameterOperation.hasRecords(attachedRecords)) {
            for (Record record : attachedRecords) {
                String tempValue = record.getValue(from);
                if (StringUtils.isBlank((CharSequence)tempValue)) {
                    tempValue = "0.0";
                }
                result = MathUtils.add(result, Double.valueOf(tempValue));
            }
        }
        return result;
    }

    public Double multiply(String from, List<Record> attachedRecords) {
        Double result = new Double(1.0);
        if (SaveActionParameterOperation.hasRecords(attachedRecords)) {
            for (Record record : attachedRecords) {
                String tempValue = record.getValue(from);
                if (StringUtils.isBlank((CharSequence)tempValue)) {
                    tempValue = "1.0";
                }
                result = MathUtils.multiply(result, Double.valueOf(tempValue));
            }
        }
        return result;
    }

    public String accumulateResult(String stringResult, String valueJoiner, boolean accumulate) {
        if (accumulate) {
            ArrayList<String> values = new ArrayList<String>();
            for (int i = 0; i < values.size(); ++i) {
                values.add(stringResult);
            }
            return StringUtils.join(values, (String)valueJoiner);
        }
        return stringResult;
    }

    public static boolean hasRecords(List<Record> records) {
        return records != null && !records.isEmpty();
    }

    static {
        INTEGER_ACCURACY = 0;
    }
}

