/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.api.enumeration;

import org.apache.commons.lang3.StringUtils;
import org.hibernate.type.AbstractStandardBasicType;
import org.hibernate.type.StandardBasicTypes;

public enum ColumnType {
    STRING("string"){

        @Override
        public AbstractStandardBasicType<?> getScalar() {
            return StandardBasicTypes.STRING;
        }

        @Override
        public String getConditionSuffix() {
            return "'";
        }

        @Override
        public String getPartialAttachmentValueColumn() {
            return "string_primary_key_value";
        }
    }
    ,
    INT("int"){

        @Override
        public AbstractStandardBasicType<?> getScalar() {
            return StandardBasicTypes.INTEGER;
        }

        @Override
        public String getConditionSuffix() {
            return "";
        }

        @Override
        public String getPartialAttachmentValueColumn() {
            return "int_primary_key_value";
        }
    }
    ,
    FLOAT("float"){

        @Override
        public AbstractStandardBasicType<?> getScalar() {
            return StandardBasicTypes.DOUBLE;
        }

        @Override
        public String getConditionSuffix() {
            return "";
        }

        @Override
        public String getPartialAttachmentValueColumn() {
            return "float_primary_key_value";
        }
    }
    ,
    DATE("date"){

        @Override
        public AbstractStandardBasicType<?> getScalar() {
            return StandardBasicTypes.DATE;
        }

        @Override
        public String getConditionSuffix() {
            return "'";
        }

        @Override
        public String getPartialAttachmentValueColumn() {
            return "string_primary_key_value";
        }
    }
    ,
    DATE_STRING("datestring"){

        @Override
        public AbstractStandardBasicType<?> getScalar() {
            return StandardBasicTypes.STRING;
        }

        @Override
        public String getConditionSuffix() {
            return "'";
        }

        @Override
        public String getPartialAttachmentValueColumn() {
            return "string_primary_key_value";
        }
    };

    private String name;

    private ColumnType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static ColumnType getByName(String name) {
        for (ColumnType columnType : ColumnType.values()) {
            if (!StringUtils.equals((CharSequence)name, (CharSequence)columnType.getName())) continue;
            return columnType;
        }
        return STRING;
    }

    public abstract AbstractStandardBasicType<?> getScalar();

    public abstract String getConditionSuffix();

    public abstract String getPartialAttachmentValueColumn();
}

