Ext.ux.suncode.XpdlArchiveWindow = function() {
    var config = new Object();
    var viewSize = Ext.getBody().getViewSize();
    var width = viewSize.width * 0.9;
    var height = viewSize.height * 0.9 - 2 * calculateVersionBarHeight();

    var mainPanel = Ext.getCmp( 'main_panel' );
    var itemsConfig = new Object();
    itemsConfig = Ext.apply( {
        AV: mainPanel.getAdvancedView(),
        documentationView: mainPanel.getDocumentationView(),
        animationsOn: mainPanel.getAnimationsOn()
    }, itemsConfig );

    config = Ext.apply( {
        modal: true,
        width: width,
        height: height,
        title: getTranslation( 'Archiwum pakietów' ),
        layout: 'border',
        defaults: {
            split: true
        },
        items: [ new Ext.ux.suncode.XpdlArchiveTree( itemsConfig ), new Ext.ux.suncode.XpdlArchiveInfoPanel( itemsConfig ) ],
        closable: true,
        tbar: new Ext.Toolbar( {
            buttons: [ {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'close' ),
                tooltip: getTranslation( 'Zamknij' ),
                handler: this.closeWindow,
                scope: this
            } ]
        } )
    }, config );

    Ext.ux.suncode.XpdlArchiveWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.XpdlArchiveWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.XpdlArchiveWindow.superclass.initComponent.call( this );

        this.on( 'beforeshow', lockHotkeys );
        this.on( 'beforeclose', unlockHotkeys );
    },
    closeWindow: function() {
        this.close();
    }
} );

Ext.ux.suncode.XpdlArchiveTree = function( config ) {
    config = Ext.apply( {
        title: getTranslation( 'Drzewo pakietów' ),
        iconCls: 'x-Module-xpdlArchiveTree',
        region: 'west',
        layout: 'fit',
        collapsible: true,
        titleCollapse: true,
        animCollapse: config.animationsOn,
        width: 300,
        useArrows: true,
        autoScroll: true,
        animate: config.animationsOn,
        containerScroll: true,
        frame: false,
        style: 'padding: 0 0 10px 10px;',
        bodyCssClass: 'x-Module-whiteBody',
        ref: 'xpdlArchiveTree',
        loader: new Ext.tree.TreeLoader( {
            dataUrl: 'api/xpdl/getPackageNodes',
            requestMethod: 'GET',
            listeners: {
            	loadexception: function( loader, node, response ) {
            		showServerFailure( response );
            	}
            }
        } ),
        root: new Ext.tree.AsyncTreeNode( {
            text: getTranslation( 'Dostępne pakiety' ),
            icon: getPluginImgPath( 'archive' ),
            expanded: true,
            leaf: false,
            hasBeenExpanded: true
        } )
    }, config );

    Ext.ux.suncode.XpdlArchiveTree.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.XpdlArchiveTree, Ext.tree.TreePanel, {
    initComponent: function() {
        Ext.ux.suncode.XpdlArchiveTree.superclass.initComponent.call( this );

        this.on( 'beforeexpandnode', this.loadPackageVersions, this );
        this.on( 'click', this.loadPackageVersionInfo, this );
    },
    loadPackageVersions: function( node, deep, anim ) {
        if ( !node.attributes.hasBeenExpanded ) {
            this.getLoader().dataUrl = 'api/xpdl/getPackageVersionNodes';
            this.getLoader().baseParams.packageId = node.attributes.packageId;
            node.reload( this.markNodeAsExpanded, this );
        }
    },
    markNodeAsExpanded: function( node ) {
        node.attributes.hasBeenExpanded = true;
    },
    loadPackageVersionInfo: function( node, e ) {
        if ( !node.isLeaf() ) {
            return;
        }

        var xpdlArchiveInfoPanel = this.ownerCt.xpdlArchiveInfoPanel;

        xpdlArchiveInfoPanel.getForm().load( {
            url: 'api/xpdl/getPackageVersionInfo',
            params: {
                packageId: node.attributes.packageId,
                packageVersion: node.attributes.packageVersion
            },
            method: 'GET',
            scope: this,
            success: function( form, action ) {
                Ext.each( xpdlArchiveInfoPanel.buttons, function( btn, idx, btns ) {
                    if ( btn.disabled ) {
                        btn.enable();
                    }
                } );
            },
            failure: function( form, action ) {
            	showServerFailure( action.response );
            	
                Ext.each( xpdlArchiveInfoPanel.buttons, function( btn, idx, btns ) {
                    if ( !btn.disabled ) {
                        btn.disable();
                    }
                } );
            }
        } );
    }
} );

Ext.ux.suncode.XpdlArchiveInfoPanel = function( config ) {
    config = Ext.apply( {
        layoutConfig: {
            trackLabels: true
        },
        autoScroll: true,
        region: 'center',
        frame: false,
        border: false,
        bodyCssClass: 'x-Module-container-padding',
        labelWidth: 200,
        buttonAlign: 'center',
        ref: 'xpdlArchiveInfoPanel',
        items: [ {
            xtype: 'textfield',
            inputType: 'text',
            fieldLabel: getTranslation( 'Identyfikator pakietu' ),
            name: 'id',
            anchor: '100%',
            readOnly: true,
            hidden: !config.AV
        }, {
            xtype: 'textfield',
            inputType: 'text',
            fieldLabel: getTranslation( 'Nazwa pakietu' ),
            name: 'name',
            anchor: '100%',
            readOnly: true
        }, {
            xtype: 'textfield',
            inputType: 'text',
            fieldLabel: getTranslation( 'Wersja pakietu' ),
            name: 'version',
            anchor: '100%',
            readOnly: true
        }, {
            xtype: 'textfield',
            inputType: 'text',
            fieldLabel: getTranslation( 'Autor' ),
            name: 'author',
            anchor: '100%',
            readOnly: true
        }, {
            xtype: 'textfield',
            inputType: 'text',
            fieldLabel: getTranslation( 'Czas utworzenia' ),
            name: 'creationTime',
            anchor: '100%',
            readOnly: true
        }, {
            xtype: 'textfield',
            inputType: 'text',
            fieldLabel: getTranslation( 'Czas wczytania' ),
            name: 'uploadTime',
            anchor: '100%',
            readOnly: true
        }, {
            xtype: 'numberfield',
            fieldLabel: getTranslation( 'Ilość procesów' ),
            name: 'noOfProcesses',
            anchor: '100%',
            readOnly: true
        }, {
            xtype: 'fieldset',
            autoHeight: true,
            anchor: '100%',
            title: getTranslation( 'Informacje o pakiecie' ),
            layout: 'fit',
            items: [ {
                xtype: 'textarea',
                inputType: 'text',
                name: 'info',
                height: Ext.getBody().getViewSize().height * 0.4,
                autoScroll: true,
                anchor: '100%',
                readOnly: true
            } ]
        } ],
        buttons: [ {
            cls: 'x-btn-text-icon',
            text: getTranslation( 'Otwórz' ),
            tooltip: getTranslation( 'Otwórz wersję pakietu' ),
            disabled: true,
            handler: this.openPackageVersion,
            scope: this
        }, {
            cls: 'x-btn-text-icon',
            text: getTranslation( 'Podgląd' ),
            tooltip: getTranslation( 'Pokaż podgląd wersji pakietu' ),
            disabled: true,
            handler: this.showPackageVersionPreview,
            scope: this
        }, {
            cls: 'x-btn-text-icon',
            text: getTranslation( 'Pobierz' ),
            tooltip: getTranslation( 'Pobierz wersję pakietu' ),
            disabled: true,
            handler: this.downloadPackageVersion,
            scope: this
        }, {
            cls: 'x-btn-text-icon',
            text: getTranslation( 'Publikuj' ),
            tooltip: getTranslation( 'Publikuj wersję pakietu w systemie' ),
            disabled: true,
            handler: this.exportPackageVersion,
            scope: this
        }, {
            cls: 'x-btn-text-icon',
            text: getTranslation( 'Dokumentacja procesu' ),
            tooltip: getTranslation( 'Pobierz dokumentację procesu' ),
            disabled: true,
            hidden: !config.documentationView,
            handler: this.showProcessDocumentationHistoryWindow,
            scope: this
        } ]
    }, config );

    Ext.ux.suncode.XpdlArchiveInfoPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.XpdlArchiveInfoPanel, Ext.FormPanel, {
    initComponent: function() {
        Ext.ux.suncode.XpdlArchiveInfoPanel.superclass.initComponent.call( this );
    },
    openPackageVersion: function() {
        var errorMsg = getTranslation( 'Brak niezbędnych informacji do otwarcia mapy pakietu.' );
        var packageDef = this.getPackageDef( errorMsg );

        if ( packageDef ) {
            if ( Ext.getCmp( 'main_panel' ).isSaved() ) {
                executeNewXpdl();
                this.executeOpenPackageVersion( packageDef.id, packageDef.version );
            } else {
                Ext.Msg.show( {
                    title: getTranslation( 'Uwaga' ),
                    msg: getTranslation( 'Plik jest niezapisany. Zapisać przed wykonaniem operacji?' ),
                    buttons: {
                        yes: getTranslation( 'Tak' ),
                        no: getTranslation( 'Nie' ),
                        cancel: getTranslation( 'Anuluj' )
                    },
                    scope: this,
                    fn: function( buttonId ) {
                        switch ( buttonId ) {
                            case 'yes':
                              var me = this;
                                saveXpdl( function() {
                                  executeNewXpdl();
                                  me.executeOpenPackageVersion( packageDef.id, packageDef.version );
                                } );
                                break;
                            case 'no':
                            	  resetAutoSaved();
                                executeNewXpdl();
                                this.executeOpenPackageVersion( packageDef.id, packageDef.version );
                                break;
                            default:
                                break;
                        }
                    },
                    icon: Ext.Msg.QUESTION
                } );
            }
        }
    },
    executeOpenPackageVersion: function( packageId, packageVersion ) {
        var formPanel = new Ext.FormPanel( {
            renderTo: document.body,
            hidden: true,
            items: [ {
                xtype: 'textfield',
                name: 'packageId',
                value: packageId
            }, {
                xtype: 'textfield',
                name: 'packageVersion',
                value: packageVersion
            } ]
        } );
        var form = formPanel.getForm();
        form.submit( {
            url: 'api/xpdl/openPackageVersion',
            waitMsg: getTranslation( 'Trwa przetwarzanie pliku...' ),
            waitTitle: getTranslation( 'Proszę czekać' ),
            method: 'POST',
            timeout: 600,
            scope: this,
            success: function( form, action ) {
                if ( action.result.success ) {
                    this.ownerCt.close();
                    var mainPanel = Ext.getCmp( 'main_panel' );
                    executeOpen( action.result );
                    
                    if ( Ext.ux.suncode.XpdlErrors.hasErrors() ) {
                        var xpdlErrorsWindow = new Ext.ux.suncode.XpdlErrorsWindow();
                        xpdlErrorsWindow.show();
                    }

                    if ( mainPanel.isCurrentXpdlVersionOlder() ) {
                      showWarn( getTranslation( 'Mapa pakietu została utworzona w edytorze w wersji' )
                          + ' ' + mainPanel.getCurrentXpdlVersion() + '. '
                          + getTranslation( 'Aktualna wersja edytora to' )
                          + ' ' + mainPanel.getVersion() + '.' );
                    }
                } else {
                    showWarn( getTranslation( 'Wystąpił błąd.' ) );
                }
            },
            failure: function( form, action ) {
            	showServerFailure( action.response );
            }
        } );

        var task = new Ext.util.DelayedTask( function() {
            formPanel.destroy();
        }, this );
        task.delay( 3000 );
    },
    showPackageVersionPreview: function() {
        var errorMsg = getTranslation( 'Brak niezbędnych informacji do wyświetlenia podglądu mapy pakietu.' );
        var packageDef = this.getPackageDef( errorMsg );

        if ( packageDef ) {
        	executeGetXpdlPreview( {
        		packageId: packageDef.id,
                packageVersion: packageDef.version,
                method: 'GET',
                successFunction: function( preview ) {
                	var win = new Ext.ux.suncode.XpdlPreviewWindow( {
                        xpdlPreview: preview
                    } );
                    win.show();
                }
        	} );
        }
    },
    downloadPackageVersion: function() {
        var errorMsg = getTranslation( 'Brak niezbędnych informacji do pobrania mapy pakietu.' );
        var packageDef = this.getPackageDef( errorMsg );

        if ( packageDef ) {
        	  var mainPanel = Ext.getCmp( 'main_panel' );
        	
            var form = jQuery( '<form/>', { action: 'api/xpdl/generateFromHistory', method:'post' } );
            form.append( jQuery( '<input>', { type: 'text', name: Suncode.getCsrfParameterName(), value: Suncode.getCsrfToken() } ) );
            form.append( jQuery( '<input>', { type: 'text', name: 'fileName', value: packageDef.name } ) );
            form.append( jQuery( '<input>', { type: 'text', name: 'packageId', value: packageDef.id } ) );
            form.append( jQuery( '<input>', { type: 'text', name: 'packageVersion', value: packageDef.version } ) );
            
            var iframe = jQuery( '#download-frame' );
            iframe.empty();
            iframe.append( form );
            
            mainPanel.setCheckSavedOnUnload( false );
            
            form.submit();
            
            var task = new Ext.util.DelayedTask( function() {
                mainPanel.setCheckSavedOnUnload( true );
            }, this );
            task.delay( 1000 );
        }
    },
    exportPackageVersion: function() {
        var errorMsg = getTranslation( 'Brak niezbędnych informacji do eksportu mapy pakietu.' );
        var packageDef = this.getPackageDef( errorMsg );

        if ( packageDef ) {
            var packagesTree = this.ownerCt.xpdlArchiveTree;
            packagesTree.getLoader().baseParams.packageId = packageDef.id;
            var nodeToReload = packagesTree.getRootNode().findChild( 'packageId', packageDef.id );

            var win = new Ext.ux.suncode.PackageExportWindow( {
                packageId: packageDef.id,
                packageName: packageDef.name,
                packageVersion: packageDef.version,
                packageAuthor: packageDef.author,
                packageNoOfProcesses: packageDef.noOfProcesses,
                skipExport: true,
                packageInfoTemplate: {
                  content: '',
                  validate: false
                },
                nodeToReload: nodeToReload
            } );
            win.show();
        }
    },
    showProcessDocumentationHistoryWindow: function() {
        var errorMsg = getTranslation( 'Brak niezbędnych informacji do pobrania dokumentacji procesu.' );
        var packageDef = this.getPackageDef( errorMsg );

        if ( packageDef ) {
            var win = new Ext.ux.suncode.ProcessDocumentationHistoryWindow( {
                packageId: packageDef.id,
                packageVersion: packageDef.version,
                packageName: packageDef.name
            } );
            win.show();
        }
    },
    getPackageDef: function( errorMsg ) {
        var packageDef = this.getForm().getValues();

        if ( !Ext.isEmpty( packageDef.id ) && !Ext.isEmpty( packageDef.version ) ) {
            return packageDef;
        } else {
            showWarn( errorMsg );
            return null;
        }
    }
} );

Ext.ux.suncode.PackagesHistoryWindow = function() {
    var config = new Object();
    var viewSize = Ext.getBody().getViewSize();

    var panelConfig = new Object();
    panelConfig = Ext.apply( {
        AV: Ext.getCmp( 'main_panel' ).getAdvancedView()
    }, panelConfig );

    config = Ext.apply( {
        modal: true,
        width: viewSize.width * 0.9,
        height: viewSize.height * 0.8,
        title: getTranslation( 'Historia pakietów' ),
        layout: 'fit',
        items: [ new Ext.ux.suncode.PackagesHistoryPanel( panelConfig ) ],
        closable: true,
        tbar: new Ext.Toolbar( {
            buttons: [ {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'close' ),
                tooltip: getTranslation( 'Zamknij' ),
                handler: this.closeWindow,
                scope: this
            } ]
        } )
    }, config );

    Ext.ux.suncode.PackagesHistoryWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.PackagesHistoryWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.PackagesHistoryWindow.superclass.initComponent.call( this );

        this.on( 'beforeshow', lockHotkeys );
        this.on( 'beforeclose', unlockHotkeys );
    },
    closeWindow: function() {
        this.close();
    }
} );

Ext.ux.suncode.PackagesHistoryPanel = function( config ) {
    var record = Ext.data.Record.create( [ {
        name: 'id',
        type: 'string'
    }, {
        name: 'name',
        type: 'string'
    }, {
        name: 'description',
        type: 'string'
    }, {
        name: 'version',
        type: 'string'
    }, {
        name: 'author',
        type: 'string'
    }, {
        name: 'creationTime',
        type: 'string'
    }, {
        name: 'uploadTime',
        type: 'string'
    }, {
        name: 'historyUploadTime',
        type: 'string'
    }, {
        name: 'noOfProcesses',
        type: 'int'
    } ] );

    var store = new Ext.data.JsonStore( {
        proxy: new Ext.data.HttpProxy( {
            method: 'GET',
            url: 'api/xpdl/getHistory',
            listeners: {
            	exception: function( proxy, type, action, options, response, arg ) {
            		showServerFailure( response );
            	}
            }
        } ),
        reader: new Ext.data.JsonReader( {
            fields: record
        } ),
        autoLoad: true,
        autoDestroy: true,
        batch: true,
        remoteSort: true,
        sortInfo: {
            field: 'uploadTime',
            direction: 'DESC'
        },
        fields: record,
        root: 'data',
        totalProperty: 'total',
        idProperty: 'no_id',
        baseParams: {
            start: 0,
            limit: 20
        }
    } );

    config = Ext.apply( {
        store: store,
        enableColumnResize: true,
        columnLines: true,
        autoScroll: true,
        border: false,
        ref: 'packagesHistoryPanel',
        colModel: new Ext.grid.ColumnModel( {
            defaults: {
                sortable: true,
                menuDisabled: false
            },
            columns: [ {
                id: 'id',
                header: getTranslation( 'Identyfikator' ),
                dataIndex: 'id',
                align: 'left',
                hidden: !config.AV,
                hideable: !config.AV
            }, {
                id: 'name',
                header: getTranslation( 'Nazwa' ),
                dataIndex: 'name',
                align: 'left',
                sortable: false,
                renderer: wrapColumnValue
            }, {
                id: 'description',
                header: getTranslation( 'Opis' ),
                dataIndex: 'description',
                align: 'left',
                sortable: false,
                renderer: function( value, metaData, record, rowIndex, colIndex, store ) {
                    if ( !Ext.isEmpty( value ) ) {
                        metaData.attr = 'ext:qtip="' + value + '"';
                        return wrapColumnValue( value.ellipse( 100 ) );
                    } else {
                        return '';
                    }
                }
            }, {
                id: 'version',
                header: getTranslation( 'Wersja' ),
                dataIndex: 'version',
                align: 'left'
            }, {
                id: 'author',
                header: getTranslation( 'Autor' ),
                dataIndex: 'author',
                align: 'left',
                sortable: false,
                renderer: wrapColumnValue
            }, {
                id: 'creationTime',
                header: getTranslation( 'Czas utworzenia' ),
                dataIndex: 'creationTime',
                align: 'left',
                sortable: false,
                renderer: wrapColumnValue
            }, {
                id: 'uploadTime',
                header: getTranslation( 'Czas wczytania' ),
                dataIndex: 'uploadTime',
                align: 'left',
                renderer: wrapColumnValue
            }, {
                id: 'historyUploadTime',
                header: getTranslation( 'Czas wyładowania' ),
                dataIndex: 'historyUploadTime',
                align: 'left',
                renderer: wrapColumnValue
            }, {
                id: 'noOfProcesses',
                header: getTranslation( 'Ilość procesów' ),
                dataIndex: 'noOfProcesses',
                align: 'center',
                sortable: false
            } ]
        } ),
        loadMask: {
            msg: getTranslation( 'Trwa ładowanie danych...' )
        },
        viewConfig: new Ext.ux.suncode.StandardGridView( {
            emptyText: getTranslation( 'Brak historii pakietów' )
        } ),
        sm: new Ext.grid.RowSelectionModel( {
            singleSelect: true,
            listeners: {
                beforerowselect: function( sm, rowIndex, keepExisting, record ) {
                    return false;
                }
            }
        } ),
        bbar: new Ext.ux.suncode.StandardPagingToolbar( {
            pageSize: 20,
            store: store,
            contentName: getTranslation( 'Historia pakietów' ),
            emptyMsg: 'Brak historii pakietów'
        } )
    }, config );

    Ext.ux.suncode.PackagesHistoryPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.PackagesHistoryPanel, Ext.grid.GridPanel, {
    initComponent: function() {
        Ext.ux.suncode.PackagesHistoryPanel.superclass.initComponent.call( this );
    }
} );