Ext.ux.suncode.TutorialsWindow = function() {
    var config = new Object();
    var size = Ext.getBody().getViewSize();

    config = Ext.apply( {
        width: size.width * 0.95,
        height: size.height * 0.95,
        modal: false,
        title: getTranslation( 'Tutoriale' ),
        closable: true,
        layout: 'border',
        defaults: {
            split: true
        },
        items: [ new Ext.ux.suncode.TutorialsTree(), new Ext.ux.suncode.VideoTutorialPanel() ],
        tbar: new Ext.Toolbar( {
            buttons: [ {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'close' ),
                tooltip: getTranslation( 'Zamknij' ),
                handler: this.closeWindow,
                scope: this
            } ]
        } )
    }, config );

    Ext.ux.suncode.TutorialsWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.TutorialsWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.TutorialsWindow.superclass.initComponent.call( this );
    },
    closeWindow: function() {
        this.close();
    }
} );

Ext.ux.suncode.TutorialsTree = function() {
    var config = new Object();

    config = Ext.apply( {
        xtype: 'treepanel',
        title: getTranslation( 'Tutoriale' ),
        iconCls: 'x-Module-tutorialsTree',
        region: 'west',
        layout: 'fit',
        frame: false,
        collapsible: true,
        titleCollapse: true,
        width: 250,
        useArrows: true,
        autoScroll: true,
        animate: true,
        containerScroll: true,
        border: false,
        style: 'border-right-width: 1px;',
        bodyCssClass: 'x-Module-whiteBody',
        ref: 'tutorialsTree',
        loader: new Ext.tree.TreeLoader( {
            dataUrl: 'api/tutorial/get',
            requestMethod: 'GET',
            baseParams: {
                extension: 'webm'
            },
            listeners: {
            	loadexception: function( loader, node, response ) {
            		showServerFailure( response );
            	}
            }
        } ),
        root: new Ext.tree.AsyncTreeNode( {
            text: getTranslation( 'Dostępne tutoriale' ),
            icon: getPluginImgPath( 'tutorials' ),
            expanded: true,
            leaf: false
        } )
    }, config );

    Ext.ux.suncode.TutorialsTree.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.TutorialsTree, Ext.tree.TreePanel, {
    initComponent: function() {
        Ext.ux.suncode.TutorialsTree.superclass.initComponent.call( this );

        this.on( 'click', this.playTutorial, this );
    },
    playTutorial: function( node ) {
        if ( !node.isLeaf() ) {
            return;
        }

        this.ownerCt.videoTutorialPanel.onPlay( {
            tag: 'source',
            src: Suncode.context( 'pwe' ).pluginResourcesPath + '/' + node.attributes.location,
            type: 'video/webm'
        } );
    }
} );

Ext.ux.suncode.VideoTutorialPanel = function() {
    var config = new Object();

    config = Ext.apply( {
        region: 'center',
        width: '100%',
        height: '100%',
        border: false,
        ref: 'videoTutorialPanel',
        autobuffer: true,
        autoplay: true,
        controls: true,
        bodyStyle: 'background-color: #FFFFFF; color:#000000;',
        video: null
    }, config );

    Ext.ux.suncode.VideoTutorialPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.VideoTutorialPanel, Ext.FormPanel, {
    initComponent: function() {
        Ext.ux.suncode.VideoTutorialPanel.superclass.initComponent.call( this );

        this.on( 'beforedestroy', this.destroyVideo, this );
        this.on( 'bodyresize', this.fitVideoSize, this );
    },
    destroyVideo: function() {
        this.video = null;
    },
    fitVideoSize: function( panel, width, height ) {
        if ( this.video ) {
            this.video.setSize( width, height );
        }
    },
    onPlay: function( tutorial ) {
        if ( this.video ) {
            this.video.remove();
            this.video = null;
        }

        var fallback = '';

        if ( this.fallbackHTML ) {
            fallback = this.fallbackHTML;
        } else {
            fallback = '<p class="x-Module-errorText">' + getTranslation( 'Twoja przeglądarka nie wspiera odtwarzania tutoriali.' ) + '</p>';
        }

        var size = this.getSize();

        var cfg = Ext.copyTo( {
            tag: 'video',
            width: size.width,
            height: size.height
        }, this, 'poster,start,loopstart,loopend,playcount,autobuffer,loop' );

        if ( this.autoplay ) {
            cfg.autoplay = 1;
        }

        if ( this.controls ) {
            cfg.controls = 1;
        }

        cfg.children = new Array();
        cfg.children.push( tutorial );
        cfg.children.push( {
            html: fallback
        } );

        this.video = this.body.createChild( cfg );
    }
} );