Ext.ux.suncode.TemplatesContainer = function( config ) {
    config = Ext.apply( {
        fieldLabel: getTranslation( 'Dostępne szablony' ),
        ref: 'templatesContainer',
        anchor: '100%',
        items: [ new Ext.ux.suncode.TemplatesChooser( config ), {
            xtype: 'button',
            cls: 'x-btn-icon',
            icon: getPluginImgPath( 'template' ),
            tooltip: getTranslation( 'Użyj szablonu' ),
            handler: this.loadTemplate,
            scope: this
        } ]
    }, config );

    Ext.ux.suncode.TemplatesContainer.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.TemplatesContainer, Ext.form.CompositeField, {
    initComponent: function() {
        Ext.ux.suncode.TemplatesContainer.superclass.initComponent.call( this );
    },
    loadTemplate: function() {
        var templateLoadScope = this.initialConfig.templateLoadScope;
        var templatesChooser = this.items.first();
        var templateId = templatesChooser.getValue();

        if ( !templatesChooser.isValid() || Ext.isEmpty( templateId ) ) {
            showWarn( getTranslation( 'Wybierz szablon.' ) );
        } else {
            if ( templateLoadScope && Ext.isFunction( templateLoadScope.onLoadTemplate ) ) {
                templateLoadScope.onLoadTemplate( templateId );
            } else {
                showWarn( getTranslation( 'Błąd ładowania szablonu.' ) );
            }
        }
    }
} );

Ext.ux.suncode.TemplatesChooser = function( config ) {
    var record = Ext.data.Record.create( [ {
        name: 'id',
        type: 'string'
    }, {
        name: 'name',
        type: 'string'
    }, {
        name: 'description',
        type: 'string'
    } ] );

    config = Ext.apply( {
        store: new Ext.data.JsonStore( {
            proxy: new Ext.data.HttpProxy( {
                method: 'GET',
                url: 'api/template/get',
                listeners: {
                	exception: function( proxy, type, action, options, response, arg ) {
                		showServerFailure( response );
                	}
                }
            } ),
            reader: new Ext.data.JsonReader( {
                fields: record
            } ),
            autoDestroy: true,
            batch: true,
            fields: record,
            root: 'data',
            baseParams: {
                start: 0,
                limit: 5,
                templateType: config.templateType
            }
        } ),
        displayField: 'name',
        valueField: 'id',
        forceSelection: true,
        flex: 1,
        resizable: true,
        mode: 'remote',
        minChars: 0,
        pageSize: 5,
        lazyInit: false,
        itemSelector: 'div.x-Module-comboTemplateItem',
        tpl: new Ext.XTemplate( '<tpl for=".">', '<div class="x-Module-comboTemplateItem">', '<div><font ' + getTemplateStyle() + '><b>'
                        + getTranslation( 'Nazwa' ) + ': ' + '</b></font><span>{name}</span></div>', '<div><font ' + getTemplateStyle() + '><b>'
                        + getTranslation( 'Opis' ) + ': ' + '</b></font><span>{description}</span></div></div>',
                        '<tpl if="xindex !== xcount">', '<hr ' + getHRLineStyle() + '>', '</tpl>', '', '</tpl>' ).compile()
    }, config );

    Ext.ux.suncode.TemplatesChooser.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.TemplatesChooser, Ext.form.ComboBox, {
    initComponent: function() {
        Ext.ux.suncode.TemplatesChooser.superclass.initComponent.call( this );
    }
} );