Ext.ux.suncode.DeadlineDefWindow = function( config ) {
    var windowWidth = Ext.getBody().getViewSize().width * 0.5;
    var deadline = config.deadline;
    var winTitle = deadline ? getTranslation( 'Definicja terminu ostatecznego' ) + ' ' + deadline.exceptionName
                    : getTranslation( 'Kreator terminu ostatecznego' );
    var customDefinition = false;
    var items = new Array();

    if ( deadline && !Ext.isEmpty( deadline.condition ) ) {
        customDefinition = true;
        items.push( new Ext.ux.suncode.DeadlineCustomDefPanel( config ) );
    } else {
        customDefinition = false;
        items.push( new Ext.ux.suncode.DeadlineBasicDefPanel( config ) );
    }

    config = Ext.apply( {
        modal: true,
        width: windowWidth,
        autoScroll: true,
        title: winTitle,
        items: items,
        closable: true,
        customDefinition: customDefinition,
        tbar: new Ext.Toolbar( {
            buttons: [ {
                cls: 'x-btn-icon',
                ref: 'saveBtn',
                icon: getPluginImgPath( 'save' ),
                tooltip: getTranslation( 'Zapisz' ),
                handler: this.saveForm,
                scope: this
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'change' ),
                tooltip: customDefinition ? getTranslation( 'Użyj definicji podstawowej' ) : getTranslation( 'Użyj własnej definicji' ),
                scope: this,
                handler: this.toggleDefinitionType
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'close' ),
                tooltip: getTranslation( 'Zamknij' ),
                cancel: false,
                handler: this.closeWindow,
                scope: this
            } ]
        } )
    }, config );

    Ext.ux.suncode.DeadlineDefWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.DeadlineDefWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.DeadlineDefWindow.superclass.initComponent.call( this );
    },
    saveForm: function() {
        this.deadlineDefPanel.saveForm();
    },
    toggleDefinitionType: function( button ) {
    	var deadlineDefPanel = this.deadlineDefPanel;
    	var customDefinition = this.customDefinition;
        var itemConfig = new Object();
        itemConfig = Ext.apply( {
            activityNode: this.initialConfig.activityNode,
            deadline: this.initialConfig.deadline,
            saveTo: this.initialConfig.saveTo,
            varRecord: this.initialConfig.varRecord,
            exceptionNameItemValue: deadlineDefPanel.deadlineExceptionNameItem.getValue(),
            executionItemValue: deadlineDefPanel.deadlineExecutionItem.getValue()
        }, itemConfig );
        this.remove( deadlineDefPanel );

        if ( customDefinition ) {
            button.setTooltip( getTranslation( 'Użyj własnej definicji' ) );
            this.add( new Ext.ux.suncode.DeadlineBasicDefPanel( itemConfig ) );
        } else {
            button.setTooltip( getTranslation( 'Użyj definicji podstawowej' ) );
            this.add( new Ext.ux.suncode.DeadlineCustomDefPanel( itemConfig ) );
        }

        this.customDefinition = !customDefinition;
        this.doLayout();
        this.syncShadow();
    },
    closeWindow: function() {
        this.close();
    }
} );

Ext.ux.suncode.DeadlineBasicDefPanel = function( config ) {
    var activityNode = config.activityNode;
    var exceptionNameItemValue = '';
    var executionItemValue = '';
    var deadlineVarItemValue = '';
    var deadlineAmountItemValue = '';
    var deadlineUnitItemValue = '';
    var deadlineSkipWeekendsItemValue = false;
    var deadlineSkipHolidaysItemValue = false;

    var deadlineVarLabel = addTooltipToField( getTranslation( 'Czas rozpoczęcia odliczania' ),
                    getTranslation( 'Zmienna procesu lub parametr formalny, który wyznaczy datę i czas' ) + ','
        + '<br>' + getTranslation( 'od którego będzie sprawdzane, czy nastąpi przekroczenie terminu' ) );

    var deadline = config.deadline;
    if ( deadline ) {
        exceptionNameItemValue = deadline.exceptionName;
        executionItemValue = deadline.execution;
        deadlineVarItemValue = deadline.varId;
        deadlineAmountItemValue = deadline.amount;
        deadlineUnitItemValue = deadline.unit;
        deadlineSkipWeekendsItemValue = deadline.skipWeekends;
        deadlineSkipHolidaysItemValue = deadline.skipHolidays;
    }
    if ( config.exceptionNameItemValue ) {
    	exceptionNameItemValue = config.exceptionNameItemValue
    }
    if ( config.executionItemValue ) {
    	executionItemValue = config.executionItemValue
    }

    config = Ext.apply( {
        labelWidth: 200,
        autoHeight: true,
        frame: false,
        border: false,
        bodyCssClass: 'x-Module-container-padding',
        ref: 'deadlineDefPanel',
        items: [ new Ext.ux.suncode.IdField( {
            anchor: '100%',
            fieldLabel: getTranslation( 'Nazwa' ),
            allowBlank: true,
            value: exceptionNameItemValue,
            ref: 'deadlineExceptionNameItem',
            idChanged: !Ext.isEmpty( deadline )
        } ), new Ext.ux.suncode.DeadlineExecutionsChooser( {
            value: executionItemValue
        } ), {
            xtype: 'compositefield',
            fieldLabel: deadlineVarLabel,
            ref: 'deadlineVarItem',
            items: [ new Ext.ux.suncode.AllVariablesChooser( {
                variables: activityNode.parentNode.attributes.variables,
                formalParameters: activityNode.parentNode.attributes.formalParameters,
                additionals: [ {
                    id: 'PROCESS_STARTED_TIME',
                    name: 'PROCESS_STARTED_TIME',
                    descr: getTranslation( 'Czas rozpoczęcia procesu' )
                }, {
                    id: 'ACTIVITY_ACTIVATED_TIME',
                    name: 'ACTIVITY_ACTIVATED_TIME',
                    descr: getTranslation( 'Czas utworzenia zadania w skrzynce użytkownika' )
                }, {
                    id: 'ACTIVITY_ACCEPTED_TIME',
                    name: 'ACTIVITY_ACCEPTED_TIME',
                    descr: getTranslation( 'Czas podjęcia zadania przez użytkownika' )
                } ],
                startWith: deadlineVarItemValue
            } ) ]
        }, {
            xtype: 'numberfield',
            anchor: '100%',
            fieldLabel: getTranslation( 'Ilość' ),
            allowDecimals: false,
            allowNegative: false,
            ref: 'deadlineAmountItem',
            value: deadlineAmountItemValue
        }, new Ext.ux.suncode.DeadlineUnitsChooser( {
            value: deadlineUnitItemValue
        } ), {
            xtype: 'checkbox',
            fieldLabel: getTranslation( 'Pomijaj weekendy' ),
            ref: 'deadlineSkipWeekendsItem',
            checked: deadlineSkipWeekendsItemValue,
            inputValue: 'true'
        }, {
            xtype: 'checkbox',
            fieldLabel: getTranslation( 'Pomijaj święta i dni wolne' ),
            ref: 'deadlineSkipHolidaysItem',
            checked: deadlineSkipHolidaysItemValue,
            inputValue: 'true'
        } ]
    }, config );

    Ext.ux.suncode.DeadlineBasicDefPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.DeadlineBasicDefPanel, Ext.FormPanel, {
    initComponent: function() {
        Ext.ux.suncode.DeadlineBasicDefPanel.superclass.initComponent.call( this );
    },
    saveForm: function() {
        var exceptionName = this.deadlineExceptionNameItem.getValue();
        var execution = this.deadlineExecutionItem.getValue();
        var varId = this.deadlineVarItem.items.first().getValue();
        var amount = this.deadlineAmountItem.getValue();
        var unit = this.deadlineUnitItem.getValue();
        var saveToObj = this.initialConfig.saveTo;
        var varRecord = this.initialConfig.varRecord;
        var deadline = this.initialConfig.deadline;
        var activityNode = this.initialConfig.activityNode;

        if ( Ext.isEmpty( exceptionName ) ) {
            showWarn( getTranslation( 'Podaj nazwę terminu ostatecznego.' ) );
            return;
        } else if ( Ext.isEmpty( execution ) ) {
            showWarn( getTranslation( 'Wybierz wykonanie.' ) );
            return;
        } else if ( Ext.isEmpty( varId ) ) {
            showWarn( getTranslation( 'Określ czas rozpoczęcia odliczania.' ) );
            return;
        } else if ( Ext.isEmpty( amount ) ) {
            showWarn( getTranslation( 'Podaj ilość.' ) );
            return;
        } else if ( Ext.isEmpty( unit ) ) {
            showWarn( getTranslation( 'Wybierz jednostkę.' ) );
            return;
        }

        if ( !deadline && activityNode.findDeadline( exceptionName ) ) {
            showWarn( getTranslation( 'Termin ostateczny już istnieje.' ) );
            return;
        } else if ( deadline && deadline.exceptionName != exceptionName && activityNode.findDeadline( exceptionName ) ) {
            showWarn( getTranslation( 'Termin ostateczny już istnieje.' ) );
            return;
        }

        var validationExceptionName = deadline ? deadline.exceptionName : exceptionName;
        var deadlineUpdate = deadline ? true : false;
        if ( execution == 'SYNCHR' && !activityNode.validateSynchronousDeadlines( deadlineUpdate, validationExceptionName ) ) {
            showWarn( getTranslation( 'Zadanie może posiadać tylko jeden synchroniczny termin ostateczny.' ) );
            return;
        }

        if ( saveToObj && varRecord ) {
            if ( deadline ) {
                varRecord.set( 'exceptionName', exceptionName );
                varRecord.set( 'execution', execution );
                varRecord.commit();
            } else {
                var store = saveToObj.getStore();
                store.add( new varRecord( {
                    exceptionName: exceptionName,
                    execution: execution
                } ) );
                store.commitChanges();
                saveToObj.updateTitle();
            }
        }

        var deadlineObj = new Object();
        deadlineObj = Ext.apply( {
            exceptionName: exceptionName,
            execution: execution,
            varId: varId,
            amount: amount,
            unit: unit,
            skipWeekends: this.deadlineSkipWeekendsItem.getValue(),
            skipHolidays: this.deadlineSkipHolidaysItem.getValue(),
            condition: ''
        }, deadlineObj );

        if ( deadline ) {
            activityNode.updateDeadline( deadline.exceptionName, deadlineObj );
        } else {
            activityNode.addDeadline( deadlineObj );
        }

        this.ownerCt.closeWindow();
    }
} );

Ext.ux.suncode.DeadlineCustomDefPanel = function( config ) {
    var activityNode = config.activityNode;
    var deadline = config.deadline;
    var exceptionNameItemValue = '';
    var executionItemValue = '';
    var deadlineConditionItemValue = '';
    
    if ( deadline ) {
        exceptionNameItemValue = deadline.exceptionName;
        executionItemValue = deadline.execution;
        deadlineConditionItemValue = deadline.condition;
    }
    if ( config.exceptionNameItemValue ) {
    	exceptionNameItemValue = config.exceptionNameItemValue
    }
    if ( config.executionItemValue ) {
    	executionItemValue = config.executionItemValue
    }

    config = Ext.apply( {
        labelWidth: 200,
        autoHeight: true,
        frame: false,
        border: false,
        bodyCssClass: 'x-Module-container-padding',
        ref: 'deadlineDefPanel',
        items: [ new Ext.ux.suncode.IdField( {
            anchor: '100%',
            fieldLabel: getTranslation( 'Nazwa' ),
            allowBlank: true,
            value: exceptionNameItemValue,
            ref: 'deadlineExceptionNameItem',
            idChanged: !Ext.isEmpty( deadline )
        } ), new Ext.ux.suncode.DeadlineExecutionsChooser( {
            value: executionItemValue
        } ), {
            xtype: 'fieldset',
            height: 200,
            title: getTranslation( 'Warunek' ),
            layout: 'fit',
            items: [ {
                xtype: 'textarea',
                ref: '../deadlineConditionItem',
                autoScroll: true,
                value: deadlineConditionItemValue,
                listeners: {
                    scope: this,
                    render: function( textArea ) {
                        textArea.getEl().on( 'contextmenu', this.onContextMenu, this );
                    }
                }
            } ]
        } ]
    }, config );

    Ext.ux.suncode.DeadlineCustomDefPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.DeadlineCustomDefPanel, Ext.FormPanel, {
    initComponent: function() {
        Ext.ux.suncode.DeadlineCustomDefPanel.superclass.initComponent.call( this );
    },
    onContextMenu: function( e ) {
        e.stopEvent();
        showMenu( new Ext.ux.suncode.GlobalMenu( {
            valueUser: this
        } ), e );
    },
    handleGlobalMenuValue: function( value ) {
        this.deadlineConditionItem.replaceSelectedText( value );
    },
    saveForm: function() {
        var exceptionName = this.deadlineExceptionNameItem.getValue();
        var execution = this.deadlineExecutionItem.getValue();
        var condition = this.deadlineConditionItem.getValue();
        var saveToObj = this.initialConfig.saveTo;
        var varRecord = this.initialConfig.varRecord;
        var deadline = this.initialConfig.deadline;
        var activityNode = this.initialConfig.activityNode;

        if ( Ext.isEmpty( exceptionName ) ) {
            showWarn( getTranslation( 'Podaj nazwę terminu ostatecznego.' ) );
            return;
        } else if ( Ext.isEmpty( execution ) ) {
            showWarn( getTranslation( 'Wybierz wykonanie.' ) );
            return;
        } else if ( Ext.isEmpty( condition ) ) {
            showWarn( getTranslation( 'Podaj warunek.' ) );
            return;
        }

        if ( !deadline && activityNode.findDeadline( exceptionName ) ) {
            showWarn( getTranslation( 'Termin ostateczny już istnieje.' ) );
            return;
        } else if ( deadline && deadline.exceptionName != exceptionName && activityNode.findDeadline( exceptionName ) ) {
            showWarn( getTranslation( 'Termin ostateczny już istnieje.' ) );
            return;
        }

        var validationExceptionName = deadline ? deadline.exceptionName : exceptionName;
        var deadlineUpdate = deadline ? true : false;
        if ( execution == 'SYNCHR' && !activityNode.validateSynchronousDeadlines( deadlineUpdate, validationExceptionName ) ) {
            showWarn( getTranslation( 'Zadanie może posiadać tylko jeden synchroniczny termin ostateczny.' ) );
            return;
        }

        if ( saveToObj && varRecord ) {
            if ( deadline ) {
                varRecord.set( 'exceptionName', exceptionName );
                varRecord.set( 'execution', execution );
                varRecord.commit();
            } else {
                var store = saveToObj.getStore();
                store.add( new varRecord( {
                    exceptionName: exceptionName,
                    execution: execution
                } ) );
                store.commitChanges();
                saveToObj.updateTitle();
            }
        }

        var deadlineObj = new Object();
        deadlineObj = Ext.apply( {
            exceptionName: exceptionName,
            execution: execution,
            varId: '',
            amount: '',
            unit: '',
            skipWeekends: false,
            skipHolidays: false,
            condition: condition
        }, deadlineObj );

        if ( deadline ) {
            activityNode.updateDeadline( deadline.exceptionName, deadlineObj );
        } else {
            activityNode.addDeadline( deadlineObj );
        }

        this.ownerCt.closeWindow();
    }
} );

Ext.ux.suncode.AsynchronousActivityDeadlinesChooser = function( config ) {
  var activityNode = config.activityNode;
  var deadlines = activityNode.attributes.deadlines;

  var store = new Ext.data.Store( {
    reader: new Ext.data.JsonReader( {
      fields: Ext.data.Record.create( [ {
        name: 'exceptionName',
        type: 'string'
      } ] )
    } )
  } );

  if ( !Ext.isEmpty( deadlines ) ) {
    var rec = store.recordType;

    Ext.each( deadlines, function( d, index, ds ) {
      if ( d.execution === 'ASYNCHR' ) {
        var deadline = new rec( {
          exceptionName: d.exceptionName
        } );

        store.add( deadline );
      }
    } );

    store.commitChanges();
  }

  if ( store.getCount() > 0 ) {
    store.sort( 'exceptionName', 'ASC' );
  }

  config = Ext.apply( {
    anchor: '100%',
    ref: 'asynchronousActivityDeadlinesChooser',
    triggerAction: 'all',
    mode: 'local',
    store: store,
    valueField: 'exceptionName',
    displayField: 'exceptionName',
    forceSelection: true,
    resizable: true
  }, config );

  Ext.ux.suncode.AsynchronousActivityDeadlinesChooser.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.AsynchronousActivityDeadlinesChooser, Ext.form.ComboBox, {
  initComponent: function() {
    Ext.ux.suncode.AsynchronousActivityDeadlinesChooser.superclass.initComponent.call( this );
  }
} );