Ext.ux.suncode.BarcodePrintButtonDefPanel = function( config ) {
    var component = config.component;
    var objectDef = component.definition.objectDef;
    var activityNode = config.activityNode;
    var processNode = activityNode.parentNode;
    var mainPanel = Ext.getCmp( 'main_panel' );
    var animationsOn = mainPanel.getAnimationsOn();
    var labelTextVarLabel = addTooltipToField( getTranslation( 'Zmienna' ),
    		getTranslation( 'Zmienna na formularzu, w której znajduje się wartość' )
    		+ '<br>' + getTranslation( 'drukowana na kodzie kreskowym' ) );

    config = Ext.apply( {
        layoutConfig: {
            trackLabels: true
        },
        frame: false,
        border: false,
        bodyCssClass: 'x-Module-container-padding',
        labelWidth: 250,
        autoHeight: true,
        ref: 'buttonDefPanel',
        items: [ {
            xtype: 'displayfield',
            inputType: 'text',
            fieldLabel: getTranslation( 'Nazwa akcji' ),
            anchor: '100%',
            hidden: !config.AV,
            value: 'drukuj_kod_kreskowy'
        }, {
            xtype: 'displayfield',
            inputType: 'text',
            fieldLabel: getTranslation( 'Nazwa przycisku' ),
            anchor: '100%',
            value: getTranslation( 'Drukuj kod kreskowy' )
        }, {
            xtype: 'textfield',
            inputType: 'text',
            fieldLabel: getTranslation( 'Ścieżka do etykiety' ),
            anchor: '100%',
            ref: 'labelPathItem',
            value: objectDef.labelPath
        }, {
            xtype: 'compositefield',
            anchor: '100%',
            ref: 'labelTextVarItem',
            fieldLabel: labelTextVarLabel,
            items: [ new Ext.ux.suncode.FormVariableChooser( {
                forceSelection: true,
                value: objectDef.labelTextVar
            } ) ]
        }, new Ext.ux.suncode.SystemColorsChooser( {
          color: objectDef.color
        } ) ]
    }, config );

    Ext.ux.suncode.BarcodePrintButtonDefPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.BarcodePrintButtonDefPanel, Ext.FormPanel, {
    initComponent: function() {
        Ext.ux.suncode.BarcodePrintButtonDefPanel.superclass.initComponent.call( this );
    },
    editFormButton: function() {
        var btnDef = this.readDef();
        if ( !btnDef ) {
            return;
        }

        var component = this.initialConfig.component;
        var item = component.items.first();
        var objectDef = component.definition.objectDef;
        Ext.apply( objectDef, btnDef );

        item.setText( objectDef.buttonName );
        Ext.ux.suncode.UtilService.resolveFormButtonColor(item, objectDef.color);
        component.idAssigned = true;

        this.ownerCt.closeDefWindow();
    },
    readDef: function() {
        var btnDef = new Object();
        var actionName = 'drukuj_kod_kreskowy';
        var labelPath = this.labelPathItem.getValue();
        var labelTextVar = this.labelTextVarItem.items.first().getValue();

        if ( Ext.isEmpty( labelPath ) ) {
            showWarn( getTranslation( 'Podaj ścieżkę do etykiety.' ) );
            return null;
        } else if ( Ext.isEmpty( labelTextVar ) ) {
            showWarn( getTranslation( 'Wybierz zmienną.' ) );
            return null;
        } else if ( this.checkDuplication( actionName ) ) {
            showWarn( getTranslation( 'Zmienna procesu/tabela dynamiczna/etykieta/przycisk o tym samym identyfikatorze został już dodany do formularza.' ) );
            return null;
        }

        btnDef = Ext.apply( {
            actionName: actionName,
            buttonName: getTranslation( 'Drukuj kod kreskowy' ),
            labelPath: labelPath,
            labelTextVar: labelTextVar,
            color: this.colorsChooser.getValue(),
            checkForm: false,
            genre: 'BARCODE_PRINT'
        }, btnDef );

        return btnDef;
    },
    checkDuplication: function( actionName ) {
        var component = this.initialConfig.component;

        if ( component.idAssigned && component.definition.objectDef.actionName == actionName ) {
            return false;
        } else {
            var drawingPanel = Ext.getCmp( 'drawing_panel' );
            var isDuplicated = false;

            drawingPanel.items.each( function( item ) {
                item.items.each( function( subitem ) {
                	var definition = subitem.definition;
                    var objectDef = definition.objectDef;

                    switch ( objectDef.genre ) {
	                    case 'VARIABLE':
	                        if ( subitem.idAssigned &&
	                        		( objectDef.varId == actionName || objectDef.varId == actionName + '_button' ) ) {
	                            isDuplicated = true;
	                            return false;
	                        }
	                        break;
                        case 'VARIABLE_SET':
                        	if ( subitem.idAssigned ) {
                        		if ( objectDef.varId == actionName || objectDef.varId == actionName + '_button' ) {
                                    isDuplicated = true;
                                    return false;
                                } else {
                                    var columns = objectDef.columns;

                                    for ( var i = 0; i < columns.length; i++ ) {
                                        var column = columns[i];

                                        if ( column.varId == actionName || column.varId == actionName + '_button' ) {
                                            isDuplicated = true;
                                            return false;
                                        }
                                    }
                                    
                                    var dtButtons = objectDef.DTButtons;

                                    for ( var i = 0; i < dtButtons.length; i++ ) {
                                        var dtButton = dtButtons[i];

                                        if ( dtButton.buttonId == actionName || dtButton.buttonId == actionName + '_button' ) {
                                            isDuplicated = true;
                                            return false;
                                        }
                                    }
                                }
                            }
                        	break;
                        case 'LABEL':
                            if ( subitem.idAssigned && objectDef.id == actionName + '_button' ) {
                                isDuplicated = true;
                                return false;
                            }
                            break;
                        case 'HTTP_LINK':
                        case 'ACTION_ACCEPT_BUTTON':
                        case 'GENERATE_PDF_BUTTON':
                        case 'ADD_FILE_BUTTON':
                        case 'BARCODE_PRINT':
                            if ( subitem.idAssigned && objectDef.actionName == actionName ) {
                                isDuplicated = true;
                                return false;
                            }
                            break;
                        default:
                            break;
                    }
                } );

                if ( isDuplicated ) {
                    return false;
                }
            } );

            return isDuplicated;
        }
    }
} );