/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.web.support.dto.xpdl.builder;

import com.suncode.plugin.pwe.util.comparator.ProcessVersionDtoComparator;
import com.suncode.plugin.pwe.web.support.dto.xpdl.ProcessVersionDto;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ProcessVersionDtoBuilder {
    public List<ProcessVersionDto> build(String processDefId, List<File> specificationFiles) {
        ArrayList<ProcessVersionDto> dtos = new ArrayList<ProcessVersionDto>();
        if (CollectionUtils.isNotEmpty(specificationFiles)) {
            for (File specificationFile : specificationFiles) {
                if (!this.isCurrentProcessSpecificationFolder(processDefId, specificationFile)) continue;
                dtos.add(this.build(specificationFile));
            }
        }
        Collections.sort(dtos, new ProcessVersionDtoComparator());
        return dtos;
    }

    private boolean isCurrentProcessSpecificationFolder(String processDefId, File specificationFile) {
        return StringUtils.equals((CharSequence)specificationFile.getParentFile().getName(), (CharSequence)processDefId);
    }

    public ProcessVersionDto build(File specificationFile) {
        ProcessVersionDto dto = new ProcessVersionDto();
        dto.setProcessVersion(this.getProcessVersion(specificationFile));
        dto.setSpecificationFile(specificationFile.getAbsolutePath());
        return dto;
    }

    private String getProcessVersion(File specificationFile) {
        File processDirectory = specificationFile.getParentFile();
        File packageDicertory = processDirectory.getParentFile();
        return StringUtils.substringAfter((String)packageDicertory.getName(), (String)"v");
    }
}

