/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.util.translation.builder;

import com.suncode.plugin.pwe.service.userconfig.UserConfigService;
import com.suncode.plugin.pwe.util.translation.TranslationInfo;
import com.suncode.plugin.pwe.web.support.dto.userconfig.UserConfigDto;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;

@Component
public class TranslationInfoBuilder {
    @Autowired
    private UserConfigService userConfigService;

    public TranslationInfo build(String userId, String packageId, Map<Locale, Map<String, String>> translationsForLanguages) {
        TranslationInfo translationInfo = new TranslationInfo();
        translationInfo.setPackageId(packageId);
        translationInfo.setTranslations(this.buildTranslations(userId, translationsForLanguages));
        return translationInfo;
    }

    private Map<String, String> buildTranslations(String userId, Map<Locale, Map<String, String>> translationsForLanguages) {
        UserConfigDto userConfigDto = this.userConfigService.getForUser(userId, false);
        Locale locale = Optional.ofNullable(userConfigDto).map(UserConfigDto::getXpdlTranslationLanguage).filter(Objects::nonNull).map(language -> new Locale((String)language)).orElseGet(() -> LocaleContextHolder.getLocale());
        return translationsForLanguages.getOrDefault(locale, new HashMap());
    }
}

