/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.service.userconfig;

import com.suncode.plugin.framework.service.Provides;
import com.suncode.plugin.pwe.dao.userconfig.UserConfigDao;
import com.suncode.plugin.pwe.model.userconfig.UserConfig;
import com.suncode.plugin.pwe.service.userconfig.UserConfigService;
import com.suncode.plugin.pwe.web.support.dto.userconfig.UserConfigDto;
import com.suncode.plugin.pwe.web.support.dto.userconfig.builder.UserConfigDtoBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@Provides(value={UserConfigService.class})
public class UserConfigServiceImpl
implements UserConfigService {
    @Autowired
    private UserConfigDao userConfigDao;
    @Autowired
    private UserConfigDtoBuilder userConfigDtoBuilder;

    @Override
    public UserConfigDto getForUser(String userId, boolean canUseDefaultUserConfig) {
        UserConfig config = this.userConfigDao.getForUser(userId);
        if (config != null) {
            return this.userConfigDtoBuilder.build(config);
        }
        if (canUseDefaultUserConfig) {
            return this.userConfigDtoBuilder.build();
        }
        return null;
    }

    @Override
    public boolean setForUser(String userId, UserConfigDto dto) {
        UserConfig config = this.userConfigDao.getForUser(userId);
        if (config != null) {
            config.setAdvancedView(dto.getAdvancedView());
            config.setAnimationsOn(dto.getAnimationsOn());
            config.setCompatibilityMode(dto.getCompatibilityMode());
            config.setDistinctionColor(dto.getDistinctionColor());
            config.setDocumentationView(dto.getDocumentationView());
            config.setExperimentalView(dto.getExperimentalView());
            config.setExportJs(dto.getExportJs());
            config.setExportJavaCode(dto.getExportJavaCode());
            config.setHoverColor(dto.getHoverColor());
            config.setIncomingTransitionColor(dto.getIncomingTransitionColor());
            config.setOutgoingTransitionColor(dto.getOutgoingTransitionColor());
            config.setShowDeprecatedComponents(dto.getShowDeprecatedComponents());
            config.setShowTooltips(dto.getShowTooltips());
            config.setSnapToGrid(dto.getSnapToGrid());
            config.setShowGrid(dto.getShowGrid());
            config.setGridSize(dto.getGridSize());
            config.setXpdlTranslationLanguage(dto.getXpdlTranslationLanguage());
            config.setUseExternalClipboard(dto.getUseExternalClipboard());
            this.userConfigDao.update(config);
            return true;
        }
        config = this.userConfigDtoBuilder.extract(userId, dto);
        Long id = (Long)this.userConfigDao.save(config);
        return id != null;
    }
}

