/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.service.standardautoupdate;

import com.plusmpm.util.ClasspathScanner;
import com.plusmpm.util.form.autoupdate.DataSource;
import com.plusmpm.util.form.autoupdate.Definition;
import com.plusmpm.util.form.autoupdate.Destination;
import com.plusmpm.util.form.autoupdate.StandardAutoUpdate;
import com.suncode.plugin.pwe.util.PweUtils;
import com.suncode.plugin.pwe.web.support.dto.standardautoupdate.StandardAutoUpdateDto;
import com.suncode.plugin.pwe.web.support.dto.standardautoupdate.builder.StandardAutoUpdateDtoBuilder;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StandardAutoUpdateService {
    public static Logger log = Logger.getLogger(StandardAutoUpdateService.class);
    private static final Class<? extends Annotation> AUTO_UPDATE_ANNOTATION = StandardAutoUpdate.class;
    private static final String GET_IDS_METHOD_NAME = "getIds";
    private static final String GET_DEF_METHOD_NAME = "getDef";
    private static final String GET_DATA_SOURCES_METHOD_NAME = "getDataSources";
    private static final String GET_DESTINATIONS_METHOD_NAME = "getDestinations";
    @Autowired
    private StandardAutoUpdateDtoBuilder standardAutoUpdateDtoBuilder;

    public List<StandardAutoUpdateDto> findAll() {
        ArrayList<StandardAutoUpdateDto> dtos = new ArrayList<StandardAutoUpdateDto>();
        List clazzes = ClasspathScanner.getAllClassesWithAnnotation(AUTO_UPDATE_ANNOTATION);
        if (CollectionUtils.isNotEmpty((Collection)clazzes)) {
            String language = PweUtils.getLanguage();
            int counter = 0;
            for (Class clazz : clazzes) {
                try {
                    StandardAutoUpdate autoUpdate = (StandardAutoUpdate)clazz.getAnnotation(AUTO_UPDATE_ANNOTATION);
                    Class configurationClass = autoUpdate.conf();
                    if (configurationClass == null) continue;
                    dtos.addAll(this.buildDefinitions(language, counter, configurationClass));
                    ++counter;
                }
                catch (Exception exception) {
                    log.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
        }
        return dtos;
    }

    private List<StandardAutoUpdateDto> buildDefinitions(String language, int counter, Class<?> configurationClass) throws InstantiationException, IllegalAccessException, NoSuchMethodException, SecurityException, IllegalArgumentException, InvocationTargetException {
        ArrayList<StandardAutoUpdateDto> dtos = new ArrayList<StandardAutoUpdateDto>();
        Object instance = configurationClass.newInstance();
        Method getIds = configurationClass.getMethod(GET_IDS_METHOD_NAME, new Class[0]);
        List ids = (List)getIds.invoke(instance, new Object[0]);
        if (CollectionUtils.isNotEmpty((Collection)ids)) {
            for (String id : ids) {
                Method getDef = configurationClass.getMethod(GET_DEF_METHOD_NAME, String.class, String.class);
                Definition definition = (Definition)getDef.invoke(instance, id, language);
                if (!this.hasValidDefinition(definition)) continue;
                Method getDataSources = configurationClass.getMethod(GET_DATA_SOURCES_METHOD_NAME, String.class, String.class);
                List dataSources = (List)getDataSources.invoke(instance, id, language);
                Method getDestinations = configurationClass.getMethod(GET_DESTINATIONS_METHOD_NAME, String.class, String.class);
                List destinations = (List)getDestinations.invoke(instance, id, language);
                dtos.add(this.buildDefinition(counter, definition, dataSources, destinations));
            }
        }
        return dtos;
    }

    private boolean hasValidDefinition(Definition definition) {
        return definition != null && StringUtils.isNotBlank((CharSequence)definition.getTaskName()) && StringUtils.isNotBlank((CharSequence)definition.getType()) && StringUtils.isNotBlank((CharSequence)definition.getName());
    }

    private StandardAutoUpdateDto buildDefinition(int counter, Definition definition, List<DataSource> dataSources, List<Destination> destinations) {
        return this.standardAutoUpdateDtoBuilder.build(Long.valueOf(counter), definition, dataSources, destinations);
    }
}

