/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.service.permission;

import com.suncode.plugin.framework.service.Provides;
import com.suncode.plugin.pwe.dao.permission.PermissionDao;
import com.suncode.plugin.pwe.model.permission.Permission;
import com.suncode.plugin.pwe.service.permission.PermissionService;
import com.suncode.plugin.pwe.util.AuditType;
import com.suncode.plugin.pwe.util.PageResult;
import com.suncode.plugin.pwe.util.PermissionFilter;
import com.suncode.plugin.pwe.util.SortDirection;
import com.suncode.plugin.pwe.web.support.dto.permission.PermissionDto;
import com.suncode.plugin.pwe.web.support.dto.permission.PermissionOperationDto;
import com.suncode.plugin.pwe.web.support.dto.permission.builder.PermissionDtoBuilder;
import com.suncode.plugin.pwe.web.support.dto.permission.builder.PermissionOperationDtoBuilder;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserGroup;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.audit.builder.ManualAuditBuilder;
import com.suncode.pwfl.util.ServiceFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@Provides(value={PermissionService.class})
public class PermissionServiceImpl
implements PermissionService {
    public static Logger log = Logger.getLogger(PermissionServiceImpl.class);
    @Autowired
    private PermissionDao permissionDao;
    @Autowired
    private PermissionDtoBuilder permissionDtoBuilder;
    @Autowired
    private PermissionOperationDtoBuilder permissionOperationDtoBuilder;

    @Override
    public PageResult<PermissionDto> get(PermissionFilter filter, int offset, int limit, String sort, String direction) {
        List<Permission> permissions = this.permissionDao.get(filter, offset, limit, sort, SortDirection.getByName(direction));
        long total = this.permissionDao.count(filter);
        List<PermissionDto> dtos = this.permissionDtoBuilder.build(permissions);
        return new PageResult<PermissionDto>(dtos, total);
    }

    @Override
    public PermissionOperationDto add(String userId, PermissionDto dto) {
        Date started = new Date();
        Permission permission = this.permissionDao.get(dto.getScope(), dto.getValue());
        if (permission == null) {
            permission = this.permissionDtoBuilder.extract(dto);
            Long id = (Long)this.permissionDao.save(permission);
            if (id != null) {
                this.logAddPermissionAudit(userId, started, true, dto.getScope(), dto.getValue());
                return this.permissionOperationDtoBuilder.buildSuccess();
            }
            this.logAddPermissionAudit(userId, started, false, dto.getScope(), dto.getValue());
            return this.permissionOperationDtoBuilder.buildError("Wyst\u0105pi\u0142 b\u0142\u0105d.");
        }
        this.logAddPermissionAudit(userId, started, false, dto.getScope(), dto.getValue());
        return this.permissionOperationDtoBuilder.buildError("Uprawnienie ju\u017c istnieje.");
    }

    private void logAddPermissionAudit(String userId, Date started, boolean success, String scope, String value) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("pwe.audit.permission.add.param.scope", scope);
        params.put("pwe.audit.permission.add.param.value", value);
        ManualAuditBuilder.getInstance().type(AuditType.AUDIT_ADD_PERMISSION.getValue()).username(userId).success(success).params(params).started(started).stopped(new Date()).build().log();
    }

    @Override
    public PermissionOperationDto delete(String userId, Long id) {
        Date started = new Date();
        Permission permission = (Permission)this.permissionDao.get(id);
        if (permission != null) {
            this.permissionDao.delete(permission);
            this.logDeletePermissionAudit(userId, started, true, permission.getScope(), permission.getValue());
            return this.permissionOperationDtoBuilder.buildSuccess();
        }
        this.logDeletePermissionAudit(userId, started, false, "", "");
        return this.permissionOperationDtoBuilder.buildError("Uprawnienie nie istnieje.");
    }

    private void logDeletePermissionAudit(String userId, Date started, boolean success, String scope, String value) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("pwe.audit.permission.delete.param.scope", scope);
        params.put("pwe.audit.permission.delete.param.value", value);
        ManualAuditBuilder.getInstance().type(AuditType.AUDIT_DELETE_PERMISSION.getValue()).username(userId).success(success).params(params).started(started).stopped(new Date()).build().log();
    }

    @Override
    public boolean isAuthorized(String userId) {
        if (StringUtils.isNotBlank((CharSequence)userId)) {
            UserService userService = ServiceFactory.getUserService();
            User user = userService.getUser(userId, new String[]{"groups"});
            if (user != null) {
                List<String> userGroupNames = this.buildUserGroupNames(user);
                List<Permission> permissions = this.permissionDao.get(userId, userGroupNames);
                return CollectionUtils.isNotEmpty(permissions);
            }
            return false;
        }
        return false;
    }

    private List<String> buildUserGroupNames(User user) {
        ArrayList<String> names = new ArrayList<String>();
        Set groups = user.getGroups();
        if (CollectionUtils.isNotEmpty((Collection)groups)) {
            for (UserGroup group : groups) {
                names.add(group.getName());
            }
        }
        return names;
    }
}

