/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Type;
import java.util.List;

public abstract class JsonConverter<T> {
    public T convertToObject(String string) {
        Gson gson = this.initDeserializingGson();
        return (T)gson.fromJson(string, this.getObjectType());
    }

    public List<T> convertToList(String string) {
        Gson gson = this.initDeserializingGson();
        return (List)gson.fromJson(string, this.getListType());
    }

    public String convertFromList(List<T> objects) {
        Gson gson = this.initSerializingGson();
        return gson.toJson(objects);
    }

    private Gson initDeserializingGson() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        return gsonBuilder.create();
    }

    private Gson initSerializingGson() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        return gsonBuilder.create();
    }

    public abstract Type getObjectType();

    public abstract Type getListType();
}

