/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.subchapter.builder;

import com.suncode.plugin.pwe.documentation.Documentation;
import com.suncode.plugin.pwe.documentation.NumberedPoints;
import com.suncode.plugin.pwe.documentation.ParagraphContent;
import com.suncode.plugin.pwe.documentation.ParagraphContents;
import com.suncode.plugin.pwe.documentation.TableHeaders;
import com.suncode.plugin.pwe.documentation.TableRecords;
import com.suncode.plugin.pwe.documentation.util.LeftIndents;
import com.suncode.plugin.pwe.documentation.util.ParagraphIndentsUtils;
import com.suncode.plugin.pwe.documentation.util.TextValueUtils;
import com.suncode.plugin.pwe.service.translator.TranslatorService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SubchapterBuilder {
    @Autowired
    private TranslatorService translatorService;

    public void build(Documentation documentation, String titleKey, String text, int subchapterNo) {
        String title = this.buildSubchapterTitle(subchapterNo, titleKey);
        ParagraphContents contents = this.buildSubchapterContents(text);
        documentation.addSubchapter(title, contents);
    }

    public void build(Documentation documentation, String titleKey, String text, int chapterNo, int subchapterNo) {
        String title = this.buildSubchapterTitle(chapterNo, subchapterNo, titleKey);
        ParagraphContents contents = this.buildSubchapterContents(text);
        documentation.addSubchapter(title, contents);
    }

    public void build(Documentation documentation, String titleKey, TableHeaders headers, TableRecords records, int chapterNo, int subchapterNo) {
        String title = this.buildSubchapterTitle(chapterNo, subchapterNo, titleKey);
        documentation.addSubchapter(title, headers, records);
    }

    public void build(Documentation documentation, String titleKey, NumberedPoints points, int subchapterNo) {
        String title = this.buildSubchapterTitle(subchapterNo, titleKey);
        documentation.addSubchapter(title, points);
    }

    public void build(Documentation documentation, String titleKey, NumberedPoints points, int chapterNo, int subchapterNo) {
        String title = this.buildSubchapterTitle(chapterNo, subchapterNo, titleKey);
        documentation.addSubchapter(title, points);
    }

    public void build(Documentation documentation, NumberedPoints points) {
        documentation.addNumberedPoints(points);
    }

    public void build(Documentation documentation, NumberedPoints points, int leftIndents) {
        documentation.addNumberedPoints(points, leftIndents);
    }

    public void build(Documentation documentation, String titleKey) {
        this.build(documentation, titleKey, "", new LeftIndents(1));
    }

    public void build(Documentation documentation, String titleKey, String text) {
        this.build(documentation, titleKey, text, new LeftIndents(1));
    }

    public void build(Documentation documentation, String titleKey, ParagraphContents contents) {
        this.build(documentation, titleKey, 1, contents);
    }

    public void build(Documentation documentation, String titleKey, int titleLeftIndents, ParagraphContents contents) {
        documentation.addParagraph(this.buildTitleContents(titleKey, titleLeftIndents));
        documentation.addParagraph(contents);
        documentation.addNewLine();
    }

    public void build(Documentation documentation, String titleKey, String text, LeftIndents leftIndents) {
        documentation.addParagraph(this.buildTitleContents(titleKey, leftIndents.getIndents()));
        if (StringUtils.isNotBlank((CharSequence)text)) {
            documentation.addParagraph(this.buildSubchapterContents(text, leftIndents.getIndents(), false));
        }
        documentation.addNewLine();
    }

    public void build(Documentation documentation, String titleKey, TableHeaders headers, TableRecords records) {
        this.build(documentation, titleKey, 1, headers, records);
    }

    public void build(Documentation documentation, String titleKey, int titleLeftIndents, TableHeaders headers, TableRecords records) {
        documentation.addParagraph(this.buildTitleContents(titleKey, titleLeftIndents));
        this.build(documentation, headers, records);
    }

    public void build(Documentation documentation, TableHeaders headers, TableRecords records) {
        documentation.addTable(headers, records);
        documentation.addNewLine();
    }

    public void build(Documentation documentation, String title, int leftIndents) {
        documentation.addParagraph(this.buildSubchapterContents(title, leftIndents, true));
    }

    public void build(Documentation documentation, ParagraphContents contents) {
        documentation.addParagraph(contents);
    }

    private String buildSubchapterTitle(int subchapterNo, String key) {
        return this.translatorService.translateDocumentationSubchapterTitle(subchapterNo, key);
    }

    private String buildSubchapterTitle(int chapterNo, int subchapterNo, String key) {
        return this.translatorService.translateDocumentationSubchapterTitle(chapterNo, subchapterNo, key);
    }

    private ParagraphContents buildSubchapterContents(String text) {
        return this.buildSubchapterContents(text, 1, false);
    }

    private ParagraphContents buildSubchapterContents(String text, int leftIndents, boolean bold) {
        ParagraphContent content = new ParagraphContent();
        content.setBold(bold);
        content.setTextValue(TextValueUtils.build(text));
        return this.buildContents(content, leftIndents);
    }

    private ParagraphContents buildTitleContents(String titleKey, int titleLeftIndents) {
        StringBuilder text = new StringBuilder();
        text.append(this.translatorService.translateMessage(titleKey));
        text.append(":");
        ParagraphContent content = new ParagraphContent();
        content.setBold(true);
        content.setTextValue(TextValueUtils.build(text.toString()));
        return this.buildContents(content, titleLeftIndents);
    }

    private ParagraphContents buildContents(ParagraphContent content, int leftIndents) {
        ParagraphContents contents = new ParagraphContents();
        contents.setIndents(ParagraphIndentsUtils.buildLeft(leftIndents));
        contents.addContent(content);
        return contents;
    }

    public void build(Documentation documentation, String titleKey, List<ParagraphContents> numberedList, int subchapterNo) {
        String title = this.buildSubchapterTitle(subchapterNo, titleKey);
        documentation.addSubchapter(title, numberedList);
    }

    public void build(Documentation documentation, String titleKey, ParagraphContents paragraphContents, int subchapterNo) {
        String title = this.buildSubchapterTitle(subchapterNo, titleKey);
        documentation.addSubchapter(title, paragraphContents);
    }
}

