/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.comparator.subcomparator;

import com.suncode.plugin.pwe.documentation.comparator.subcomparator.ActivitySpecificationSubcomparator;
import com.suncode.plugin.pwe.documentation.comparator.subcomparator.ProcessSpecificationSubcomparator;
import com.suncode.plugin.pwe.documentation.object.Difference;
import com.suncode.plugin.pwe.documentation.object.builder.DifferenceBuilder;
import com.suncode.plugin.pwe.documentation.object.builder.SpecificationDescriptionPartBuilder;
import com.suncode.plugin.pwe.documentation.specification.ActivitySpecification;
import com.suncode.plugin.pwe.documentation.specification.ButtonSpecification;
import com.suncode.plugin.pwe.documentation.specification.DtButtonSpecification;
import com.suncode.plugin.pwe.documentation.specification.FormVariableSpecification;
import com.suncode.plugin.pwe.documentation.specification.GeneratedDocumentSpecification;
import com.suncode.plugin.pwe.documentation.specification.TransitionSpecification;
import com.suncode.plugin.pwe.documentation.specification.ViewDocumentClassSpecification;
import com.suncode.plugin.pwe.documentation.util.ComparatorUtils;
import com.suncode.plugin.pwe.util.translation.TranslationInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="activitySpecificationsSubcomparator")
public class ActivitySpecificationsSubcomparatorImpl
implements ProcessSpecificationSubcomparator<Map<String, ActivitySpecification>> {
    private static final String GENERAL_ACTIVITY_DESCRIPTION_MODIFIED = "pwe.documentation.changecard.modified.generalactivitydescription";
    private static final String EMAIL_NOTIFICATIONS_DESCRIPTION_MODIFIED = "pwe.documentation.changecard.modified.emailnotificationsdescriptionforactivity";
    private static final String GENERATED_DOCUMENT_ADDED = "pwe.documentation.changecard.added.activitygenerateddocument";
    private static final String GENERATED_DOCUMENT_DELETED = "pwe.documentation.changecard.deleted.activitygenerateddocument";
    private static final String VIEW_DOCUMENT_CLASS_ADDED = "pwe.documentation.changecard.added.viewdocumentclass";
    private static final String VIEW_DOCUMENT_CLASS_DELETED = "pwe.documentation.changecard.deleted.viewdocumentclass";
    @Autowired
    private SpecificationDescriptionPartBuilder specificationDescriptionPartBuilder;
    @Autowired
    private DifferenceBuilder differenceBuilder;
    @Autowired
    @Qualifier(value="buttonSpecificationsSubcomparator")
    private ActivitySpecificationSubcomparator<Map<String, ButtonSpecification>> buttonSpecificationsSubcomparator;
    @Autowired
    @Qualifier(value="dtButtonSpecificationsSubcomparator")
    private ActivitySpecificationSubcomparator<Map<String, DtButtonSpecification>> dtButtonSpecificationsSubcomparator;
    @Autowired
    @Qualifier(value="formVariableSpecificationsSubcomparator")
    private ActivitySpecificationSubcomparator<Map<String, FormVariableSpecification>> formVariableSpecificationsSubcomparator;
    @Autowired
    @Qualifier(value="transitionSpecificationsSubcomparator")
    private ActivitySpecificationSubcomparator<Map<String, TransitionSpecification>> transitionSpecificationsSubcomparator;

    @Override
    public List<Difference> compare(WorkflowProcess baseProcess, Map<String, ActivitySpecification> base, WorkflowProcess comparedProcess, Map<String, ActivitySpecification> compared, TranslationInfo translationInfo) {
        ArrayList<Difference> differences = new ArrayList<Difference>();
        if (MapUtils.isNotEmpty(compared)) {
            for (String id : compared.keySet()) {
                if (!base.containsKey(id)) continue;
                ActivitySpecification baseSpecification = base.get(id);
                ActivitySpecification comparedSpecification = compared.get(id);
                if (!StringUtils.equalsIgnoreCase((CharSequence)baseSpecification.getGeneralActivityDescription(), (CharSequence)comparedSpecification.getGeneralActivityDescription())) {
                    String baseGeneralActivityDescription = this.buildGeneralActivityDescription(baseProcess, translationInfo, baseSpecification);
                    String comparedGeneralActivityDescription = this.buildGeneralActivityDescription(comparedProcess, translationInfo, comparedSpecification);
                    differences.add(this.differenceBuilder.build(GENERAL_ACTIVITY_DESCRIPTION_MODIFIED, id, baseGeneralActivityDescription, comparedGeneralActivityDescription));
                }
                if (!StringUtils.equalsIgnoreCase((CharSequence)baseSpecification.getEmailNotificationsDescription(), (CharSequence)comparedSpecification.getEmailNotificationsDescription())) {
                    String baseEmailNotificationsDescription = this.buildEmailNotificationsDescription(baseProcess, translationInfo, baseSpecification);
                    String comparedEmailNotificationsDescription = this.buildEmailNotificationsDescription(comparedProcess, translationInfo, comparedSpecification);
                    differences.add(this.differenceBuilder.build(EMAIL_NOTIFICATIONS_DESCRIPTION_MODIFIED, id, baseEmailNotificationsDescription, comparedEmailNotificationsDescription));
                }
                differences.addAll(this.compareGeneratedDocuments(id, baseSpecification, comparedSpecification));
                differences.addAll(this.compareViewDocumentClasses(id, baseSpecification, comparedSpecification));
                differences.addAll(this.compareButtonSpecifications(id, baseProcess, baseSpecification, comparedProcess, comparedSpecification, translationInfo));
                differences.addAll(this.compareDtButtonSpecifications(id, baseProcess, baseSpecification, comparedProcess, comparedSpecification, translationInfo));
                differences.addAll(this.compareFormVariableSpecifications(id, baseProcess, baseSpecification, comparedProcess, comparedSpecification, translationInfo));
                differences.addAll(this.compareTransitionSpecifications(id, baseProcess, baseSpecification, comparedProcess, comparedSpecification, translationInfo));
            }
        }
        return differences;
    }

    private String buildGeneralActivityDescription(WorkflowProcess process, TranslationInfo translationInfo, ActivitySpecification activitySpecification) {
        return this.specificationDescriptionPartBuilder.buildAsString(process, translationInfo, activitySpecification.getGeneralActivityDescription());
    }

    private String buildEmailNotificationsDescription(WorkflowProcess process, TranslationInfo translationInfo, ActivitySpecification activitySpecification) {
        return this.specificationDescriptionPartBuilder.buildAsString(process, translationInfo, activitySpecification.getEmailNotificationsDescription());
    }

    private List<Difference> compareGeneratedDocuments(String id, ActivitySpecification base, ActivitySpecification compared) {
        ArrayList<Difference> differences = new ArrayList<Difference>();
        List<GeneratedDocumentSpecification> added = ComparatorUtils.getAdded(base.getGeneratedDocuments(), compared.getGeneratedDocuments());
        List<GeneratedDocumentSpecification> deleted = ComparatorUtils.getDeleted(base.getGeneratedDocuments(), compared.getGeneratedDocuments());
        if (CollectionUtils.isNotEmpty(added)) {
            for (GeneratedDocumentSpecification generatedDocument : added) {
                differences.add(this.differenceBuilder.build(GENERATED_DOCUMENT_ADDED, generatedDocument.getName(), id));
            }
        }
        if (CollectionUtils.isNotEmpty(deleted)) {
            for (GeneratedDocumentSpecification generatedDocument : deleted) {
                differences.add(this.differenceBuilder.build(GENERATED_DOCUMENT_DELETED, generatedDocument.getName(), id));
            }
        }
        return differences;
    }

    private List<Difference> compareViewDocumentClasses(String id, ActivitySpecification base, ActivitySpecification compared) {
        ArrayList<Difference> differences = new ArrayList<Difference>();
        List<ViewDocumentClassSpecification> added = ComparatorUtils.getAdded(base.getViewDocumentClasses(), compared.getViewDocumentClasses());
        List<ViewDocumentClassSpecification> deleted = ComparatorUtils.getDeleted(base.getViewDocumentClasses(), compared.getViewDocumentClasses());
        if (CollectionUtils.isNotEmpty(added)) {
            for (ViewDocumentClassSpecification viewDocumentClass : added) {
                differences.add(this.differenceBuilder.build(VIEW_DOCUMENT_CLASS_ADDED, viewDocumentClass.getName(), id));
            }
        }
        if (CollectionUtils.isNotEmpty(deleted)) {
            for (ViewDocumentClassSpecification viewDocumentClass : deleted) {
                differences.add(this.differenceBuilder.build(VIEW_DOCUMENT_CLASS_DELETED, viewDocumentClass.getName(), id));
            }
        }
        return differences;
    }

    private List<Difference> compareButtonSpecifications(String id, WorkflowProcess baseProcess, ActivitySpecification base, WorkflowProcess comparedProcess, ActivitySpecification compared, TranslationInfo translationInfo) {
        return this.buttonSpecificationsSubcomparator.compare(id, baseProcess, base.getButtonSpecifications(), comparedProcess, compared.getButtonSpecifications(), translationInfo);
    }

    private List<Difference> compareDtButtonSpecifications(String id, WorkflowProcess baseProcess, ActivitySpecification base, WorkflowProcess comparedProcess, ActivitySpecification compared, TranslationInfo translationInfo) {
        return this.dtButtonSpecificationsSubcomparator.compare(id, baseProcess, base.getDtButtonSpecifications(), comparedProcess, compared.getDtButtonSpecifications(), translationInfo);
    }

    private List<Difference> compareFormVariableSpecifications(String id, WorkflowProcess baseProcess, ActivitySpecification base, WorkflowProcess comparedProcess, ActivitySpecification compared, TranslationInfo translationInfo) {
        return this.formVariableSpecificationsSubcomparator.compare(id, baseProcess, base.getFormVariableSpecifications(), comparedProcess, compared.getFormVariableSpecifications(), translationInfo);
    }

    private List<Difference> compareTransitionSpecifications(String id, WorkflowProcess baseProcess, ActivitySpecification base, WorkflowProcess comparedProcess, ActivitySpecification compared, TranslationInfo translationInfo) {
        return this.transitionSpecificationsSubcomparator.compare(id, baseProcess, base.getTransitionSpecifications(), comparedProcess, compared.getTransitionSpecifications(), translationInfo);
    }
}

