/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.chapter.point.builder;

import com.suncode.plugin.pwe.documentation.ParagraphContents;
import com.suncode.plugin.pwe.documentation.Table;
import com.suncode.plugin.pwe.documentation.TableCell;
import com.suncode.plugin.pwe.documentation.TableHeader;
import com.suncode.plugin.pwe.documentation.TableHeaders;
import com.suncode.plugin.pwe.documentation.TableRecord;
import com.suncode.plugin.pwe.documentation.TableRecords;
import com.suncode.plugin.pwe.documentation.object.IntegrationComponent;
import com.suncode.plugin.pwe.documentation.object.IntegrationComponentParameter;
import com.suncode.plugin.pwe.documentation.paragraph.builder.IntegrationComponentParameterValueNumberedListBuilder;
import com.suncode.plugin.pwe.documentation.paragraph.builder.IntegrationComponentParameterValueParagraphContentsBuilder;
import com.suncode.plugin.pwe.documentation.util.TableUtils;
import com.suncode.plugin.pwe.service.translator.TranslatorService;
import com.suncode.pwfl.workflow.component.ContextVariable;
import com.suncode.pwfl.workflow.component.declaration.ParameterValue;
import java.math.BigInteger;
import java.util.List;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class IntegrationComponentParametersPointBuilder {
    private static final String NAME_TABLE_COLUMN_ID = "name";
    private static final String NAME_TABLE_HEADER = "pwe.documentation.table.header.name";
    private static final BigInteger NAME_TABLE_CELL_WIDTH = BigInteger.valueOf(2700L);
    private static final String VALUE_TABLE_COLUMN_ID = "value";
    private static final String VALUE_TABLE_HEADER = "pwe.documentation.table.header.value";
    @Autowired
    private TranslatorService translatorService;
    @Autowired
    private IntegrationComponentParameterValueNumberedListBuilder integrationComponentParameterValueNumberedListBuilder;
    @Autowired
    private IntegrationComponentParameterValueParagraphContentsBuilder integrationComponentParameterValueParagraphContentsBuilder;

    public Table build(WorkflowProcess process, IntegrationComponent integrationComponent) {
        TableHeaders headers = this.buildTableHeaders();
        TableRecords records = new TableRecords();
        List<ContextVariable<?>> contextVariables = integrationComponent.getContextVariables();
        for (IntegrationComponentParameter parameter : integrationComponent.getParameters()) {
            records.add(this.buildTableRecord(process, contextVariables, parameter));
        }
        Table table = new Table();
        table.setHeaders(headers);
        table.setRecords(records);
        return table;
    }

    private TableHeaders buildTableHeaders() {
        TableHeaders headers = new TableHeaders();
        headers.add(this.buildTableNameTypeHeader());
        headers.add(this.buildTableValueHeader());
        return headers;
    }

    private TableHeader buildTableNameTypeHeader() {
        TableHeader header = TableUtils.buildTableHeader(NAME_TABLE_COLUMN_ID, this.translatorService.translateMessage(NAME_TABLE_HEADER));
        header.setWidth(NAME_TABLE_CELL_WIDTH);
        return header;
    }

    private TableHeader buildTableValueHeader() {
        return TableUtils.buildTableHeader(VALUE_TABLE_COLUMN_ID, this.translatorService.translateMessage(VALUE_TABLE_HEADER));
    }

    private TableRecord buildTableRecord(WorkflowProcess process, List<ContextVariable<?>> contextVariables, IntegrationComponentParameter parameter) {
        TableRecord record = new TableRecord();
        record.addCell(NAME_TABLE_COLUMN_ID, this.buildTableRecordNameCell(parameter));
        record.addCell(VALUE_TABLE_COLUMN_ID, this.buildTableRecordValueCell(process, contextVariables, parameter));
        return record;
    }

    private TableCell buildTableRecordNameCell(IntegrationComponentParameter parameter) {
        TableCell cell = this.buildTableCell(parameter.getName());
        cell.setWidth(NAME_TABLE_CELL_WIDTH);
        return cell;
    }

    private TableCell buildTableCell(String text) {
        return TableUtils.buildTableCell(text);
    }

    private TableCell buildTableRecordValueCell(WorkflowProcess process, List<ContextVariable<?>> contextVariables, IntegrationComponentParameter parameter) {
        if (CollectionUtils.isEmpty(parameter.getValue())) {
            return this.buildEmptyTableCell();
        }
        if (parameter.isArray()) {
            return this.buildTableRecordArrayValueCell(process, contextVariables, parameter);
        }
        return this.buildTableRecordSingleValueCell(process, contextVariables, parameter);
    }

    private TableCell buildEmptyTableCell() {
        return this.buildTableCell("");
    }

    private TableCell buildTableRecordArrayValueCell(WorkflowProcess process, List<ContextVariable<?>> contextVariables, IntegrationComponentParameter parameter) {
        List<ParameterValue> values = parameter.getValue();
        List<ParagraphContents> numberedList = this.integrationComponentParameterValueNumberedListBuilder.build(process, contextVariables, values);
        return this.buildTableCell(numberedList);
    }

    private TableCell buildTableRecordSingleValueCell(WorkflowProcess process, List<ContextVariable<?>> contextVariables, IntegrationComponentParameter parameter) {
        ParameterValue value = parameter.getValue().get(0);
        ParagraphContents contents = this.integrationComponentParameterValueParagraphContentsBuilder.build(process, contextVariables, value);
        return this.buildTableCell(contents);
    }

    private TableCell buildTableCell(ParagraphContents contents) {
        return TableUtils.buildTableCell(contents);
    }

    private TableCell buildTableCell(List<ParagraphContents> numberedList) {
        return TableUtils.buildTableCell(numberedList);
    }
}

