/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.chapter.point.builder;

import com.suncode.plugin.pwe.documentation.ParagraphContents;
import com.suncode.plugin.pwe.documentation.Table;
import com.suncode.plugin.pwe.documentation.TableCell;
import com.suncode.plugin.pwe.documentation.TableHeader;
import com.suncode.plugin.pwe.documentation.TableHeaders;
import com.suncode.plugin.pwe.documentation.TableRecord;
import com.suncode.plugin.pwe.documentation.TableRecords;
import com.suncode.plugin.pwe.documentation.object.AutoUpdate;
import com.suncode.plugin.pwe.documentation.object.FormVariable;
import com.suncode.plugin.pwe.documentation.paragraph.builder.SpecificationDescriptionParagraphContentsBuilder;
import com.suncode.plugin.pwe.documentation.specification.AutoUpdateSpecification;
import com.suncode.plugin.pwe.documentation.specification.FormVariableSpecification;
import com.suncode.plugin.pwe.documentation.util.BookmarkNameUtils;
import com.suncode.plugin.pwe.documentation.util.ParagraphContentsUtils;
import com.suncode.plugin.pwe.documentation.util.ParagraphIndentsUtils;
import com.suncode.plugin.pwe.documentation.util.TableUtils;
import com.suncode.plugin.pwe.documentation.util.VariableUtils;
import com.suncode.plugin.pwe.service.translator.TranslatorService;
import com.suncode.plugin.pwe.util.translation.TranslationInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FormVariableAutoUpdatesPointBuilder {
    private static final String EVENT_TYPE_TABLE_COLUMN_ID = "eventtype";
    private static final String EVENT_TYPE_TABLE_HEADER = "pwe.documentation.table.header.eventtype";
    private static final String DESCRIPTION_TABLE_COLUMN_ID = "description";
    private static final String DESCRIPTION_TABLE_HEADER = "pwe.documentation.table.header.description";
    private static final String DATA_SOURCES_TABLE_COLUMN_ID = "datasources";
    private static final String DATA_SOURCES_TABLE_HEADER = "pwe.documentation.table.header.datasources";
    private static final String DESTINATION_VARIABLES_TABLE_COLUMN_ID = "destinationvariables";
    private static final String DESTINATION_VARIABLES_TABLE_HEADER = "pwe.documentation.table.header.destinationvariables";
    @Autowired
    private TranslatorService translatorService;
    @Autowired
    private SpecificationDescriptionParagraphContentsBuilder specificationDescriptionParagraphContentsBuilder;

    public Table build(WorkflowProcess process, TranslationInfo translationInfo, FormVariable formVariable, FormVariableSpecification formVariableSpecification) {
        TableHeaders headers = this.buildTableHeaders();
        TableRecords records = new TableRecords();
        for (AutoUpdate autoUpdate : formVariable.getAutoUpdates()) {
            records.add(this.buildTableRecord(process, translationInfo, formVariableSpecification, autoUpdate));
        }
        Table table = new Table();
        table.setHeaders(headers);
        table.setRecords(records);
        return table;
    }

    private TableHeaders buildTableHeaders() {
        TableHeaders headers = new TableHeaders();
        headers.add(this.buildTableEventTypeHeader());
        headers.add(this.buildTableDescriptionHeader());
        headers.add(this.buildTableDataSourcesHeader());
        headers.add(this.buildTableDestinationVariablesHeader());
        return headers;
    }

    private TableHeader buildTableEventTypeHeader() {
        return TableUtils.buildTableHeader(EVENT_TYPE_TABLE_COLUMN_ID, this.translatorService.translateMessage(EVENT_TYPE_TABLE_HEADER));
    }

    private TableHeader buildTableDescriptionHeader() {
        return TableUtils.buildTableHeader(DESCRIPTION_TABLE_COLUMN_ID, this.translatorService.translateMessage(DESCRIPTION_TABLE_HEADER));
    }

    private TableHeader buildTableDataSourcesHeader() {
        return TableUtils.buildTableHeader(DATA_SOURCES_TABLE_COLUMN_ID, this.translatorService.translateMessage(DATA_SOURCES_TABLE_HEADER));
    }

    private TableHeader buildTableDestinationVariablesHeader() {
        return TableUtils.buildTableHeader(DESTINATION_VARIABLES_TABLE_COLUMN_ID, this.translatorService.translateMessage(DESTINATION_VARIABLES_TABLE_HEADER));
    }

    private TableRecord buildTableRecord(WorkflowProcess process, TranslationInfo translationInfo, FormVariableSpecification formVariableSpecification, AutoUpdate autoUpdate) {
        AutoUpdateSpecification autoUpdateSpecification = this.getAutoUpdateSpecification(formVariableSpecification, autoUpdate);
        TableRecord record = new TableRecord();
        record.addCell(EVENT_TYPE_TABLE_COLUMN_ID, this.buildTableRecordEventTypeCell(autoUpdate));
        record.addCell(DESCRIPTION_TABLE_COLUMN_ID, this.buildTableRecordDescriptionCell(process, translationInfo, autoUpdateSpecification));
        record.addCell(DATA_SOURCES_TABLE_COLUMN_ID, this.buildTableRecordDataSourcesCell(process, autoUpdate));
        record.addCell(DESTINATION_VARIABLES_TABLE_COLUMN_ID, this.buildTableRecordDestinationVariablesCell(process, autoUpdate));
        return record;
    }

    private AutoUpdateSpecification getAutoUpdateSpecification(FormVariableSpecification formVariableSpecification, AutoUpdate autoUpdate) {
        String autoUpdateId = autoUpdate.getId();
        if (MapUtils.isNotEmpty(formVariableSpecification.getAutoUpdateSpecifications()) && formVariableSpecification.getAutoUpdateSpecifications().containsKey(autoUpdateId)) {
            return formVariableSpecification.getAutoUpdateSpecifications().get(autoUpdateId);
        }
        return new AutoUpdateSpecification();
    }

    private TableCell buildTableRecordEventTypeCell(AutoUpdate autoUpdate) {
        String text = this.translatorService.translateDocumentationMessageForText(autoUpdate.getEventType());
        return this.buildTableCell(text);
    }

    private TableCell buildTableCell(String text) {
        return TableUtils.buildTableCell(text);
    }

    private TableCell buildTableRecordDescriptionCell(WorkflowProcess process, TranslationInfo translationInfo, AutoUpdateSpecification autoUpdateSpecification) {
        ParagraphContents contents = this.buildSpecificationDescriptionParagraphContents(process, translationInfo, autoUpdateSpecification.getDescription());
        contents.setIndents(ParagraphIndentsUtils.buildLeft(0));
        return this.buildTableCell(contents);
    }

    private TableCell buildTableCell(ParagraphContents contents) {
        return TableUtils.buildTableCell(contents);
    }

    private TableCell buildTableRecordDataSourcesCell(WorkflowProcess process, AutoUpdate autoUpdate) {
        List<ParagraphContents> numberedList = this.buildNumberedList(process, autoUpdate.getDataSources());
        return this.buildTableCell(numberedList);
    }

    private List<ParagraphContents> buildNumberedList(WorkflowProcess process, List<String> variableIds) {
        ArrayList<ParagraphContents> numberedList = new ArrayList<ParagraphContents>();
        if (CollectionUtils.isNotEmpty(variableIds)) {
            for (String variableId : variableIds) {
                numberedList.add(this.buildContents(process, variableId));
            }
        }
        return numberedList;
    }

    private ParagraphContents buildContents(WorkflowProcess process, String variableId) {
        String text = VariableUtils.getName(process, variableId);
        String bookmarkName = this.buildBookmarkName(variableId);
        return ParagraphContentsUtils.build(text, bookmarkName);
    }

    private String buildBookmarkName(String variableId) {
        return BookmarkNameUtils.getNameForProcessVariable(variableId);
    }

    private TableCell buildTableCell(List<ParagraphContents> numberedList) {
        return TableUtils.buildTableCell(numberedList);
    }

    private TableCell buildTableRecordDestinationVariablesCell(WorkflowProcess process, AutoUpdate autoUpdate) {
        List<ParagraphContents> numberedList = this.buildNumberedList(process, autoUpdate.getDestinationVariables());
        return this.buildTableCell(numberedList);
    }

    private ParagraphContents buildSpecificationDescriptionParagraphContents(WorkflowProcess process, TranslationInfo translationInfo, String description) {
        return this.specificationDescriptionParagraphContentsBuilder.build(process, translationInfo, description);
    }
}

