/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.chapter.point.builder;

import com.suncode.plugin.pwe.documentation.Documentation;
import com.suncode.plugin.pwe.documentation.ParagraphContents;
import com.suncode.plugin.pwe.documentation.chapter.point.builder.ActivityPointBuilder;
import com.suncode.plugin.pwe.documentation.chapter.point.builder.IntegrationComponentsPointBuilder;
import com.suncode.plugin.pwe.documentation.object.ActivityForm;
import com.suncode.plugin.pwe.documentation.object.FormAction;
import com.suncode.plugin.pwe.documentation.object.GeneratePdfButton;
import com.suncode.plugin.pwe.documentation.specification.ActivitySpecification;
import com.suncode.plugin.pwe.documentation.subchapter.builder.SubchapterBuilder;
import com.suncode.plugin.pwe.documentation.util.BookmarkNameUtils;
import com.suncode.plugin.pwe.documentation.util.LeftIndents;
import com.suncode.plugin.pwe.documentation.util.ParagraphContentsUtils;
import com.suncode.plugin.pwe.documentation.util.ParagraphIndentsUtils;
import com.suncode.plugin.pwe.service.translator.TranslatorService;
import com.suncode.plugin.pwe.util.translation.TranslationInfo;
import org.apache.commons.collections.CollectionUtils;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="activityGeneratePdfButtonsPointBuilder")
public class ActivityGeneratePdfButtonsPointBuilderImpl
implements ActivityPointBuilder {
    private static final String CHECK_FORM_POINT_TITLE = "pwe.documentation.point.title.checkform";
    private static final String YES = "pwe.documentation.text.yes";
    private static final String NO = "pwe.documentation.text.no";
    private static final String DOCUMENT_CLASS_FOR_PDF_POINT_TITLE = "pwe.documentation.point.title.documentclassforpdf";
    private static final String FORM_ACTIONS_POINT_TITLE = "pwe.documentation.point.title.formactions";
    @Autowired
    private TranslatorService translatorService;
    @Autowired
    private IntegrationComponentsPointBuilder<FormAction> formActionsIntegrationComponentsPointBuilder;
    @Autowired
    private SubchapterBuilder subchapterBuilder;

    @Override
    public void build(Documentation documentation, WorkflowProcess process, TranslationInfo translationInfo, Activity activity, ActivitySpecification activitySpecification, ActivityForm activityForm) {
        for (GeneratePdfButton generatePdfButton : activityForm.getGeneratePdfButtons()) {
            this.buildPoints(documentation, process, translationInfo, activity, generatePdfButton);
        }
    }

    private void buildPoints(Documentation documentation, WorkflowProcess process, TranslationInfo translationInfo, Activity activity, GeneratePdfButton generatePdfButton) {
        this.buildTitlePoint(documentation, process, translationInfo, activity, generatePdfButton);
        this.buildCheckFormPoint(documentation, generatePdfButton);
        this.buildDocumentClassForPdfPoint(documentation, generatePdfButton);
        if (CollectionUtils.isNotEmpty(generatePdfButton.getFormActions())) {
            this.buildFormActionsPoint(documentation, process, generatePdfButton);
        }
        documentation.addNewLine();
    }

    private void buildTitlePoint(Documentation documentation, WorkflowProcess process, TranslationInfo translationInfo, Activity activity, GeneratePdfButton generatePdfButton) {
        String buttonName = this.translatorService.translateGeneratePdfButtonButtonName(translationInfo, process, activity, generatePdfButton);
        this.buildPoint(documentation, buttonName);
    }

    private void buildCheckFormPoint(Documentation documentation, GeneratePdfButton generatePdfButton) {
        String text = this.buildCheckForm(generatePdfButton);
        this.buildPoint(documentation, CHECK_FORM_POINT_TITLE, text);
    }

    private String buildCheckForm(GeneratePdfButton generatePdfButton) {
        if (generatePdfButton.isCheckForm()) {
            return this.translatorService.translateMessage(YES);
        }
        return this.translatorService.translateMessage(NO);
    }

    private void buildDocumentClassForPdfPoint(Documentation documentation, GeneratePdfButton generatePdfButton) {
        ParagraphContents contents = this.buildDocumentClassForPdfPointContents(generatePdfButton);
        contents.setIndents(ParagraphIndentsUtils.buildLeft(3));
        this.buildPoint(documentation, DOCUMENT_CLASS_FOR_PDF_POINT_TITLE, contents);
    }

    private ParagraphContents buildDocumentClassForPdfPointContents(GeneratePdfButton generatePdfButton) {
        String documentClassName = generatePdfButton.getDocumentClassName();
        String bookmarkName = BookmarkNameUtils.getNameForDocumentClass(documentClassName);
        return this.buildParagraphContents(documentClassName, bookmarkName);
    }

    private ParagraphContents buildParagraphContents(String text, String bookmarkName) {
        return ParagraphContentsUtils.build(text, bookmarkName);
    }

    private void buildFormActionsPoint(Documentation documentation, WorkflowProcess process, GeneratePdfButton generatePdfButton) {
        this.formActionsIntegrationComponentsPointBuilder.build(documentation, process, generatePdfButton.getFormActions(), FORM_ACTIONS_POINT_TITLE, 3);
    }

    private void buildPoint(Documentation documentation, String title) {
        this.buildPoint(documentation, title, 2);
    }

    private void buildPoint(Documentation documentation, String title, int leftIndents) {
        this.subchapterBuilder.build(documentation, title, leftIndents);
    }

    private void buildPoint(Documentation documentation, String titleKey, String text) {
        this.subchapterBuilder.build(documentation, titleKey, text, new LeftIndents(3));
    }

    private void buildPoint(Documentation documentation, String titleKey, ParagraphContents contents) {
        this.subchapterBuilder.build(documentation, titleKey, 3, contents);
    }
}

