/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.chapter.builder;

import com.suncode.plugin.pwe.documentation.Documentation;
import com.suncode.plugin.pwe.documentation.TableCell;
import com.suncode.plugin.pwe.documentation.TableHeader;
import com.suncode.plugin.pwe.documentation.TableHeaders;
import com.suncode.plugin.pwe.documentation.TableRecord;
import com.suncode.plugin.pwe.documentation.TableRecords;
import com.suncode.plugin.pwe.documentation.chapter.builder.ChapterBuilder;
import com.suncode.plugin.pwe.documentation.specification.ParameterSpecification;
import com.suncode.plugin.pwe.documentation.specification.ProcessSpecification;
import com.suncode.plugin.pwe.documentation.specification.ScheduledTaskSpecification;
import com.suncode.plugin.pwe.documentation.subchapter.builder.SubchapterBuilder;
import com.suncode.plugin.pwe.documentation.util.Counter;
import com.suncode.plugin.pwe.documentation.util.TableUtils;
import com.suncode.plugin.pwe.service.translator.TranslatorService;
import com.suncode.plugin.pwe.util.translation.TranslationInfo;
import com.suncode.plugin.pwe.web.support.dto.documentationconfig.DocumentationConfigDto;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="scheduledTasksChapterBuilder")
public class ScheduledTasksChapterBuilderImpl
implements ChapterBuilder {
    private static final String CHAPTER_TITLE = "pwe.documentation.chapter.title.scheduledtasks";
    private static final String TASK_DESCRIPTION_POINT_TITLE = "pwe.documentation.point.title.taskdescription";
    private static final String CLASS_NAME_POINT_TITLE = "pwe.documentation.point.title.classname";
    private static final String METHOD_NAME_POINT_TITLE = "pwe.documentation.point.title.methodname";
    private static final String INPUT_PARAMETERS_POINT_TITLE = "pwe.documentation.point.title.inputparameters";
    private static final String PARAMETER_NAME_TABLE_COLUMN_ID = "name";
    private static final String PARAMETER_NAME_TABLE_HEADER = "pwe.documentation.table.header.name";
    private static final String PARAMETER_DESCRIPTION_TABLE_COLUMN_ID = "description";
    private static final String PARAMETER_DESCRIPTION_TABLE_HEADER = "pwe.documentation.table.header.description";
    private static final String NO_INPUT_PARAMETERS = "pwe.documentation.text.noinputparameters";
    private static final String EXECUTION_FREQUENCY_POINT_TITLE = "pwe.documentation.point.title.executionfrequency";
    private static final String ALGORITHM_DESCRIPTION_POINT_TITLE = "pwe.documentation.point.title.algorithmdescription";
    @Autowired
    private TranslatorService translatorService;
    @Autowired
    private SubchapterBuilder subchapterBuilder;

    @Override
    public void build(Documentation documentation, WorkflowProcess process, ProcessSpecification processSpecification, TranslationInfo translationInfo, DocumentationConfigDto documentationConfig) {
        documentation.addChapter(this.translatorService.translateDocumentationChapterTitle(CHAPTER_TITLE));
        this.buildSubchapters(documentation, processSpecification);
    }

    private void buildSubchapters(Documentation documentation, ProcessSpecification processSpecification) {
        List<ScheduledTaskSpecification> scheduledTaskSpecifications = processSpecification.getScheduledTaskSpecifications();
        if (CollectionUtils.isNotEmpty(scheduledTaskSpecifications)) {
            Counter subchapterNo = new Counter(1);
            for (ScheduledTaskSpecification scheduledTaskSpecification : scheduledTaskSpecifications) {
                this.buildSubchapter(documentation, scheduledTaskSpecification, subchapterNo.getCountAndIncrement());
            }
        }
    }

    private void buildSubchapter(Documentation documentation, ScheduledTaskSpecification scheduledTaskSpecification, int subchapterNo) {
        String title = this.buildSubchapterTitle(scheduledTaskSpecification, subchapterNo);
        documentation.addSubchapter(title);
        this.buildTaskDescriptionPoint(documentation, scheduledTaskSpecification);
        this.buildClassNamePoint(documentation, scheduledTaskSpecification);
        this.buildMethodNamePoint(documentation, scheduledTaskSpecification);
        this.buildInputParametersPoint(documentation, scheduledTaskSpecification);
        this.buildExecutionFrequencyPoint(documentation, scheduledTaskSpecification);
        this.buildAlgorithmDescriptionPoint(documentation, scheduledTaskSpecification);
        documentation.addNewLine();
    }

    private String buildSubchapterTitle(ScheduledTaskSpecification scheduledTaskSpecification, int subchapterNo) {
        StringBuilder title = new StringBuilder();
        title.append(subchapterNo);
        title.append(". ");
        title.append(scheduledTaskSpecification.getName());
        return title.toString();
    }

    private void buildTaskDescriptionPoint(Documentation documentation, ScheduledTaskSpecification scheduledTaskSpecification) {
        this.buildPoint(documentation, TASK_DESCRIPTION_POINT_TITLE, scheduledTaskSpecification.getDescription());
    }

    private void buildClassNamePoint(Documentation documentation, ScheduledTaskSpecification scheduledTaskSpecification) {
        this.buildPoint(documentation, CLASS_NAME_POINT_TITLE, scheduledTaskSpecification.getClassName());
    }

    private void buildMethodNamePoint(Documentation documentation, ScheduledTaskSpecification scheduledTaskSpecification) {
        this.buildPoint(documentation, METHOD_NAME_POINT_TITLE, scheduledTaskSpecification.getMethodName());
    }

    private void buildInputParametersPoint(Documentation documentation, ScheduledTaskSpecification scheduledTaskSpecification) {
        String noInputParametersText = this.buildNoInputParametersText();
        this.buildParametersPoint(documentation, scheduledTaskSpecification.getInputParameters(), INPUT_PARAMETERS_POINT_TITLE, noInputParametersText);
    }

    private void buildParametersPoint(Documentation documentation, List<ParameterSpecification> parameters, String titleKey, String noParametersKey) {
        if (CollectionUtils.isNotEmpty(parameters)) {
            TableHeaders headers = this.buildParametersTableHeaders();
            TableRecords records = new TableRecords();
            for (ParameterSpecification parameterSpecification : parameters) {
                records.add(this.buildParametersTableRecord(parameterSpecification));
            }
            this.buildPoint(documentation, titleKey, headers, records);
        } else {
            this.buildPoint(documentation, titleKey, noParametersKey);
        }
    }

    private TableHeaders buildParametersTableHeaders() {
        TableHeaders headers = new TableHeaders();
        headers.add(this.buildParametersTableNameHeader());
        headers.add(this.buildParametersTableDescriptionHeader());
        return headers;
    }

    private TableHeader buildParametersTableNameHeader() {
        return TableUtils.buildTableHeader(PARAMETER_NAME_TABLE_COLUMN_ID, this.translatorService.translateMessage(PARAMETER_NAME_TABLE_HEADER));
    }

    private TableHeader buildParametersTableDescriptionHeader() {
        return TableUtils.buildTableHeader(PARAMETER_DESCRIPTION_TABLE_COLUMN_ID, this.translatorService.translateMessage(PARAMETER_DESCRIPTION_TABLE_HEADER));
    }

    private TableRecord buildParametersTableRecord(ParameterSpecification parameterSpecification) {
        TableRecord record = new TableRecord();
        record.addCell(PARAMETER_NAME_TABLE_COLUMN_ID, this.buildParametersTableNameCell(parameterSpecification));
        record.addCell(PARAMETER_DESCRIPTION_TABLE_COLUMN_ID, this.buildParametersTableDescriptionCell(parameterSpecification));
        return record;
    }

    private TableCell buildParametersTableNameCell(ParameterSpecification parameterSpecification) {
        return TableUtils.buildTableCell(parameterSpecification.getName());
    }

    private TableCell buildParametersTableDescriptionCell(ParameterSpecification parameterSpecification) {
        return TableUtils.buildTableCell(parameterSpecification.getDescription());
    }

    private String buildNoInputParametersText() {
        return this.translatorService.translateMessage(NO_INPUT_PARAMETERS);
    }

    private void buildExecutionFrequencyPoint(Documentation documentation, ScheduledTaskSpecification scheduledTaskSpecification) {
        StringBuilder text = new StringBuilder();
        text.append(this.buildExecutionFrequencyUnit(scheduledTaskSpecification));
        text.append(": ");
        text.append(scheduledTaskSpecification.getExecutionFrequencyValue());
        this.buildPoint(documentation, EXECUTION_FREQUENCY_POINT_TITLE, text.toString());
    }

    private String buildExecutionFrequencyUnit(ScheduledTaskSpecification scheduledTaskSpecification) {
        return StringUtils.capitalize((String)this.translatorService.translateDocumentationMessageForText(scheduledTaskSpecification.getExecutionFrequencyUnit()));
    }

    private void buildAlgorithmDescriptionPoint(Documentation documentation, ScheduledTaskSpecification scheduledTaskSpecification) {
        this.buildPoint(documentation, ALGORITHM_DESCRIPTION_POINT_TITLE, scheduledTaskSpecification.getAlgorithmDescription());
    }

    private void buildPoint(Documentation documentation, String titleKey, String text) {
        this.subchapterBuilder.build(documentation, titleKey, text);
    }

    private void buildPoint(Documentation documentation, String titleKey, TableHeaders headers, TableRecords records) {
        this.subchapterBuilder.build(documentation, titleKey, headers, records);
    }
}

