/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.divante;

import com.suncode.pwfl.util.style.IconUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

@Component
public class DivanteTransformer {
    private static final String EXTENDED_ATTRIBUTE_NAME_ATTR_NAME = "Name";
    private static final String EXTENDED_ATTRIBUTE_VALUE_ATTR_NAME = "Value";
    private static final String TABLES_ICON_REGEX = "(@PWE_QOUTE@icon@PWE_QOUTE@:@PWE_QOUTE@)(|.+?)@PWE_QOUTE@";
    private static final String TABLES_ICON_PREFIX = "@PWE_QOUTE@icon@PWE_QOUTE@:@PWE_QOUTE@";
    private static final String TABLES_ICON_POSTFIX = "@PWE_QOUTE@";
    private static final Pattern TABLES_ICON_PATTERN = Pattern.compile("(@PWE_QOUTE@icon@PWE_QOUTE@:@PWE_QOUTE@)(|.+?)@PWE_QOUTE@");
    private static final String EXTENDED_ATTRIBUTE_LINES_SEPARATOR = "\n";
    private static final String DT_BUTTON_ICON_LINE_PREFIX = "icon=";
    private static final String ICON_VALUE_ATTR_NAME = "value";

    public JSONObject transformXpdl(JSONObject xpdl) {
        Optional.ofNullable(xpdl.optJSONArray("Package")).map(array -> DivanteTransformer.findArray(array, "WorkflowProcesses")).filter(Objects::nonNull).map(array -> DivanteTransformer.findAllArrays(array, "WorkflowProcess")).orElse(Collections.emptyList()).forEach(DivanteTransformer::transformProcess);
        return xpdl;
    }

    public JSONObject transformFormTemplate(JSONObject formTemplate) {
        Optional.ofNullable(formTemplate.optJSONArray("FormTemplate")).map(array -> DivanteTransformer.findArray(array, "Rows")).filter(Objects::nonNull).map(array -> DivanteTransformer.findAllArrays(array, "Row")).orElse(Collections.emptyList()).forEach(DivanteTransformer::transformRow);
        return formTemplate;
    }

    private static JSONArray findArray(JSONArray array, String expected) {
        for (int i = 0; i < array.length(); ++i) {
            JSONObject object = array.optJSONObject(i);
            Object innerObject = object.opt(expected);
            if (!(innerObject instanceof JSONArray)) continue;
            return (JSONArray)innerObject;
        }
        return null;
    }

    private static List<JSONArray> findAllArrays(JSONArray array, String expected) {
        ArrayList<JSONArray> innerArrays = new ArrayList<JSONArray>();
        for (int i = 0; i < array.length(); ++i) {
            JSONObject object = array.optJSONObject(i);
            Object innerObject = object.opt(expected);
            if (!(innerObject instanceof JSONArray)) continue;
            innerArrays.add((JSONArray)innerObject);
        }
        return innerArrays;
    }

    private static void transformProcess(JSONArray process) {
        List<JSONArray> extendedAttributes = DivanteTransformer.getExtendedAttributes(process);
        extendedAttributes.stream().filter(a -> DivanteTransformer.hasName(a, "TABLES")).forEach(DivanteTransformer::analyzeTablesIcons);
        ((List)Optional.ofNullable(DivanteTransformer.findArray(process, "Activities")).filter(Objects::nonNull).map(a -> DivanteTransformer.findAllArrays(a, "Activity")).orElse(new ArrayList())).forEach(DivanteTransformer::transformActivity);
    }

    private static List<JSONArray> getExtendedAttributes(JSONArray array) {
        return Optional.ofNullable(DivanteTransformer.findArray(array, "ExtendedAttributes")).filter(Objects::nonNull).map(a -> DivanteTransformer.findAllArrays(a, "ExtendedAttribute")).orElse(Collections.emptyList());
    }

    private static boolean hasName(JSONArray array, String expected) {
        for (int i = 0; i < array.length(); ++i) {
            JSONObject object = array.optJSONObject(i);
            String name = object.optString(EXTENDED_ATTRIBUTE_NAME_ATTR_NAME);
            if (!StringUtils.equals((CharSequence)name, (CharSequence)expected)) continue;
            return true;
        }
        return false;
    }

    private static void analyzeTablesIcons(JSONArray extendedAttribute) {
        JSONObject value = extendedAttribute.optJSONObject(1);
        DivanteTransformer.analyzeTablesIcons(value);
    }

    private static void analyzeTablesIcons(JSONObject value) {
        try {
            String definition = value.optString(EXTENDED_ATTRIBUTE_VALUE_ATTR_NAME);
            Matcher matcher = TABLES_ICON_PATTERN.matcher(definition);
            while (matcher.find()) {
                String iconPart = matcher.group();
                String icon = StringUtils.substringBetween((String)iconPart, (String)TABLES_ICON_PREFIX, (String)TABLES_ICON_POSTFIX);
                if (!DivanteTransformer.shouldTransformIcon(icon)) continue;
                String transformedIconPart = TABLES_ICON_PREFIX + DivanteTransformer.toTransformedIcon(icon) + TABLES_ICON_POSTFIX;
                definition = StringUtils.replace((String)definition, (String)iconPart, (String)transformedIconPart);
            }
            value.put(EXTENDED_ATTRIBUTE_VALUE_ATTR_NAME, (Object)definition);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception.getCause());
        }
    }

    private static void transformActivity(JSONArray activity) {
        List<JSONArray> extendedAttributes = DivanteTransformer.getExtendedAttributes(activity);
        extendedAttributes.stream().filter(a -> DivanteTransformer.hasName(a, "DT_BUTTON")).forEach(DivanteTransformer::analyzeDtButtonIcon);
    }

    private static void analyzeDtButtonIcon(JSONArray extendedAttribute) {
        JSONObject value = extendedAttribute.optJSONObject(1);
        DivanteTransformer.analyzeDtButtonIcon(value);
    }

    private static void analyzeDtButtonIcon(JSONObject value) {
        try {
            int index;
            String icon;
            String definition = value.optString(EXTENDED_ATTRIBUTE_VALUE_ATTR_NAME);
            List<String> lines = Arrays.asList(StringUtils.split((String)definition, (String)EXTENDED_ATTRIBUTE_LINES_SEPARATOR));
            OptionalInt indexOpt = IntStream.range(0, lines.size()).filter(i -> StringUtils.startsWith((CharSequence)((CharSequence)lines.get(i)), (CharSequence)DT_BUTTON_ICON_LINE_PREFIX)).findFirst();
            if (indexOpt.isPresent() && DivanteTransformer.shouldTransformIcon(icon = StringUtils.substringAfter((String)lines.get(index = indexOpt.getAsInt()), (String)DT_BUTTON_ICON_LINE_PREFIX))) {
                lines.set(index, DT_BUTTON_ICON_LINE_PREFIX + DivanteTransformer.toTransformedIcon(icon));
                value.put(EXTENDED_ATTRIBUTE_VALUE_ATTR_NAME, (Object)StringUtils.join(lines, (String)EXTENDED_ATTRIBUTE_LINES_SEPARATOR));
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception.getCause());
        }
    }

    private static void transformRow(JSONArray row) {
        DivanteTransformer.findAllArrays(row, "Item").forEach(DivanteTransformer::transformItem);
    }

    private static void transformItem(JSONArray item) {
        Optional.ofNullable(DivanteTransformer.findArray(item, "Styles")).map(array -> DivanteTransformer.findArray(array, "Icon")).filter(Objects::nonNull).ifPresent(DivanteTransformer::analyzeIconValue);
    }

    private static void analyzeIconValue(JSONArray icon) {
        try {
            JSONObject value = icon.optJSONObject(0);
            String iconValue = value.optString(ICON_VALUE_ATTR_NAME);
            if (DivanteTransformer.shouldTransformIcon(iconValue)) {
                value.put(ICON_VALUE_ATTR_NAME, (Object)DivanteTransformer.toTransformedIcon(iconValue));
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception.getCause());
        }
    }

    private static boolean shouldTransformIcon(String icon) {
        return !StringUtils.startsWith((CharSequence)icon, (CharSequence)"DIVANTE_ICON_");
    }

    private static String toTransformedIcon(String icon) {
        return "DIVANTE_ICON_" + IconUtils.resolveIcon((String)icon);
    }
}

