Ext.ux.suncode.LabelDefWindow = function( config ) {
    var windowWidth = Ext.getBody().getViewSize().width * 0.5;
    var label = config.label;
    var winTitle = label ? getTranslation( 'Definicja etykiety' ) : getTranslation( 'Kreator etykiety' );
    
    config = Ext.apply( {
        AV: Ext.getCmp( 'main_panel' ).getAdvancedView()
    }, config );

    config = Ext.apply( {
        modal: true,
        width: windowWidth,
        autoScroll: true,
        title: winTitle,
        items: [ new Ext.ux.suncode.ProcessLabelDefPanel( config ) ],
        closable: true,
        tbar: new Ext.Toolbar( {
            buttons: [ {
                cls: 'x-btn-icon',
                ref: 'saveBtn',
                icon: getPluginImgPath( 'save' ),
                tooltip: getTranslation( 'Zapisz' ),
                handler: this.saveForm,
                scope: this,
                ref: 'saveBtn'
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'close' ),
                tooltip: getTranslation( 'Zamknij' ),
                handler: this.closeWindow,
                scope: this,
                ref: 'closeBtn'
            } ]
        } )
    }, config );

    Ext.ux.suncode.LabelDefWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.LabelDefWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.LabelDefWindow.superclass.initComponent.call( this );
    },
    saveForm: function() {
        this.labelDefPanel.saveForm();
    },
    closeWindow: function() {
        this.close();
    }
} );

Ext.ux.suncode.ProcessLabelDefPanel = function( config ) {
	  var packageNode = Ext.getCmp( 'package_panel' ).getRootNode();
	  var packageId = packageNode.attributes.packageId;
    var processNode = config.processNode;
    var processDefId = processNode.attributes.processDefId;
    var label = config.label;
    var mainPanel = Ext.getCmp( 'main_panel' );
    var formActionsCategories = mainPanel.getFormActionsIntegrationComponentCategories();

    config = Ext.apply( {
        labelWidth: 200,
        autoHeight: true,
        border: false,
        frame: false,
        bodyCssClass: 'x-Module-container-padding',
        ref: 'labelDefPanel',
        layoutConfig: {
            trackLabels: true
        },
        items: [ new Ext.ux.suncode.IdField( {
            anchor: '100%',
            fieldLabel: getTranslation( 'Identyfikator' ),
            ref: 'idItem',
            allowBlank: true,
            value: label ? label.id : '',
            hidden: !config.AV,
            idChanged: !Ext.isEmpty( label )
        } ), new Ext.ux.suncode.I18NTranslatedField( {
        	fieldLabel: getTranslation( 'Nazwa' ),
        	ref: 'nameItem',
        	field: {
                xtype: 'textfield',
                value: label ? label.name : '',
                listeners: {
                	scope: this,
                    blur: function( field ) {
                    	var newName = field.getValue();
                    	var oldLabelId = this.idItem.getValue();
                    	
                    	if ( !label ) {
                    		var labelId = generateId( newName, null );
                    		this.idItem.setValue( labelId );
                    	}
                    }
                }
            },
            getIdFieldFunction: function() {
            	return this.idItem;
            },
            getIdFieldScope: this,
            emptyIdMessage: getTranslation( 'Podaj nazwę etykiety.' ),
            windowTitle: getTranslation( 'Tłumaczenia nazwy etykiety' ),
            keyPrefix: 'PACK(' + packageId + ')_PROC(' + processDefId + ')_LABEL(',
            keyPostfix: ')',
            saveToCache: Ext.isEmpty( label ),
            initialId: label ? label.id : null
        } ), new Ext.ux.suncode.IntegrationComponentTable( {
          ref: 'formActionsTable',
          title: getTranslation( 'Akcje formularza' ),
          height: 250,
          frame: false,
          eventMode: false,
          components: label ? label.formActions : new Array(),
          allCategories: formActionsCategories,
          filteredCategories: Ext.ux.suncode.IntegrationComponentService.filterCategoriesByDestination(
              formActionsCategories, Ext.ux.suncode.IntegrationComponentService.LABEL_DESTINATION, false ),
          processNode: processNode,
          enableCopyPasteMenu: true,
          conditionalExecutionEnabled: true,
          inactiveEnabled: true,
          parametersWindowTitlePrefix: getTranslation( 'Parametry akcji formularza' ),
          globalDefinition: true,
          systemFunctionsAccessibility: Ext.ux.suncode.IntegrationComponentService.BROWSER_ACCESSIBILITY,
          getBindToFunction: function( cmp ) {
            var destination = Ext.ux.suncode.IntegrationComponentService.getDestination(
                cmp, Ext.ux.suncode.IntegrationComponentService.LABEL_DESTINATION, false );

            return !Ext.isEmpty( destination ) ? {
              id: destination.bindTo,
              value: this.idItem.getValue()
            } : null;
          },
          getBindToScope: this,
          getComponentRegistrationFunction: function( id ) {
            return Ext.ux.suncode.IntegrationComponentService.getFormActionRegistration( id );
          },
          getComponentRegistrationScope: this,
          copyComponentsFunction: function( cmps ) {
            Ext.ux.suncode.Clipboard.setIntegrationComponentFormActions( cmps );
          },
          copyComponentsScope: this,
          handleCopiedComponentsFunction: function( func, scope ) {
            Ext.ux.suncode.Clipboard.getIntegrationComponentFormActions( function( formActions ) {
              if ( Ext.isFunction( func ) ) {
                var cmps = new Array();

                if ( !Ext.isEmpty( formActions ) ) {
                  var service = Ext.ux.suncode.IntegrationComponentService;

                  Ext.each( formActions, function( cmp, index, allComponents ) {
                    var componentDef = service.getIntegrationComponent( formActionsCategories, cmp.id );

                    if ( !Ext.isEmpty( componentDef ) && service.hasDestination( componentDef, service.LABEL_DESTINATION ) ) {
                      cmps.push( cmp );
                    }
                  } );
                }

                scope = !Ext.isEmpty( scope ) ? scope : window;
                func.apply( scope, [ cmps ] );
              }
            }, this );
          },
          handleCopiedComponentsScope: this,
          pasteSpecialMessageType: Ext.ux.suncode.Clipboard.integrationComponentFormActionsMessageType,
          destinationType: Ext.ux.suncode.IntegrationComponentService.LABEL_DESTINATION
        } ) ]
    }, config );

    Ext.ux.suncode.ProcessLabelDefPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ProcessLabelDefPanel, Ext.FormPanel, {
    initComponent: function() {
        Ext.ux.suncode.ProcessLabelDefPanel.superclass.initComponent.call( this );
    },
    saveForm: function() {
    	  var id = this.idItem.getValue();
        var name = this.nameItem.getValue();
        var saveToObj = this.initialConfig.saveTo;
        var labelRecord = this.initialConfig.labelRecord;
        var setToObj = this.initialConfig.setToObj;
        var label = this.initialConfig.label;
        var processNode = this.initialConfig.processNode;
        var lObj = new Object();
        
        if ( Ext.isEmpty( id ) || Ext.isEmpty( name ) ) {
            showWarn( getTranslation( 'Podaj nazwę etykiety.' ) );
            return;
        }
        
        if ( !label && processNode.findLabel( id ) ) {
            showWarn( getTranslation( 'Etykieta już istnieje.' ) );
            return;
        } else if ( processNode.findVariable( id ) ) {
          showWarn( getTranslation( 'Identyfikator etykiety pokrywa się z identyfikatorem zmiennej procesu.') );
          return;
        } else if ( label && label.id != id && processNode.findLabel( id ) ) {
            showWarn( getTranslation( 'Etykieta już istnieje.' ) );
            return;
        }
        
        if ( processNode.findVariable( id ) ) {
            showWarn( getTranslation( 'Zmienna procesu o podanym identyfikatorze już istnieje.' ) );
            return;
        }

        if ( saveToObj && labelRecord ) {
            if ( label ) {
            	labelRecord.set( 'id', id );
            	labelRecord.set( 'name', name );
            	labelRecord.commit();
            } else {
                var store = saveToObj.getStore();
                store.add( new labelRecord( {
                    id: id,
                    name: name
                } ) );
                store.commitChanges();
                
                if ( Ext.isFunction( saveToObj.updateTitle ) ) {
                	saveToObj.updateTitle();
                }
            }
        }

        lObj = Ext.apply( {
            id: id,
            name: name,
            formActions: this.formActionsTable.readComponents()
        }, lObj );

        if ( label ) {
            processNode.updateLabel( label.id, lObj );
            
            if ( label.id != id ) {
            	var processDefId = processNode.attributes.processDefId;
            	Ext.ux.suncode.I18NService.onLabelIdChange( processDefId, label.id, id );
            }
        } else {
            processNode.addLabel( lObj );
            Ext.ux.suncode.I18NService.addPackageTranslationsFromCaches( [ this.nameItem ] );
        }
        
        if ( setToObj ) {
            setToObj.setValue( id );
        }

        this.ownerCt.closeWindow();
    }
} );