Ext.ux.suncode.FormalParamDefWindow = function( config ) {
    var windowWidth = Ext.getBody().getViewSize().width * 0.5;
    var fp = config.fp;
    var winTitle = !Ext.isEmpty( fp ) ? getTranslation( 'Definicja parametru formalnego' ) + ' ' + fp.name : getTranslation( 'Kreator parametru formalnego' );
    var buttons = new Array();
    buttons.push( {
        cls: 'x-btn-icon',
        ref: 'saveBtn',
        icon: getPluginImgPath( 'save' ),
        tooltip: getTranslation( 'Zapisz' ),
        handler: this.saveForm,
        scope: this
    } );
    if ( !Ext.isEmpty( fp ) ) {
    	buttons.push( {
    		cls: 'x-btn-icon',
            icon: getPluginImgPath( 'utilization' ),
            tooltip: getTranslation( 'Pokaż wykorzystanie' ),
            handler: this.showUtilization,
            scope: this
        } );
    }
    buttons.push( {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'close' ),
        tooltip: getTranslation( 'Zamknij' ),
        cancel: false,
        handler: this.closeWindow,
        scope: this
    } );
    
    config = Ext.apply( {
        modal: true,
        width: windowWidth,
        autoScroll: true,
        title: winTitle,
        items: new Ext.ux.suncode.FormalParamDefPanel( config ),
        closable: true,
        tbar: new Ext.Toolbar( {
            buttons: buttons
        } )
    }, config );

    Ext.ux.suncode.FormalParamDefWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.FormalParamDefWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.FormalParamDefWindow.superclass.initComponent.call( this );
    },
    saveForm: function() {
        this.fpDefPanel.saveForm();
    },
    showUtilization: function() {
    	this.fpDefPanel.showUtilization();
    },
    closeWindow: function() {
        this.close();
    }
} );

Ext.ux.suncode.FormalParamDefPanel = function( config ) {
    var nameItemValue = '';
    var modeItemValue = 'IN';
    var typeItemValue = 'STRING';
    var descrItemValue = '';

    var fp = config.fp;
    if ( fp ) {
        nameItemValue = fp.name;
        modeItemValue = fp.mode;
        typeItemValue = fp.type;
        descrItemValue = fp.descr;
    }

    config = Ext.apply( {
        labelWidth: 150,
        autoHeight: true,
        frame: false,
        border: false,
        bodyCssClass: 'x-Module-container-padding',
        ref: 'fpDefPanel',
        items: [ new Ext.ux.suncode.IdField( {
            anchor: '100%',
            fieldLabel: getTranslation( 'Nazwa' ),
            allowBlank: true,
            value: nameItemValue,
            ref: 'nameItem',
            readOnly: !Ext.isEmpty( fp ),
            idMaxLength: Ext.ux.suncode.Constants.VARIABLE_ID_MAX_LENGTH,
            idChanged: !Ext.isEmpty( fp )
        } ), new Ext.ux.suncode.ModesChooser( {
            modeItemValue: modeItemValue
        } ), new Ext.ux.suncode.TypesChooser( {
            utilization: 'simple',
            typeItemValue: typeItemValue
        } ), {
            xtype: 'textarea',
            inputType: 'text',
            fieldLabel: '',
            fieldLabel: getTranslation( 'Opis' ),
            anchor: '100%',
            ref: 'descrItem',
            value: descrItemValue
        } ]
    }, config );

    Ext.ux.suncode.FormalParamDefPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.FormalParamDefPanel, Ext.FormPanel, {
    initComponent: function() {
        Ext.ux.suncode.FormalParamDefPanel.superclass.initComponent.call( this );
    },
    saveForm: function() {
        var name = this.nameItem.getValue();
        var mode = this.modesChooser.getValue();
        var type = this.typeItem.getValue();
        var descr = this.descrItem.getValue();
        var saveToObj = this.initialConfig.saveTo;
        var varRecord = this.initialConfig.varRecord;
        var fp = this.initialConfig.fp;
        var processNode = this.initialConfig.processNode;

        if ( Ext.isEmpty( name ) ) {
            showWarn( getTranslation( 'Podaj nazwę parametru formalnego.' ) );
            return;
        } else if ( Ext.isEmpty( mode ) ) {
            showWarn( getTranslation( 'Wybierz tryb.' ) );
            return;
        } else if ( Ext.isEmpty( type ) ) {
            showWarn( getTranslation( 'Wybierz typ.' ) );
            return;
        }

        if ( !fp && processNode.findFormalParamIgnoreCase( name ) ) {
            showWarn( getTranslation( 'Parametr formalny już istnieje.' ) );
            return;
        } else if ( processNode.findTable( name ) ) {
          showWarn( getTranslation( 'Nazwa parametru formalnego pokrywa się z identyfikatorem tabeli.' ) );
          return;
        }

        if ( processNode.findVariable( name ) ) {
          this.showSameIdAsVariableConfirmation( name );
        } else {
          this.validateName( name );
        }
    },
    showSameIdAsVariableConfirmation: function( name ) {
      var warnMsg = getTranslation( 'Nazwa parametru formalnego pokrywa się z identyfikatorem zmiennej procesu.' );
      warnMsg += '<br><br>' + getTranslation( 'Czy chcesz kontynuować?' );

      Ext.Msg.show( {
        title: '<font weight="bold">' + getTranslation( 'Uwaga' ) + '</font>',
        msg: warnMsg,
        buttons: {
          yes: getTranslation( 'Tak' ),
          no: getTranslation( 'Nie' )
        },
        fn: function( buttonId ) {
          if ( buttonId == 'yes' ) {
            this.validateName( name );
          }
        },
        icon: Ext.Msg.QUESTION,
        scope: this
      } );
    },
    validateName: function( name ) {
        var fp = this.initialConfig.fp;
        var maskId = 'formal_param_name_validation_mask';
        showLoadingMask( maskId, getTranslation( 'Trwa walidacja...' ) );

        Ext.Ajax.request( {
            url: 'api/xpdl/validateVariableId',
            method: 'GET',
            params: {
                variableId: name,
                previousVariableId: fp ? fp.name : null
            },
            scope: this,
            success: function( response, opts ) {
                removeLoadingMask( maskId );
                var validation = Ext.util.JSON.decode( response.responseText );

                if ( validation.correct ) {
                    this.validateActionAcceptButtonActions( name );
                } else {
                    showWarn( getTranslation( 'Zabroniony identyfikator.' ) );
                }
            },
            failure: function( response, opts ) {
                removeLoadingMask( maskId );
                showWarn( getTranslation( 'Wystąpił błąd.' ) );
            }
        } );
    },
    validateActionAcceptButtonActions: function( name ) {
      var maskId = 'variable_action_accept_button_actions_validation_mask';
      showLoadingMask( maskId, getTranslation( 'Trwa walidacja...' ) );
      var processNode = this.initialConfig.processNode;
      var attributionWarnings = new Array();

      if ( processNode.hasChildNodes() ) {
        processNode.eachChild( function( activityNode ) {
          if ( !Ext.isEmpty( activityNode.attributes.form.buttons ) ) {
            Ext.each( activityNode.attributes.form.buttons, function( formButton ) {
              if ( formButton.genre == 'ACTION_ACCEPT_BUTTON' && !Ext.isEmpty( formButton.actions ) ) {
                Ext.each( formButton.actions, function( formButtonAction ) {
                  if ( !Ext.isEmpty( formButtonAction.attributions ) ) {
                    Ext.each( formButtonAction.attributions, function( attribution ) {
                      if ( attribution.value == name ) {
                        attributionWarnings.push( {
                          activityName: activityNode.attributes.activityName,
                          buttonName: formButton.buttonName
                        } );
                      }
                    } );
                  }
                } );
              }
            } );
          }
        } );
      }

      if ( Ext.isEmpty( attributionWarnings ) ) {
        removeLoadingMask( maskId );
        this.executeSave();
      } else {
        removeLoadingMask( maskId );
        var warning = getTranslation( 'Nazwa parametru formalnego jest identyczny z przypisaniami wartości w akcjach następujących przycisków akceptacji:' );

        Ext.each( attributionWarnings, function ( attributionWarning, index, allAttributionWarnings ) {
          warning += '<br>';
          warning += '- ';
          warning += getTranslation( 'Nazwa zadania' );
          warning += ': ';
          warning += attributionWarning.activityName;
          warning += ', ';
          warning += getTranslation( 'Nazwa przycisku' );
          warning += ': ';
          warning += attributionWarning.buttonName;
        } );

        warning += '<br><br>';
        warning += getTranslation( 'Czy chcesz kontynuować?' );

        Ext.Msg.show( {
          title: '<font weight="bold">' + getTranslation( 'Uwaga' ) + '</font>',
          msg: warning,
          buttons: {
            yes: getTranslation( 'Kontynuuj' ),
            cancel: getTranslation( 'Anuluj' )
          },
          fn: function( buttonId ) {
            switch ( buttonId ) {
              case 'yes':
                this.executeSave();
                break;
              default:
                break;
            }
          },
          icon: Ext.Msg.WARNING,
          scope: this
        } );
      }
    },
    executeSave: function() {
        var name = this.nameItem.getValue();
        var mode = this.modesChooser.getValue();
        var type = this.typeItem.getValue();
        var descr = this.descrItem.getValue();
        var saveToObj = this.initialConfig.saveTo;
        var varRecord = this.initialConfig.varRecord;
        var fp = this.initialConfig.fp;
        var processNode = this.initialConfig.processNode;

        if ( saveToObj && varRecord ) {
            if ( fp ) {
                varRecord.set( 'name', name );
                varRecord.set( 'mode', mode );
                varRecord.set( 'type', type );
                varRecord.set( 'status', 'custom' );
                varRecord.commit();
            } else {
                var store = saveToObj.getStore();
                store.add( new varRecord( {
                    name: name,
                    mode: mode,
                    type: type,
                    status: 'custom'
                } ) );
                store.commitChanges();
                saveToObj.updateTitle();
            }
        }

        var fpObj = new Object();
        fpObj = Ext.apply( {
            id: name,
            name: name,
            mode: mode,
            type: type,
            descr: descr,
            status: 'custom'
        }, fpObj );

        if ( fp ) {
            processNode.updateFormalParam( fp.name, fpObj );
        } else {
            processNode.addFormalParam( fpObj );
        }

        this.ownerCt.closeWindow();
    },
    showUtilization: function() {
    	var fpName = this.nameItem.getValue();
    	
    	if ( Ext.isEmpty( fpName ) ) {
            showWarn( getTranslation( 'Podaj nazwę parametru formalnego.' ) );
            return;
        }
        
    	var win = new Ext.ux.suncode.VariableUtilizationWindow( {
          windowTitle: getTranslation( 'Komponenty wykorzystujące parametr formalny' ) + ': ' + fpName,
        	showCustomDescription: true,
          showModificationDate: true,
          showVariableUtilizationActions: true,
          enableRemoveAll: false,
        	processNode: this.initialConfig.processNode,
        	variableId: fpName
        } );
		win.show();
    }
} );

Ext.ux.suncode.FormalParameterService = {
    defaultParameterNames: [ 'Initiator', 'ProccessId', 'ActivityId', 'Transaction', 'Action', 'StorageData' ],
    defaultParameterDescriptions: [ getTranslation( 'Inicjator procesu' ), getTranslation( 'Identyfikator procesu' ),
                    getTranslation( 'Identyfikator zadania' ), getTranslation( 'Transakcja silnika Shark' ),
                    getTranslation( 'Opisuje przekierowanie do zadań' ),
                    getTranslation( 'Pełni funkcję schowka danych w ramach procesu' ) ],
    defaultParameterModes: [ {
      id: 'IN',
      name: getTranslation( 'Wejściowy' )
    }, {
      id: 'IN',
      name: getTranslation( 'Wejściowy' )
    }, {
      id: 'IN',
      name: getTranslation( 'Wejściowy' )
    }, {
      id: 'IN',
      name: getTranslation( 'Wejściowy' )
    }, {
      id: 'INOUT',
      name: getTranslation( 'Wejściowo/Wyjściowy' )
    }, {
      id: 'INOUT',
      name: getTranslation( 'Wejściowo/Wyjściowy' )
    } ],
    defaultParameterType: 'STRING',
    formPreviewHiddenParameters: [ 'transaction', 'docids' ],
    getDefaultParameters: function() {
        var formalParameters = new Array();

        Ext.each( this.defaultParameterNames, function( fpName, index, fpNames ) {
            var fpObj = new Object();
            var mode = this.defaultParameterModes[index];

            fpObj = Ext.apply( {
                id: fpName,
                name: fpName,
                mode: mode.id,
                modeName: mode.name,
                type: this.defaultParameterType,
                descr: this.defaultParameterDescriptions[index],
                status: 'static'
            }, fpObj );

            formalParameters.push( fpObj );
        }, this );

        return formalParameters;
    },
    isDefaultParameter: function( name ) {
        return this.defaultParameterNames.indexOf( name ) != -1;
    },
    isStorageDataParameter: function( name ) {
      return name === 'StorageData';
    },
    isCorrectStorageDataParameter: function( parameter ) {
      return parameter.mode === 'INOUT' && parameter.type === this.defaultParameterType;
    },
    buildStorageDataParameter: function() {
      return {
        id: 'StorageData',
        name: 'StorageData',
        mode: 'INOUT',
        modeName: getTranslation( 'Wejściowo/Wyjściowy' ),
        type: this.defaultParameterType,
        descr: getTranslation( 'Pełni funkcję schowka danych w ramach procesu' ),
        status: 'static'
      };
    }
};