Raphael.fn.pieChart = function( cx, cy, r, dataSet, config ) {
    var paper = this;
    var rad = Math.PI / 180;
    var chart = paper.set();
    var angle = 90;
    var total = 0;
    var angleMin = 10;
    var animDuration = config.animate ? 1000 : 1;
    function sector( cx, cy, r, startAngle, endAngle, params ) {
        if ( endAngle - startAngle > 359.99 ) {
            endAngle -= 0.01;
        }
        var x1 = cx + Math.cos( -startAngle * rad );
        var x2 = cx + Math.cos( -endAngle * rad );
        var y1 = cy + Math.sin( -startAngle * rad );
        var y2 = cy + Math.sin( -endAngle * rad );
        var sectorPath = paper.path( [ 'M', cx, cy, 'L', x1, y1, 'A', 1, 1, 0, +( endAngle - startAngle > 180 ), 0, x2, y2, 'z' ] ).attr( params );
        x1 = cx + r * Math.cos( -startAngle * rad );
        x2 = cx + r * Math.cos( -endAngle * rad );
        y1 = cy + r * Math.sin( -startAngle * rad );
        y2 = cy + r * Math.sin( -endAngle * rad );
        return sectorPath.animate( {
            path: [ 'M', cx, cy, 'L', x1, y1, 'A', r, r, 0, +( endAngle - startAngle > 180 ), 0, x2, y2, 'z' ]
        }, animDuration, 'bounce' );
    }
    var process = function( j ) {
        var angleplus = 360 * dataSet[j].magnitude / total;
        var popangle = angle + ( angleplus / 2 );
        var textAngle = ( -1 ) * angle - angleplus / 2;
        textAngle = textAngle < -90 && textAngle > -270 ? textAngle + 180 : textAngle;
        var p = sector( cx, cy, r, angle, angle + angleplus, {
            fill: dataSet[j].color,
            stroke: 'none',
            'stroke-width': 0
        } );
        var txt = paper.text( cx + r / 2 * Math.cos( -popangle * rad ), cy + r / 2 * Math.sin( -popangle * rad ), dataSet[j].label ).attr( {
            fill: '#000000',
            stroke: 'none',
            'font-size': 12,
            'font-family': 'Tahoma,Helvetica,sans-serif',
            'font-weight': 'bold',
            opacity: angleplus > angleMin ? 1 : 0
        } ).transform( 'r' + textAngle );
        angle += angleplus;
        chart.push( p );
        chart.push( txt );
        p.data( 'data', dataSet[i].data );
        txt.data( 'data', dataSet[i].data );
        var events = function() {
            var pMouseover = function( e ) {
                p.stop().animate( {
                    transform: config.animate ? 's1.1 1.1 ' + cx + ' ' + cy : '',
                    fill: config.sectorOverColor ? config.sectorOverColor : dataSet[j].color
                }, animDuration / 2, 'elastic' );
            };
            var pMouseout = function( e ) {
                p.stop().animate( {
                    transform: '',
                    fill: dataSet[j].color
                }, animDuration / 2, 'elastic' );
            };
            p.mouseover( pMouseover ).mouseout( pMouseout );
            txt.mouseover( pMouseover ).mouseout( pMouseout );
            if ( Ext.isFunction( config.sectorMouseover ) ) {
                p.mouseover( config.sectorMouseover );
                txt.mouseover( config.sectorMouseover );
            }
            if ( Ext.isFunction( config.sectorMouseout ) ) {
                p.mouseout( config.sectorMouseout );
                txt.mouseout( config.sectorMouseout );
            }
            eve.on( 'piechart.mouseover.' + dataSet[j].data.id, pMouseover );
            eve.on( 'piechart.mouseout.' + dataSet[j].data.id, pMouseout );
        };
        var eventsTask = new Ext.util.DelayedTask( events );
        eventsTask.delay( animDuration );
    };
    for ( var i = 0, ii = dataSet.length; i < ii; i++ ) {
        total += dataSet[i].magnitude;
    }
    for ( i = 0; i < ii; i++ ) {
        process( i );
    }
    return chart;
};