Ext.ux.suncode.IntegrationComponentWindow = function( config ) {
  var viewSize = Ext.getBody().getViewSize();

  config = Ext.apply( {
    autoWidth: true,
    autoHeight: true,
    frame: false,
    modal: true,
    constrain: true,
    shadow: false,
    resizable: false,
    items: [ new Ext.ux.suncode.IntegrationComponentTable( {
      ref: 'componentsTable',
      width: viewSize.width * 0.65,
      height: viewSize.height * 0.5,
      border: false,
      eventMode: config.eventMode,
      eventTypes: config.eventTypes,
      components: config.components,
      filteredCategories: config.filteredCategories,
      allCategories: config.allCategories,
      processNode: config.processNode,
      enableCopyPasteMenu: config.enableCopyPasteMenu,
      conditionalExecutionEnabled: true,
      inactiveEnabled: true,
      parametersWindowTitlePrefix: config.parametersWindowTitlePrefix,
      globalDefinition: config.globalDefinition,
      availableVariables: config.availableVariables,
      missingVariablesValidatorFunction: config.missingVariablesValidatorFunction,
      missingVariablesValidatorScope: config.missingVariablesValidatorScope,
      systemFunctionsAccessibility: Ext.ux.suncode.IntegrationComponentService.BROWSER_ACCESSIBILITY,
      getBindToFunction: config.getBindToFunction,
      getBindToScope: config.getBindToScope,
      getComponentRegistrationFunction: config.getComponentRegistrationFunction,
      getComponentRegistrationScope: config.getComponentRegistrationScope,
      copyComponentsFunction: config.copyComponentsFunction,
      copyComponentsScope: config.copyComponentsScope,
      handleCopiedComponentsFunction: config.handleCopiedComponentsFunction,
      handleCopiedComponentsScope: config.handleCopiedComponentsScope,
      pasteSpecialMessageType: config.pasteSpecialMessageType,
      validateFieldFunction: config.validateFieldFunction,
      validateFieldScope: config.validateFieldScope,
      validateRowFunction: config.validateRowFunction,
      validateRowScope: config.validateRowScope,
      pasteComponentsValidation: config.pasteComponentsValidation,
      destinationType: config.integrationComponentDestination,
      acceptButton: config.acceptButton,
      tableId: config.tableId,
      buttonId: config.buttonId,
      modifyGlobalDefinitionFunction: config.modifyGlobalDefinitionFunction,
      modifyGlobalDefinitionScope: config.modifyGlobalDefinitionScope
    } ) ],
    tbar: new Ext.Toolbar( {
      width: viewSize.width * 0.5,
      items: [ {
        cls: 'x-btn-icon',
        ref: 'saveBtn',
        icon: getPluginImgPath( 'save' ),
        tooltip: getTranslation( 'Zapisz' ),
        handler: this.saveForm,
        scope: this
      }, {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'close' ),
        tooltip: getTranslation( 'Zamknij' ),
        handler: this.closeWindow,
        scope: this
      } ]
    } )
  }, config );

  Ext.ux.suncode.IntegrationComponentWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.IntegrationComponentWindow, Ext.Window, {
  initComponent: function() {
    Ext.ux.suncode.IntegrationComponentWindow.superclass.initComponent.call( this );
  },
  saveForm: function() {
    var saveFunction = this.initialConfig.saveFunction;

    if ( Ext.isFunction( saveFunction ) ) {
      var saveScope = !Ext.isEmpty( this.initialConfig.saveScope ) ? this.initialConfig.saveScope : window;
      var components = this.componentsTable.readComponents();
      saveFunction.apply( saveScope, [ components ] );
      this.closeWindow();
    }
  },
  closeWindow: function() {
    this.close();
  }
} );