Ext.ux.suncode.DTGroupingAggregationWindow = function( config ) {
    var processNode = config.processNode;
    var aggregations = config.aggregations;

    var store = new Ext.data.Store( {
        reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( [ {
                name: 'columnId',
                type: 'string'
            }, {
                name: 'operation',
                type: 'string'
            } ] )
        } )
    } );

    if ( !Ext.isEmpty( aggregations ) ) {
        store.loadData( aggregations );
        store.commitChanges();
    }

    var columnsChooser = new Ext.ux.suncode.VariableSetColumnsChooser( {
        columns: config.columns,
        processNode: config.processNode
    } );
    var operationsChooser = new Ext.ux.suncode.AggregationOperationChooser( {
      operations: [ [ 'sum', getTranslation('Suma') ], [ 'min', getTranslation('Minimum') ],
        [ 'max', getTranslation('Maksimum') ], [ 'avg', getTranslation('Średnia arytmetyczna') ],
        [ 'distinct', getTranslation('Unikalne') ], [ 'count', getTranslation('Licznik') ] ]
    } );

    config = Ext.apply( {
        title: getTranslation( 'Agregacje' ),
        autoWidth: true,
        autoHeight: true,
        frame: false,
        modal: true,
        constrain: true,
        shadow: false,
        resizable: false,
        items: [ {
            xtype: 'editorgrid',
            store: store,
            border: false,
            height: 300,
            width: 600,
            enableColumnResize: true,
            columnLines: true,
            autoScroll: true,
            ref: 'aggregationsGrid',
            colModel: new Ext.grid.ColumnModel( {
                defaults: {
                    sortable: true,
                    menuDisabled: false
                },
                columns: [ {
                    id: 'columnId',
                    header: getTranslation( 'Zmienna' ),
                    dataIndex: 'columnId',
                    align: 'left',
                    editor: columnsChooser,
                    renderer: function( value, metaData, record, rowIndex, colIndex, store ) {
                      if ( Ext.isEmpty( value ) ) {
                        metaData.css = 'x-Module-requiredCell';
                      }

                      var func = Ext.util.Format.ComboBoxRenderer( columnsChooser );

                      return func.apply( this, [ value ] );
                    }
                }, {
                    id: 'operation',
                    header: getTranslation( 'Operacja' ),
                    dataIndex: 'operation',
                    align: 'left',
                    editor: operationsChooser,
                    renderer: Ext.util.Format.ComboBoxRenderer( operationsChooser )
                } ]
            } ),
            viewConfig: new Ext.ux.suncode.StandardGridView( {
                emptyText: getTranslation( 'Brak agregacji' )
            } ),
            sm: new Ext.grid.RowSelectionModel( {
                singleSelect: true
            } ),
            tbar: new Ext.Toolbar( {
                buttons: [ {
                    xtype: 'tbtext',
                    text: '<font ' + getTotalStyle() + '><b>' + getTranslation( 'Ilość agregacji' ) + ': ' + store.getCount() + '</b></font>'
                }, '->', {
                    cls: 'x-btn-icon',
                    icon: getPluginImgPath( 'add' ),
                    tooltip: getTranslation( 'Dodaj' ),
                    handler: function() {
                        var grid = this.ownerCt.ownerCt;
                        var store = grid.getStore();
                        var a = store.recordType;
                        var rec = new a( {
                            columnId: '',
                            operation: ''
                        } );
                        grid.stopEditing();
                        store.add( rec );
                        store.commitChanges();
                        grid.updateTitle();
                    }
                }, {
                    cls: 'x-btn-icon',
                    icon: getPluginImgPath( 'delete' ),
                    tooltip: getTranslation( 'Usuń' ),
                    handler: function() {
                        var grid = this.ownerCt.ownerCt;
                        var selModel = grid.getSelectionModel();
                        var rows = selModel.getSelections();
                        if ( rows.length == 0 ) {
                            showWarn( getTranslation( 'Wybierz agregację do usunięcia.' ) );
                            return;
                        }
                        removeRowAndMarkNext( grid, rows[0] );
                        grid.getView().refresh();
                        grid.updateTitle();
                    }
                } ]
            } ),
            updateTitle: function() {
                var tbar = this.getTopToolbar();
                var txtInfo = tbar.items.first();
                txtInfo.setText( '<font ' + getTotalStyle() + '><b>' + getTranslation( 'Ilość agregacji' ) + ': ' + this.getStore().getCount()
                                + '</b></font>' );
            },
            listeners: {
                scope: this,
                beforeedit: function( e ) {
                  var grid = e.grid;
                  var cm = grid.getColumnModel();
                  var colIndex = e.column;
                  var rec = e.record;
                  var columnId = rec.get( 'columnId' );

                  if ( cm.getColumnId( colIndex ) == 'operation' ) {
                    if ( Ext.isEmpty( columnId ) ) {
                      showWarn( getTranslation( 'Wybierz zmienną.' ) );
                      return false;
                    }

                    var variable = processNode.findVariable( columnId );

                    if ( !Ext.isEmpty( variable ) ) {
                      var operationsChooser = null;

                      switch ( variable.type ) {
                        case 'STRING':
                        case 'TEXTAREA':
                        case 'CHECKBOX':
                        case 'LISTBOX':
                        case 'LISTBOX_EDIT':
                        case 'LISTBOX_NO_FILTER':
                        case 'LISTBOX_EDIT_NO_FILTER':
                        case 'LISTBOX_NO_LAZY':
                        case 'LISTBOX_NO_FILTER_NO_LAZY':
                        case 'DATA_CHOOSER':
                        case 'USERLIST':
                        case 'USERLISTLISTBOX':
                        case 'ROLEUSERS':
                        case 'ROLEUSERS_NO_FILTER':
                          operationsChooser = new Ext.ux.suncode.AggregationOperationChooser( {
                            operations: [ [ 'distinct', getTranslation('Unikalne') ], [ 'count', getTranslation('Licznik') ] ]
                          } );
                          break;
                        case 'DATE':
                        case 'DATETIME':
                          operationsChooser = new Ext.ux.suncode.AggregationOperationChooser( {
                            operations: [ [ 'min', getTranslation('Minimum') ], [ 'max', getTranslation('Maksimum') ],
                              [ 'distinct', getTranslation('Unikalne') ], [ 'count', getTranslation('Licznik') ] ]
                          } );
                          break;
                        default:
                          operationsChooser = new Ext.ux.suncode.AggregationOperationChooser( {
                            operations: [ [ 'sum', getTranslation('Suma') ], [ 'min', getTranslation('Minimum') ],
                              [ 'max', getTranslation('Maksimum') ], [ 'avg', getTranslation('Średnia arytmetyczna') ],
                              [ 'distinct', getTranslation('Unikalne') ], [ 'count', getTranslation('Licznik') ] ]
                          } );
                          break;
                      }

                      cm.setEditor( colIndex, operationsChooser );
                      cm.setRenderer( colIndex, Ext.util.Format.ComboBoxRenderer( operationsChooser ) );
                    }
                  }
                },
                validateedit: function( e ) {
                  var grid = e.grid;
                  var store = grid.getStore();
                  var cm = grid.getColumnModel();
                  var colIndex = e.column;
                  var value = e.value;

                  if ( cm.getColumnId( colIndex ) == 'columnId' && store.findExact( 'columnId', value ) != -1 ) {
                    showWarn( getTranslation( 'Zmienna procesu została już wykorzystana w innej agregacji.' ) );
                    return false;
                  }
                },
                afteredit: function( e ) {
                    e.grid.getStore().commitChanges();
                }
            }
        } ],
        tbar: new Ext.Toolbar( {
            width: 600,
            buttons: [ {
                cls: 'x-btn-icon',
                ref: 'saveBtn',
                icon: getPluginImgPath( 'save' ),
                tooltip: getTranslation( 'Zapisz' ),
                handler: this.save,
                scope: this
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'close' ),
                tooltip: getTranslation( 'Zamknij' ),
                handler: this.closeWindow,
                scope: this
            } ]
        } )
    }, config );

    Ext.ux.suncode.DTGroupingAggregationWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.DTGroupingAggregationWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.DTGroupingAggregationWindow.superclass.initComponent.call( this );
    },
    save: function() {
        var store = this.aggregationsGrid.getStore();
        var aggregations = new Array();

        if ( store.getCount() > 0 ) {
            for ( var i = 0; i < store.getCount(); i++ ) {
                var rec = store.getAt( i );
                var columnId = rec.get( 'columnId' );
                var operation = rec.get( 'operation' );

                if ( Ext.isEmpty( columnId ) || Ext.isEmpty( operation ) ) {
                    showWarn( getTranslation( 'Zdefiniuj wszystkie pola.' ) );
                    return;
                }

                aggregations.push( {
                    columnId: columnId,
                    operation: operation
                } );
            }
        }

        var recordToSave = this.initialConfig.recordToSave;
        recordToSave.set( 'aggregations', aggregations );
        recordToSave.commit();
        this.close();
    },
    closeWindow: function() {
        this.close();
    }
} );