Ext.ux.suncode.DTGroupingWindow = function( config ) {
    var groupers = config.groupers;
    var sorters = config.sorters;

    var store = new Ext.data.Store( {
        reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( [ {
                name: 'columnId',
                type: 'string'
            }, {
                name: 'groupNameColumnId',
                type: 'string'
            }, {
                name: 'direction',
                type: 'string'
            }, {
                name: 'aggregations'
            } ] )
        } )
    } );

    if ( !Ext.isEmpty( groupers ) ) {
        store.loadData( groupers );
        store.commitChanges();
    }

    var columnsChooser = new Ext.ux.suncode.VariableSetColumnsChooser( {
        columns: config.columns,
        processNode: config.processNode
    } );
    var groupNameColumnsChooser = new Ext.ux.suncode.VariableSetColumnsChooser( {
      columns: config.columns,
      processNode: config.processNode
    } );
    var directionsChooser = new Ext.ux.suncode.SortDirectionsChooser( {} );

    config = Ext.apply( {
        title: getTranslation( 'Grupowania tabeli dynamicznej' ),
        autoWidth: true,
        autoHeight: true,
        frame: false,
        modal: true,
        constrain: true,
        shadow: false,
        resizable: false,
        items: [ {
            xtype: 'editorgrid',
            store: store,
            border: false,
            height: 300,
            width: 700,
            enableColumnResize: true,
            columnLines: true,
            autoScroll: true,
            ref: 'groupingGrid',
            colModel: new Ext.grid.ColumnModel( {
                defaults: {
                    sortable: true,
                    menuDisabled: false
                },
                columns: [ {
                    id: 'columnId',
                    header: getTranslation( 'Zmienna' ),
                    dataIndex: 'columnId',
                    align: 'left',
                    editor: columnsChooser,
                    renderer: Ext.util.Format.ComboBoxRenderer( columnsChooser )
                }, {
                    id: 'groupNameColumnId',
                    header: getTranslation( 'Zmienna z nazwą grupy' ),
                    dataIndex: 'groupNameColumnId',
                    align: 'left',
                    editor: groupNameColumnsChooser,
                    renderer: Ext.util.Format.ComboBoxRenderer( groupNameColumnsChooser )
                }, {
                    id: 'direction',
                    header: getTranslation( 'Kierunek sortowania' ),
                    dataIndex: 'direction',
                    align: 'left',
                    editor: directionsChooser,
                    renderer: Ext.util.Format.ComboBoxRenderer( directionsChooser )
                }, {
                    id: 'aggregations',
                    header: getTranslation( 'Agregacje' ),
                    dataIndex: 'aggregations',
                    align: 'center',
                    renderer: function( value, metaData, record, rowIndex, colIndex, store ) {
                      var count = !Ext.isEmpty( value ) ? value.length : 0;
                      return '<div style="display: inline-flex; align-items: center;"><img src=\"' + getPluginImgPath( 'aggregation' )
                          + '\" width="16" height="16">' + '&nbsp;<span>(' + count + ')</span>';
                    }
                } ]
            } ),
            viewConfig: new Ext.ux.suncode.StandardGridView( {
                emptyText: getTranslation( 'Brak grupowań' )
            } ),
            sm: new Ext.grid.RowSelectionModel( {
                singleSelect: true
            } ),
            tbar: new Ext.Toolbar( {
                buttons: [ {
                    xtype: 'tbtext',
                    text: '<font ' + getTotalStyle() + '><b>' + getTranslation( 'Ilość grupowań' ) + ': ' + store.getCount() + '</b></font>'
                }, '->', {
                    cls: 'x-btn-icon',
                    icon: getPluginImgPath( 'add' ),
                    tooltip: getTranslation( 'Dodaj' ),
                    handler: function() {
                        var grid = this.ownerCt.ownerCt;
                        var store = grid.getStore();

                        if ( store.getCount() > 0 ) {
                          showWarn( getTranslation( 'Dozwolone jest tylko jedno grupowanie.' ) );
                          return;
                        }

                        var a = store.recordType;
                        var rec = new a( {
                            columnId: '',
                            groupNameColumnId: '',
                            direction: 'ASC',
                            aggregations: []
                        } );
                        grid.stopEditing();
                        store.add( rec );
                        store.commitChanges();
                        grid.updateTitle();
                    }
                }, {
                    cls: 'x-btn-icon',
                    icon: getPluginImgPath( 'delete' ),
                    tooltip: getTranslation( 'Usuń' ),
                    handler: function() {
                        var grid = this.ownerCt.ownerCt;
                        var selModel = grid.getSelectionModel();
                        var rows = selModel.getSelections();
                        if ( rows.length == 0 ) {
                            showWarn( getTranslation( 'Wybierz grupowanie do usunięcia.' ) );
                            return;
                        }
                        removeRowAndMarkNext( grid, rows[0] );
                        grid.getView().refresh();
                        grid.updateTitle();
                    }
                } ]
            } ),
            updateTitle: function() {
                var tbar = this.getTopToolbar();
                var txtInfo = tbar.items.first();
                txtInfo.setText( '<font ' + getTotalStyle() + '><b>' + getTranslation( 'Ilość grupowań' ) + ': ' + this.getStore().getCount()
                                + '</b></font>' );
            },
            listeners: {
                scope: this,
                validateedit: function( e ) {
                    var grid = e.grid;
                    var store = grid.getStore();
                    var cm = grid.getColumnModel();
                    var colIndex = e.column;
                    var value = e.value;

                    if ( cm.getColumnId( colIndex ) == 'columnId' && store.findExact( 'columnId', value ) != -1 ) {
                        showWarn( getTranslation( 'Zmienna procesu została już wykorzystana w innym grupowaniu.' ) );
                        return false;
                    }

                    if ( !Ext.isEmpty( sorters )) {
                      for ( var i = 0; i < sorters.length; i++ ) {
                        var sorter = sorters[i];

                        if ( sorter.columnId == value ) {
                          showWarn( getTranslation( 'Zmienna procesu została już wykorzystana w sortowaniu.' ) );
                          return false;
                        }
                      }
                    }
                },
                afteredit: function( e ) {
                    e.grid.getStore().commitChanges();
                },
                cellclick: this.onCellClick
            }
        } ],
        tbar: new Ext.Toolbar( {
            width: 600,
            buttons: [ {
                cls: 'x-btn-icon',
                ref: 'saveBtn',
                icon: getPluginImgPath( 'save' ),
                tooltip: getTranslation( 'Zapisz' ),
                handler: this.save,
                scope: this
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'close' ),
                tooltip: getTranslation( 'Zamknij' ),
                handler: this.closeWindow,
                scope: this
            } ]
        } )
    }, config );

    Ext.ux.suncode.DTGroupingWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.DTGroupingWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.DTGroupingWindow.superclass.initComponent.call( this );
    },
    onCellClick: function( grid, rowIndex, columnIndex, e ) {
      var colId = grid.getColumnModel().getColumnId( columnIndex );

      if ( colId != 'aggregations' ) {
        return;
      }

      var store = grid.getStore();
      var rec = store.getAt( rowIndex );
      var aggregations = rec.get( 'aggregations' );

      var win = new Ext.ux.suncode.DTGroupingAggregationWindow( {
        aggregations: aggregations,
        columns: this.initialConfig.columns,
        processNode: this.initialConfig.processNode,
        recordToSave: rec
      } );
      win.show();
    },
    save: function() {
        var store = this.groupingGrid.getStore();
        var groupers = new Array();

        if ( store.getCount() > 0 ) {
            for ( var i = 0; i < store.getCount(); i++ ) {
                var rec = store.getAt( i );
                var columnId = rec.get( 'columnId' );
                var direction = rec.get( 'direction' );

                if ( Ext.isEmpty( columnId ) || Ext.isEmpty( direction ) ) {
                    showWarn( getTranslation( 'Zdefiniuj wszystkie pola.' ) );
                    return;
                }

                groupers.push( {
                    columnId: columnId,
                    groupNameColumnId: rec.get( 'groupNameColumnId' ),
                    direction: direction,
                    aggregations: rec.get( 'aggregations' )
                } );
            }
        }

        Ext.getCmp( 'form_grid_definition_panel' ).setGroupers( groupers );
        this.close();
    },
    closeWindow: function() {
        this.close();
    }
} );