Ext.ux.suncode.UtilizationInActivitiesPanel = function( config ) {
    var processNode = config.processNode;

    var store = new Ext.data.Store( {
        data: config.utilizationInActivities,
        reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( [ {
                name: 'activityDefId',
                type: 'string'
            }, {
                name: 'description',
                type: 'string'
            } ] )
        } )
    } );

    var activitiesChooser = new Ext.ux.suncode.ActivitiesChooser( {
        processNode: processNode,
        acceptedTypes: [ Ext.ux.suncode.Constants.ACTIVITY, Ext.ux.suncode.Constants.TOOL ]
    } );

    config = Ext.apply( {
        title: getTranslation( 'Wykorzystanie w zadaniach' ),
        height: 200,
        store: store,
        columnLines: true,
        autoScroll: true,
        frame: false,
        enableColumnMove: true,
        collapsed: true,
        colModel: new Ext.grid.ColumnModel( {
            defaults: {
                sortable: true,
                menuDisabled: false
            },
            columns: [ {
                id: 'activityDefId',
                header: getTranslation( 'Nazwa zadania' ),
                dataIndex: 'activityDefId',
                align: 'left',
                editor: activitiesChooser,
                renderer: Ext.util.Format.ComboBoxRenderer( activitiesChooser )
            }, {
                id: 'description',
                header: getTranslation( 'Opis' ),
                dataIndex: 'description',
                align: 'left',
                editor: {
                    xtype: 'textarea'
                }
            } ]
        } ),
        viewConfig: new Ext.ux.suncode.StandardGridView( {
            emptyText: getTranslation( 'Brak zadań' )
        } ),
        sm: new Ext.grid.RowSelectionModel( {
            singleSelect: true
        } ),
        tbar: new Ext.Toolbar( {
            items: [ '->', {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'add' ),
                tooltip: getTranslation( 'Dodaj zadanie' ),
                handler: function() {
                    var grid = this.ownerCt.ownerCt;
                    var store = grid.getStore();
                    var v = store.recordType;
                    var rec = new v( {
                        activityDefId: '',
                        description: ''
                    } );
                    grid.stopEditing();
                    store.add( rec );
                    store.commitChanges();
                }
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'delete' ),
                tooltip: getTranslation( 'Usuń zadanie' ),
                handler: function() {
                    var grid = this.ownerCt.ownerCt;
                    var selModel = grid.getSelectionModel();
                    var rows = selModel.getSelections();
                    if ( rows.length == 0 ) {
                        showWarn( getTranslation( 'Wybierz zadanie do usunięcia.' ) );
                        return;
                    }
                    removeRowAndMarkNext( grid, rows[0] );
                    grid.getView().refresh();
                }
            } ]
        } ),
        listeners: {
            afteredit: function( e ) {
                e.record.commit();
            }
        }
    }, config );

    Ext.ux.suncode.UtilizationInActivitiesPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.UtilizationInActivitiesPanel, Ext.grid.EditorGridPanel, {
    initComponent: function() {
        Ext.ux.suncode.UtilizationInActivitiesPanel.superclass.initComponent.call( this );
    },
    isValid: function() {
        var valid = true;
        var store = this.getStore();

        store.each( function( rec ) {
            var activityDefId = rec.get( 'activityDefId' );

            if ( Ext.isEmpty( activityDefId ) ) {
                showWarn( getTranslation( 'Podaj nazwę wszystkich zadań.' ) );
                valid = false;
                return false;
            }
        } );

        return valid;
    },
    readUtilizationInActivities: function() {
        var activities = new Array();
        var store = this.getStore();

        store.each( function( rec ) {
            activities.push( {
                activityDefId: rec.get( 'activityDefId' ),
                description: rec.get( 'description' )
            } );
        } );

        return activities;
    }
} );