Ext.ux.suncode.StandardGridView = function( config ) {
    config = config ? config : new Object();

    config = Ext.apply( {
        forceFit: true,
        emptyText: '<bold>' + config.emptyText + '</bold>',
        columnsText: getTranslation( 'Kolumny' ),
        sortAscText: getTranslation( 'Sortuj rosnąco' ),
        sortDescText: getTranslation( 'Sortuj malejąco' )
    }, config );

    Ext.ux.suncode.StandardGridView.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.StandardGridView, Ext.grid.GridView, {
    initComponent: function() {
        Ext.ux.suncode.StandardGridView.superclass.initComponent.call( this );
    }
} );

Ext.ux.suncode.StandardPagingToolbar = function( config ) {
    config = config ? config : new Object();

    config = Ext.apply( {
        firstText: getTranslation( 'Pierwsza strona' ),
        prevText: getTranslation( 'Poprzednia strona' ),
        nextText: getTranslation( 'Następna strona' ),
        lastText: getTranslation( 'Ostatnia strona' ),
        refreshText: getTranslation( 'Odśwież' ),
        beforePageText: getTranslation( 'Strona' ),
        afterPageText: getTranslation( 'z' ) + ' {0}',
        displayInfo: true,
        displayMsg: '<bold>' + config.contentName + ' {0} - {1} ' + getTranslation( 'z' ) + ' {2}</bold>'
    }, config );

    Ext.ux.suncode.StandardPagingToolbar.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.StandardPagingToolbar, Ext.PagingToolbar, {
    initComponent: function() {
        Ext.ux.suncode.StandardPagingToolbar.superclass.initComponent.call( this );
    }
} );