/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.web.support.dto.xpdl.builder;

import com.plusmpm.util.CoreTools;
import com.suncode.plugin.pwe.service.translator.TranslatorService;
import com.suncode.plugin.pwe.util.PweUtils;
import com.suncode.plugin.pwe.web.support.dto.packageinfo.PackageInfoDto;
import com.suncode.plugin.pwe.web.support.dto.xpdl.PackageDto;
import com.suncode.plugin.pwe.web.support.dto.xpdl.PackageVersionInfoDto;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.enhydra.shark.xpdl.elements.Package;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PackageVersionInfoDtoBuilder {
    public static Logger log = Logger.getLogger(PackageVersionInfoDtoBuilder.class);
    private static final String NEW_LINE = "\n";
    private static final String INFO_DELIMITER = "\n====================================================================\n";
    private static final String VERSION_INFO = "pwe.packageinfo.version";
    private static final String CHANGE_AUTHOR_INFO = "pwe.packageinfo.changeauthor";
    private static final String UPLOAD_TIME_INFO = "pwe.packageinfo.uploadtime";
    private static final String NO_CHANGE_AUTHOR = "n/a";
    @Autowired
    private TranslatorService translatorService;

    public PackageVersionInfoDto build(Package pack, List<PackageDto> previousPackages, Map<String, PackageInfoDto> packageInfoDtos) {
        String uploadTime = PweUtils.getPackageUploadTime(pack);
        PackageVersionInfoDto dto = new PackageVersionInfoDto();
        dto.setId(pack.getId());
        dto.setVersion(pack.getInternalVersion());
        dto.setName(pack.getName());
        dto.setAuthor(PweUtils.getPackageAuthor(pack));
        dto.setCreationTime(pack.getPackageHeader().getCreated());
        dto.setUploadTime(uploadTime);
        dto.setNoOfProcesses(pack.getWorkflowProcesses().size());
        dto.setInfo(this.buildInfo(pack, uploadTime, previousPackages, packageInfoDtos));
        return dto;
    }

    private String buildInfo(Package pack, String uploadTime, List<PackageDto> previousPackages, Map<String, PackageInfoDto> packageInfoDtos) {
        ArrayList<String> versionInfos = new ArrayList<String>();
        versionInfos.add(this.buildPackageVersionInfo(pack, uploadTime, packageInfoDtos));
        previousPackages.forEach(p -> versionInfos.add(this.buildPackageVersionInfo((PackageDto)p, packageInfoDtos)));
        return versionInfos.stream().collect(Collectors.joining(INFO_DELIMITER));
    }

    private String buildPackageVersionInfo(Package pack, String uploadTime, Map<String, PackageInfoDto> packageInfoDtos) {
        return this.buildPackageVersionInfo(pack.getInternalVersion(), uploadTime, packageInfoDtos);
    }

    private String buildPackageVersionInfo(PackageDto previousPackage, Map<String, PackageInfoDto> packageInfoDtos) {
        return this.buildPackageVersionInfo(previousPackage.getVersion(), previousPackage.getUploadTime(), packageInfoDtos);
    }

    private String buildPackageVersionInfo(String version, String uploadTime, Map<String, PackageInfoDto> packageInfoDtos) {
        PackageInfoDto packageInfoDto = packageInfoDtos.get(version);
        StringBuilder info = new StringBuilder();
        info.append(this.translatorService.translateMessage(VERSION_INFO));
        info.append(": ");
        info.append(version);
        info.append(", ");
        info.append(this.translatorService.translateMessage(CHANGE_AUTHOR_INFO));
        info.append(": ");
        if (packageInfoDto != null && StringUtils.isNotBlank((CharSequence)packageInfoDto.getAuthor())) {
            info.append(CoreTools.GetRealUserName((String)packageInfoDto.getAuthor()));
        } else {
            info.append(NO_CHANGE_AUTHOR);
        }
        info.append(", ");
        info.append(this.translatorService.translateMessage(UPLOAD_TIME_INFO));
        info.append(": ");
        info.append(uploadTime);
        if (packageInfoDto != null && StringUtils.isNotBlank((CharSequence)packageInfoDto.getPackageInfo())) {
            info.append(NEW_LINE);
            info.append(packageInfoDto.getPackageInfo());
        }
        return info.toString();
    }
}

