/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.web.support.dto.xpdl.builder;

import com.suncode.plugin.pwe.util.PweUtils;
import com.suncode.plugin.pwe.web.support.dto.xpdl.PackageDto;
import com.suncode.pwfl.xpdl.packages.PackageDetails;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.enhydra.shark.repositorypersistence.data.XPDLHistoryDO;
import org.springframework.stereotype.Component;

@Component
public class PackageDtoBuilder {
    public static Logger log = Logger.getLogger(PackageDtoBuilder.class);

    public List<PackageDto> build(List<PackageDetails> packagesDetails) {
        return packagesDetails.stream().map(this::build).collect(Collectors.toList());
    }

    private PackageDto build(PackageDetails packageDetails) {
        PackageDto dto = new PackageDto();
        dto.setId(packageDetails.getPackageId());
        dto.setVersion(packageDetails.getPackageVersion());
        dto.setAuthor(packageDetails.getAuthor());
        dto.setUploadTime(PweUtils.buildFormattedDate(packageDetails.getUploadTime(), "yyyy-MM-dd HH:mm:ss"));
        return dto;
    }

    public List<PackageDto> build(XPDLHistoryDO[] xpdlsHistory) {
        return Stream.of(xpdlsHistory).map(this::build).collect(Collectors.toList());
    }

    private PackageDto build(XPDLHistoryDO xpdlHistory) {
        PackageDto dto = new PackageDto();
        try {
            dto.setId(xpdlHistory.getXPDLId());
            dto.setVersion(xpdlHistory.getXPDLVersion());
            dto.setUploadTime(PweUtils.buildFormattedDate(xpdlHistory.getXPDLUploadTime(), "yyyy-MM-dd HH:mm:ss"));
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
        }
        return dto;
    }
}

