/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.web.support.dto.javacode.builder;

import com.plusmpm.util.CoreTools;
import com.suncode.plugin.pwe.model.javacode.JavaCode;
import com.suncode.plugin.pwe.web.support.dto.javacode.JavaCodeDto;
import org.springframework.stereotype.Component;

@Component
public class JavaCodeDtoBuilder {
    public JavaCodeDto build(JavaCode javaCode) {
        JavaCodeDto dto = new JavaCodeDto();
        dto.setQualifiedName(javaCode.getQualifiedName());
        dto.setCodeAuthor(javaCode.getCodeAuthor());
        dto.setSourceCode(javaCode.getSourceCode());
        dto.setAvailableInSystem(true);
        return dto;
    }

    public JavaCodeDto build(String userId, String qualifiedName, String sourceCode) {
        JavaCodeDto dto = new JavaCodeDto();
        dto.setQualifiedName(qualifiedName);
        dto.setCodeAuthor(this.buildCodeAuthor(userId));
        dto.setSourceCode(sourceCode);
        dto.setAvailableInSystem(false);
        return dto;
    }

    private String buildCodeAuthor(String userId) {
        return CoreTools.GetRealUserName((String)userId);
    }

    public JavaCode extract(JavaCodeDto dto) {
        JavaCode javaCode = this.extractBase(dto);
        javaCode.setCodeAuthor(dto.getCodeAuthor());
        return javaCode;
    }

    public JavaCode extract(String userId, JavaCodeDto dto) {
        JavaCode javaCode = this.extractBase(dto);
        javaCode.setCodeAuthor(this.buildCodeAuthor(userId));
        return javaCode;
    }

    private JavaCode extractBase(JavaCodeDto dto) {
        JavaCode javaCode = new JavaCode();
        javaCode.setQualifiedName(dto.getQualifiedName());
        javaCode.setSourceCode(dto.getSourceCode());
        return javaCode;
    }
}

