/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.upgrader;

import com.plusmpm.util.XpdlPackageManager;
import com.suncode.plugin.pwe.configuration.PluginSpringContext;
import com.suncode.plugin.pwe.service.formtemplate.FormTemplateService;
import com.suncode.plugin.pwe.upgrader.UpgraderUtils;
import com.suncode.plugin.pwe.util.FormTemplateUtils;
import com.suncode.plugin.pwe.util.exception.UpgraderException;
import com.suncode.pwfl.util.style.IconUtils;
import java.io.File;
import java.util.Collection;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import liquibase.change.custom.CustomTaskChange;
import liquibase.database.Database;
import liquibase.exception.CustomChangeException;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TransformIconsOnFormsChange
implements CustomTaskChange {
    public static Logger log = Logger.getLogger(TransformIconsOnFormsChange.class);
    private static final XPath XPATH = XPathFactory.newInstance().newXPath();
    private static final String ITEM_EXP = "Rows/Row/Item";
    private static final String ICON_EXP = "Styles/Icon";
    private static final String VALUE_ATTR_NAME = "value";

    public void execute(Database database) throws CustomChangeException {
        FormTemplateService formTemplateService = PluginSpringContext.getBean(FormTemplateService.class);
        TransformIconsOnFormsChange.transformIconsOnFormsForLoadedToSystem(formTemplateService);
        TransformIconsOnFormsChange.transformIconsOnFormsForFormTemplates(formTemplateService, "xpdl/saved");
        TransformIconsOnFormsChange.transformIconsOnFormsForFormTemplates(formTemplateService, "xpdl/autosaved");
        TransformIconsOnFormsChange.transformIconsOnFormsForFormTemplates(formTemplateService, "xpdl/uploaded");
    }

    private static void transformIconsOnFormsForLoadedToSystem(FormTemplateService formTemplateService) {
        XpdlPackageManager.getInstance().getPackageIds().forEach(packageId -> TransformIconsOnFormsChange.transformIconsOnFormsForLoadedToSystem(formTemplateService, packageId));
    }

    private static void transformIconsOnFormsForLoadedToSystem(FormTemplateService formTemplateService, String packageId) {
        XpdlPackageManager.getInstance().getPackageVersions(packageId).stream().map(String::valueOf).map(packageVersion -> formTemplateService.getFormTemplates(packageId, (String)packageVersion)).flatMap(Collection::stream).forEach(TransformIconsOnFormsChange::transformIconsOnForms);
    }

    private static void transformIconsOnFormsForFormTemplates(FormTemplateService formTemplateService, String locationPrefix) {
        formTemplateService.getFormTemplatesFromStored(locationPrefix).forEach(TransformIconsOnFormsChange::transformIconsOnForms);
    }

    private static void transformIconsOnForms(File file) {
        block4: {
            try {
                log.info((Object)("Analizowany plik: " + file.getAbsolutePath()));
                if (file.exists()) {
                    Document document = FormTemplateUtils.getAsXml(file);
                    Element root = document.getDocumentElement();
                    TransformIconsOnFormsChange.analyzeItemsIcon(root);
                    FormTemplateUtils.saveAsXml(file, document);
                } else {
                    log.info((Object)("Plik nie istnieje w lokalizacji: " + file.getAbsolutePath()));
                }
            }
            catch (Exception exception) {
                log.error((Object)exception.getMessage(), (Throwable)exception);
                if (!UpgraderUtils.shouldStopMigration(exception)) break block4;
                throw new UpgraderException(exception);
            }
        }
    }

    private static void analyzeItemsIcon(Element element) throws XPathExpressionException {
        NodeList itemsList = (NodeList)XPATH.evaluate(ITEM_EXP, element, XPathConstants.NODESET);
        FormTemplateUtils.convertToElementsList(itemsList).forEach(TransformIconsOnFormsChange::analyzeItemIcon);
    }

    private static void analyzeItemIcon(Element element) {
        block3: {
            try {
                Element nodeElement;
                String valueAttr;
                Node node = (Node)XPATH.evaluate(ICON_EXP, element, XPathConstants.NODE);
                if (FormTemplateUtils.isElement(node) && !StringUtils.startsWith((CharSequence)(valueAttr = (nodeElement = (Element)node).getAttribute(VALUE_ATTR_NAME)), (CharSequence)"DIVANTE_ICON_")) {
                    nodeElement.setAttribute(VALUE_ATTR_NAME, TransformIconsOnFormsChange.toTransformedIcon(valueAttr));
                }
            }
            catch (Exception exception) {
                log.error((Object)exception.getMessage(), (Throwable)exception);
                if (!UpgraderUtils.shouldStopMigration(exception)) break block3;
                throw new UpgraderException(exception);
            }
        }
    }

    private static String toTransformedIcon(String icon) {
        return "DIVANTE_ICON_" + IconUtils.resolveIcon((String)icon);
    }

    public String getConfirmationMessage() {
        return null;
    }

    public void setUp() throws SetupException {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }
}

