/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.object.builder;

import com.suncode.plugin.pwe.documentation.enumeration.Operator;
import com.suncode.plugin.pwe.documentation.object.TransitionCondition;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class TransitionConditionBuilder {
    private static final String VALUE_START_END_SIGN = "'";

    public List<TransitionCondition> build(String condition, String joinSign) {
        String[] subconditions;
        ArrayList<TransitionCondition> transitionConditions = new ArrayList<TransitionCondition>();
        List<String> operatorsStart = this.buildOperatorsStart();
        for (String subcondition : subconditions = StringUtils.split((String)condition, (String)joinSign)) {
            String operator = "";
            String variableId = "";
            String value = "";
            for (String operatorStart : operatorsStart) {
                if (!StringUtils.contains((CharSequence)subcondition, (CharSequence)operatorStart)) continue;
                operator = new String(operatorStart);
                int operatorIndex = StringUtils.indexOf((CharSequence)subcondition, (CharSequence)operatorStart);
                variableId = StringUtils.trim((String)StringUtils.substring((String)subcondition, (int)0, (int)operatorIndex));
                value = this.buildValue(subcondition, operatorIndex, operatorStart);
                break;
            }
            if (!this.shouldBuild(operator, variableId, value)) continue;
            transitionConditions.add(this.build(operator, variableId, value));
        }
        return transitionConditions;
    }

    private List<String> buildOperatorsStart() {
        ArrayList<String> operatorsStart = new ArrayList<String>();
        for (Operator operator : Operator.values()) {
            operatorsStart.add(operator.getName());
        }
        return operatorsStart;
    }

    private String buildValue(String subcondition, int operatorIndex, String operator) {
        String value = "";
        value = StringUtils.substring((String)subcondition, (int)(operatorIndex + operator.length()));
        if (StringUtils.startsWith((CharSequence)(value = StringUtils.trim((String)value)), (CharSequence)VALUE_START_END_SIGN)) {
            value = StringUtils.stripStart((String)value, (String)VALUE_START_END_SIGN);
        }
        if (StringUtils.endsWith((CharSequence)value, (CharSequence)VALUE_START_END_SIGN)) {
            value = StringUtils.stripEnd((String)value, (String)VALUE_START_END_SIGN);
        }
        return value;
    }

    private boolean shouldBuild(String operator, String variableId, String value) {
        return StringUtils.isNotBlank((CharSequence)operator) && StringUtils.isNotBlank((CharSequence)variableId) && StringUtils.isNotBlank((CharSequence)value);
    }

    private TransitionCondition build(String operator, String variableId, String value) {
        TransitionCondition transitionCondition = new TransitionCondition();
        transitionCondition.setOperator(Operator.getByName(operator));
        transitionCondition.setVariableId(variableId);
        transitionCondition.setValue(value);
        return transitionCondition;
    }
}

