/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.chapter.point.builder;

import com.suncode.plugin.pwe.documentation.Documentation;
import com.suncode.plugin.pwe.documentation.chapter.point.builder.ActivityPointBuilder;
import com.suncode.plugin.pwe.documentation.object.ActivityForm;
import com.suncode.plugin.pwe.documentation.specification.ActivitySpecification;
import com.suncode.plugin.pwe.documentation.subchapter.builder.SubchapterBuilder;
import com.suncode.plugin.pwe.service.translator.TranslatorService;
import com.suncode.plugin.pwe.util.ExtAttrUtils;
import com.suncode.plugin.pwe.util.translation.TranslationInfo;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="activityConcurrentAcceptancePointBuilder")
public class ActivityConcurrentAcceptancePointBuilderImpl
implements ActivityPointBuilder {
    private static final String POINT_TITLE = "pwe.documentation.point.title.concurrentacceptance";
    private static final String ACCEPT_CONCURRENTLY_EXT_ATTR_NAME = "ACCEPT_CONCURRENTLY";
    private static final String ACCEPT_CONCURRENTLY_EXT_ATTR_VALUE = "FALSE";
    private static final String YES = "pwe.documentation.text.yes";
    private static final String NO = "pwe.documentation.text.no";
    @Autowired
    private TranslatorService translatorService;
    @Autowired
    private SubchapterBuilder subchapterBuilder;

    @Override
    public void build(Documentation documentation, WorkflowProcess process, TranslationInfo translationInfo, Activity activity, ActivitySpecification activitySpecification, ActivityForm activityForm) {
        String text = this.buildConcurrentAcceptance(activity);
        this.buildPoint(documentation, text);
    }

    private String buildConcurrentAcceptance(Activity activity) {
        if (ExtAttrUtils.hasExtAttr(activity.getExtendedAttributes(), ACCEPT_CONCURRENTLY_EXT_ATTR_NAME, ACCEPT_CONCURRENTLY_EXT_ATTR_VALUE)) {
            return this.translatorService.translateMessage(NO);
        }
        return this.translatorService.translateMessage(YES);
    }

    private void buildPoint(Documentation documentation, String text) {
        this.subchapterBuilder.build(documentation, POINT_TITLE, text);
    }
}

