/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.chapter.builder;

import com.suncode.plugin.pwe.documentation.Documentation;
import com.suncode.plugin.pwe.documentation.TableCell;
import com.suncode.plugin.pwe.documentation.TableHeader;
import com.suncode.plugin.pwe.documentation.TableHeaders;
import com.suncode.plugin.pwe.documentation.TableRecord;
import com.suncode.plugin.pwe.documentation.TableRecords;
import com.suncode.plugin.pwe.documentation.chapter.builder.ChapterBuilder;
import com.suncode.plugin.pwe.documentation.specification.ColumnSpecification;
import com.suncode.plugin.pwe.documentation.specification.DatabaseTableSpecification;
import com.suncode.plugin.pwe.documentation.specification.ProcessSpecification;
import com.suncode.plugin.pwe.documentation.specification.UtilizationSpecification;
import com.suncode.plugin.pwe.documentation.subchapter.builder.SubchapterBuilder;
import com.suncode.plugin.pwe.documentation.util.BookmarkNameUtils;
import com.suncode.plugin.pwe.documentation.util.Counter;
import com.suncode.plugin.pwe.documentation.util.TableUtils;
import com.suncode.plugin.pwe.service.translator.TranslatorService;
import com.suncode.plugin.pwe.util.translation.TranslationInfo;
import com.suncode.plugin.pwe.web.support.dto.documentationconfig.DocumentationConfigDto;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.enhydra.shark.xpdl.elements.Activities;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="databasesTablesChapterBuilder")
public class DatabasesTablesChapterBuilderImpl
implements ChapterBuilder {
    private static final String CHAPTER_TITLE = "pwe.documentation.chapter.title.databasestables";
    private static final String DATABASE_TYPE_POINT_TITLE = "pwe.documentation.point.title.databasetype";
    private static final String LOCATION_POINT_TITLE = "pwe.documentation.point.title.location";
    private static final String ADDED_FROM_ADMINISTRATION_POINT_TITLE = "pwe.documentation.point.title.addedfromadministration";
    private static final String YES = "pwe.documentation.text.yes";
    private static final String NO = "pwe.documentation.text.no";
    private static final String COLUMNS_POINT_TITLE = "pwe.documentation.point.title.columns";
    private static final String COLUMN_NAME_TABLE_COLUMN_ID = "name";
    private static final String COLUMN_NAME_TABLE_HEADER = "pwe.documentation.table.header.name";
    private static final String COLUMN_TYPE_TABLE_COLUMN_ID = "type";
    private static final String COLUMN_TYPE_TABLE_HEADER = "pwe.documentation.table.header.type";
    private static final String COLUMN_DESCRIPTION_TABLE_COLUMN_ID = "description";
    private static final String COLUMN_DESCRIPTION_NAME_TABLE_HEADER = "pwe.documentation.table.header.description";
    private static final String UTILIZATION_IN_ACTIVITIES_POINT_TITLE = "pwe.documentation.point.title.utilizationinactivities";
    private static final String UTILIZATION_IN_ACTIVITIES_ACTIVITY_NAME_TABLE_COLUMN_ID = "activityName";
    private static final String UTILIZATION_IN_ACTIVITIES_ACTIVITY_NAME_TABLE_HEADER = "pwe.documentation.table.header.activityname";
    private static final String UTILIZATION_IN_ACTIVITIES_UTILIZATION_TABLE_COLUMN_ID = "utilization";
    private static final String UTILIZATION_IN_ACTIVITIES_UTILIZATION_TABLE_HEADER = "pwe.documentation.table.header.utilization";
    @Autowired
    private TranslatorService translatorService;
    @Autowired
    private SubchapterBuilder subchapterBuilder;

    @Override
    public void build(Documentation documentation, WorkflowProcess process, ProcessSpecification processSpecification, TranslationInfo translationInfo, DocumentationConfigDto documentationConfig) {
        documentation.addChapter(this.translatorService.translateDocumentationChapterTitle(CHAPTER_TITLE));
        this.buildSubchapters(documentation, process, processSpecification);
    }

    private void buildSubchapters(Documentation documentation, WorkflowProcess process, ProcessSpecification processSpecification) {
        List<DatabaseTableSpecification> databaseTableSpecifications = processSpecification.getDatabaseTableSpecifications();
        if (CollectionUtils.isNotEmpty(databaseTableSpecifications)) {
            Counter subchapterNo = new Counter(1);
            for (DatabaseTableSpecification databaseTableSpecification : databaseTableSpecifications) {
                this.buildSubchapter(documentation, process, databaseTableSpecification, subchapterNo.getCountAndIncrement());
            }
        }
    }

    private void buildSubchapter(Documentation documentation, WorkflowProcess process, DatabaseTableSpecification databaseTableSpecification, int subchapterNo) {
        String title = this.buildSubchapterTitle(databaseTableSpecification, subchapterNo);
        documentation.addSubchapter(title);
        this.buildDatabaseTypePoint(documentation, databaseTableSpecification);
        this.buildLocationPoint(documentation, databaseTableSpecification);
        this.buildAddedFromAdministrationPoint(documentation, databaseTableSpecification);
        this.buildColumnsPoint(documentation, databaseTableSpecification);
        this.buildUtilizationInActivitiesPoint(documentation, process, databaseTableSpecification);
        documentation.addNewLine();
    }

    private String buildSubchapterTitle(DatabaseTableSpecification databaseTableSpecification, int subchapterNo) {
        StringBuilder title = new StringBuilder();
        title.append(subchapterNo);
        title.append(". ");
        title.append(databaseTableSpecification.getName());
        return title.toString();
    }

    private void buildDatabaseTypePoint(Documentation documentation, DatabaseTableSpecification databaseTableSpecification) {
        this.buildPoint(documentation, DATABASE_TYPE_POINT_TITLE, databaseTableSpecification.getDatabaseType());
    }

    private void buildLocationPoint(Documentation documentation, DatabaseTableSpecification databaseTableSpecification) {
        this.buildPoint(documentation, LOCATION_POINT_TITLE, databaseTableSpecification.getLocation());
    }

    private void buildAddedFromAdministrationPoint(Documentation documentation, DatabaseTableSpecification databaseTableSpecification) {
        String text = this.buildAddedFromAdministrationText(databaseTableSpecification);
        this.buildPoint(documentation, ADDED_FROM_ADMINISTRATION_POINT_TITLE, text);
    }

    private String buildAddedFromAdministrationText(DatabaseTableSpecification databaseTableSpecification) {
        if (BooleanUtils.isTrue((Boolean)databaseTableSpecification.getAddedFromAdministration())) {
            return this.translatorService.translateMessage(YES);
        }
        return this.translatorService.translateMessage(NO);
    }

    private void buildColumnsPoint(Documentation documentation, DatabaseTableSpecification databaseTableSpecification) {
        TableHeaders headers = this.buildColumnsTableHeaders();
        TableRecords records = new TableRecords();
        for (ColumnSpecification columnSpecification : databaseTableSpecification.getColumns()) {
            records.add(this.buildColumnsTableRecord(columnSpecification));
        }
        this.buildPoint(documentation, COLUMNS_POINT_TITLE, headers, records);
    }

    private TableHeaders buildColumnsTableHeaders() {
        TableHeaders headers = new TableHeaders();
        headers.add(this.buildColumnsTableNameHeader());
        headers.add(this.buildColumnsTableTypeHeader());
        headers.add(this.buildColumnsTableDescriptionHeader());
        return headers;
    }

    private TableHeader buildColumnsTableNameHeader() {
        return TableUtils.buildTableHeader(COLUMN_NAME_TABLE_COLUMN_ID, this.translatorService.translateMessage(COLUMN_NAME_TABLE_HEADER));
    }

    private TableHeader buildColumnsTableTypeHeader() {
        return TableUtils.buildTableHeader(COLUMN_TYPE_TABLE_COLUMN_ID, this.translatorService.translateMessage(COLUMN_TYPE_TABLE_HEADER));
    }

    private TableHeader buildColumnsTableDescriptionHeader() {
        return TableUtils.buildTableHeader(COLUMN_DESCRIPTION_TABLE_COLUMN_ID, this.translatorService.translateMessage(COLUMN_DESCRIPTION_NAME_TABLE_HEADER));
    }

    private TableRecord buildColumnsTableRecord(ColumnSpecification columnSpecification) {
        TableRecord record = new TableRecord();
        record.addCell(COLUMN_NAME_TABLE_COLUMN_ID, this.buildColumnsTableNameCell(columnSpecification));
        record.addCell(COLUMN_TYPE_TABLE_COLUMN_ID, this.buildColumnsTableTypeCell(columnSpecification));
        record.addCell(COLUMN_DESCRIPTION_TABLE_COLUMN_ID, this.buildColumnsTableDescriptionCell(columnSpecification));
        return record;
    }

    private TableCell buildColumnsTableNameCell(ColumnSpecification columnSpecification) {
        return TableUtils.buildTableCell(columnSpecification.getName());
    }

    private TableCell buildColumnsTableTypeCell(ColumnSpecification columnSpecification) {
        return TableUtils.buildTableCell(columnSpecification.getType());
    }

    private TableCell buildColumnsTableDescriptionCell(ColumnSpecification columnSpecification) {
        return TableUtils.buildTableCell(columnSpecification.getDescription());
    }

    private void buildUtilizationInActivitiesPoint(Documentation documentation, WorkflowProcess process, DatabaseTableSpecification databaseTableSpecification) {
        TableHeaders headers = this.buildUtilizationInActivitiesTableHeaders();
        TableRecords records = new TableRecords();
        Activities activities = process.getActivities();
        for (UtilizationSpecification utilizationSpecification : databaseTableSpecification.getUtilizationInActivities()) {
            records.add(this.buildUtilizationInActivitiesTableRecord(activities, utilizationSpecification));
        }
        this.buildPoint(documentation, UTILIZATION_IN_ACTIVITIES_POINT_TITLE, headers, records);
    }

    private TableHeaders buildUtilizationInActivitiesTableHeaders() {
        TableHeaders headers = new TableHeaders();
        headers.add(this.buildUtilizationInActivitiesActivityNameHeader());
        headers.add(this.buildUtilizationInActivitiesUtilizationHeader());
        return headers;
    }

    private TableHeader buildUtilizationInActivitiesActivityNameHeader() {
        return TableUtils.buildTableHeader(UTILIZATION_IN_ACTIVITIES_ACTIVITY_NAME_TABLE_COLUMN_ID, this.translatorService.translateMessage(UTILIZATION_IN_ACTIVITIES_ACTIVITY_NAME_TABLE_HEADER));
    }

    private TableHeader buildUtilizationInActivitiesUtilizationHeader() {
        return TableUtils.buildTableHeader(UTILIZATION_IN_ACTIVITIES_UTILIZATION_TABLE_COLUMN_ID, this.translatorService.translateMessage(UTILIZATION_IN_ACTIVITIES_UTILIZATION_TABLE_HEADER));
    }

    private TableRecord buildUtilizationInActivitiesTableRecord(Activities activities, UtilizationSpecification utilizationSpecification) {
        TableRecord record = new TableRecord();
        record.addCell(UTILIZATION_IN_ACTIVITIES_ACTIVITY_NAME_TABLE_COLUMN_ID, this.buildUtilizationInActivitiesActivityNameCell(activities, utilizationSpecification));
        record.addCell(UTILIZATION_IN_ACTIVITIES_UTILIZATION_TABLE_COLUMN_ID, this.buildUtilizationInActivitiesUtilizationCell(utilizationSpecification));
        return record;
    }

    private TableCell buildUtilizationInActivitiesActivityNameCell(Activities activities, UtilizationSpecification utilizationSpecification) {
        String text = this.buildActivityName(activities, utilizationSpecification);
        String bookmarkName = this.buildActivityBookmarkName(utilizationSpecification);
        return TableUtils.buildTableCell(text, bookmarkName);
    }

    private String buildActivityName(Activities activities, UtilizationSpecification utilizationSpecification) {
        String activityDefId = utilizationSpecification.getActivityDefId();
        Activity activity = activities.getActivity(activityDefId);
        if (activity != null) {
            return activity.getName();
        }
        return activityDefId;
    }

    private String buildActivityBookmarkName(UtilizationSpecification utilizationSpecification) {
        return BookmarkNameUtils.getNameForActivity(utilizationSpecification.getActivityDefId());
    }

    private TableCell buildUtilizationInActivitiesUtilizationCell(UtilizationSpecification utilizationSpecification) {
        return TableUtils.buildTableCell(utilizationSpecification.getDescription());
    }

    private void buildPoint(Documentation documentation, String titleKey, String text) {
        this.subchapterBuilder.build(documentation, titleKey, text);
    }

    private void buildPoint(Documentation documentation, String titleKey, TableHeaders headers, TableRecords records) {
        this.subchapterBuilder.build(documentation, titleKey, headers, records);
    }
}

