/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.changecard.builder;

import com.suncode.plugin.pwe.documentation.Documentation;
import com.suncode.plugin.pwe.documentation.NumberedPoint;
import com.suncode.plugin.pwe.documentation.NumberedPoints;
import com.suncode.plugin.pwe.documentation.ParagraphContent;
import com.suncode.plugin.pwe.documentation.ParagraphContents;
import com.suncode.plugin.pwe.documentation.comparator.ProcessSpecificationComparator;
import com.suncode.plugin.pwe.documentation.object.Difference;
import com.suncode.plugin.pwe.documentation.specification.ProcessSpecification;
import com.suncode.plugin.pwe.documentation.util.Counter;
import com.suncode.plugin.pwe.documentation.util.ParagraphContentsUtils;
import com.suncode.plugin.pwe.documentation.util.ParagraphIndentsUtils;
import com.suncode.plugin.pwe.documentation.util.TextValueUtils;
import com.suncode.plugin.pwe.service.translator.TranslatorService;
import com.suncode.plugin.pwe.util.translation.TranslationInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ChangeCardBuilder {
    private static final String TITLE = "pwe.documentation.changecard.title";
    private static final String PROCESS_SPECIFICATION_CHANGE_CARD_SUBCHAPTER_TITLE = "pwe.documentation.changecard.subchapter.title.processspecificationchangecard";
    private static final String DIFFERENCES = "pwe.documentation.text.differences";
    private static final String NO_DIFFERENCES = "pwe.documentation.text.nodifferences";
    @Autowired
    private TranslatorService translatorService;
    @Autowired
    private ProcessSpecificationComparator processSpecificationComparator;

    public Documentation build(String subtitle, WorkflowProcess baseProcess, ProcessSpecification baseProcessSpecification, WorkflowProcess comparedProcess, ProcessSpecification comparedProcessSpecification, TranslationInfo translationInfo) {
        String title = this.buildTitle();
        Documentation changeCard = new Documentation(title, subtitle);
        Counter subchapterNo = new Counter(1);
        this.buildProcessSpecificationChangeCardSubchapter(changeCard, baseProcess, baseProcessSpecification, comparedProcess, comparedProcessSpecification, translationInfo, subchapterNo.getCountAndIncrement());
        return changeCard;
    }

    private String buildTitle() {
        return this.translatorService.translateMessage(TITLE);
    }

    private void buildProcessSpecificationChangeCardSubchapter(Documentation documentation, WorkflowProcess baseProcess, ProcessSpecification baseProcessSpecification, WorkflowProcess comparedProcess, ProcessSpecification comparedProcessSpecification, TranslationInfo translationInfo, int subchapterNo) {
        documentation.addNewPage();
        String title = this.buildProcessSpecificationChangeCardSubchapterTitle(subchapterNo);
        List<Difference> differences = this.compareProcessSpecifications(baseProcess, baseProcessSpecification, comparedProcess, comparedProcessSpecification, translationInfo);
        if (CollectionUtils.isNotEmpty(differences)) {
            NumberedPoints points = this.buildProcessSpecificationChangeCardNumberedPoints(differences);
            documentation.addSubchapter(title, points);
        } else {
            ParagraphContents contents = this.buildNoDifferencesContents();
            documentation.addSubchapter(title, contents);
        }
    }

    private String buildProcessSpecificationChangeCardSubchapterTitle(int subchapterNo) {
        return this.translatorService.translateDocumentationSubchapterTitle(subchapterNo, PROCESS_SPECIFICATION_CHANGE_CARD_SUBCHAPTER_TITLE);
    }

    private List<Difference> compareProcessSpecifications(WorkflowProcess baseProcess, ProcessSpecification baseProcessSpecification, WorkflowProcess comparedProcess, ProcessSpecification comparedProcessSpecification, TranslationInfo translationInfo) {
        return this.processSpecificationComparator.compare(baseProcess, baseProcessSpecification, comparedProcess, comparedProcessSpecification, translationInfo);
    }

    private NumberedPoints buildProcessSpecificationChangeCardNumberedPoints(List<Difference> differences) {
        NumberedPoints points = new NumberedPoints();
        points.addPoint(this.buildProcessSpecificationChangeCardNumberedPoint(differences));
        return points;
    }

    private NumberedPoint buildProcessSpecificationChangeCardNumberedPoint(List<Difference> differences) {
        NumberedPoint point = new NumberedPoint();
        point.setTitle(this.translatorService.translateMessage(DIFFERENCES));
        point.setSubPoints(this.buildProcessSpecificationChangeCardSubPoints(differences));
        return point;
    }

    private List<ParagraphContents> buildProcessSpecificationChangeCardSubPoints(List<Difference> differences) {
        ArrayList<ParagraphContents> subPoints = new ArrayList<ParagraphContents>();
        for (Difference difference : differences) {
            subPoints.add(this.buildProcessSpecificationChangeCardSubPoint(difference));
        }
        return subPoints;
    }

    private ParagraphContents buildProcessSpecificationChangeCardSubPoint(Difference difference) {
        return ParagraphContentsUtils.build(difference.getDescription());
    }

    private ParagraphContents buildNoDifferencesContents() {
        String text = this.translatorService.translateMessage(NO_DIFFERENCES);
        ParagraphContent content = new ParagraphContent();
        content.setTextValue(TextValueUtils.build(text));
        return this.buildContents(content);
    }

    private ParagraphContents buildContents(ParagraphContent content) {
        ParagraphContents contents = new ParagraphContents();
        contents.setIndents(ParagraphIndentsUtils.buildLeft(1));
        contents.addContent(content);
        return contents;
    }
}

