Ext.ux.suncode.DTSortingWindow = function( config ) {
    var sorters = config.sorters;
    var groupers = config.groupers;

    var store = new Ext.data.Store( {
        reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( [ {
                name: 'columnId',
                type: 'string'
            }, {
                name: 'direction',
                type: 'string'
            } ] )
        } )
    } );

    if ( !Ext.isEmpty( sorters ) ) {
        store.loadData( sorters );
        store.commitChanges();
    }

    var columnsChooser = new Ext.ux.suncode.VariableSetColumnsChooser( {
        columns: config.columns,
        processNode: config.processNode
    } );
    var directionsChooser = new Ext.ux.suncode.SortDirectionsChooser( {} );

    config = Ext.apply( {
        title: getTranslation( 'Sortowanie tabeli dynamicznej' ),
        autoWidth: true,
        autoHeight: true,
        frame: false,
        modal: true,
        constrain: true,
        shadow: false,
        resizable: false,
        items: [ {
            xtype: 'editorgrid',
            store: store,
            border: false,
            height: 300,
            width: 600,
            enableColumnResize: true,
            columnLines: true,
            autoScroll: true,
            ref: 'sortingGrid',
            colModel: new Ext.grid.ColumnModel( {
                defaults: {
                    sortable: true,
                    menuDisabled: false
                },
                columns: [ {
                    id: 'columnId',
                    header: getTranslation( 'Zmienna' ),
                    dataIndex: 'columnId',
                    align: 'left',
                    editor: columnsChooser,
                    renderer: Ext.util.Format.ComboBoxRenderer( columnsChooser )
                }, {
                    id: 'direction',
                    header: getTranslation( 'Kierunek sortowania' ),
                    dataIndex: 'direction',
                    align: 'left',
                    editor: directionsChooser,
                    renderer: Ext.util.Format.ComboBoxRenderer( directionsChooser )
                } ]
            } ),
            viewConfig: new Ext.ux.suncode.StandardGridView( {
                emptyText: getTranslation( 'Brak sortowania' )
            } ),
            sm: new Ext.grid.RowSelectionModel( {
                singleSelect: true
            } ),
            tbar: new Ext.Toolbar( {
                buttons: [ {
                    xtype: 'tbtext',
                    text: '<font ' + getTotalStyle() + '><b>' + getTranslation( 'Ilość sortowań' ) + ': ' + store.getCount() + '</b></font>'
                }, '->', {
                    cls: 'x-btn-icon',
                    icon: getPluginImgPath( 'add' ),
                    tooltip: getTranslation( 'Dodaj' ),
                    handler: function() {
                        var grid = this.ownerCt.ownerCt;
                        var store = grid.getStore();
                        var a = store.recordType;
                        var rec = new a( {
                            columnId: '',
                            direction: 'ASC'
                        } );
                        grid.stopEditing();
                        store.add( rec );
                        store.commitChanges();
                        grid.updateTitle();
                    }
                }, {
                    cls: 'x-btn-icon',
                    icon: getPluginImgPath( 'delete' ),
                    tooltip: getTranslation( 'Usuń' ),
                    handler: function() {
                        var grid = this.ownerCt.ownerCt;
                        var selModel = grid.getSelectionModel();
                        var rows = selModel.getSelections();
                        if ( rows.length == 0 ) {
                            showWarn( getTranslation( 'Wybierz sortowanie do usunięcia.' ) );
                            return;
                        }
                        removeRowAndMarkNext( grid, rows[0] );
                        grid.getView().refresh();
                        grid.updateTitle();
                    }
                } ]
            } ),
            updateTitle: function() {
                var tbar = this.getTopToolbar();
                var txtInfo = tbar.items.first();
                txtInfo.setText( '<font ' + getTotalStyle() + '><b>' + getTranslation( 'Ilość sortowań' ) + ': ' + this.getStore().getCount()
                                + '</b></font>' );
            },
            listeners: {
                scope: this,
                validateedit: function( e ) {
                    var grid = e.grid;
                    var store = grid.getStore();
                    var cm = grid.getColumnModel();
                    var colIndex = e.column;
                    var value = e.value;

                    if ( cm.getColumnId( colIndex ) == 'columnId' && store.findExact( 'columnId', value ) != -1 ) {
                        showWarn( getTranslation( 'Zmienna procesu została już wykorzystana w innym sortowaniu.' ) );
                        return false;
                    }

                    if ( !Ext.isEmpty( groupers )) {
                      for ( var i = 0; i < groupers.length; i++ ) {
                        var grouper = groupers[i];

                        if ( grouper.columnId == value ) {
                          showWarn( getTranslation( 'Zmienna procesu została już wykorzystana w grupowaniu.' ) );
                          return false;
                        }
                      }
                    }
                },
                afteredit: function( e ) {
                    e.grid.getStore().commitChanges();
                }
            }
        } ],
        tbar: new Ext.Toolbar( {
            width: 600,
            buttons: [ {
                cls: 'x-btn-icon',
                ref: 'saveBtn',
                icon: getPluginImgPath( 'save' ),
                tooltip: getTranslation( 'Zapisz' ),
                handler: this.save,
                scope: this
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'close' ),
                tooltip: getTranslation( 'Zamknij' ),
                handler: this.closeWindow,
                scope: this
            } ]
        } )
    }, config );

    Ext.ux.suncode.DTSortingWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.DTSortingWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.DTSortingWindow.superclass.initComponent.call( this );
    },
    save: function() {
        var store = this.sortingGrid.getStore();
        var sorters = new Array();

        if ( store.getCount() > 0 ) {
            for ( var i = 0; i < store.getCount(); i++ ) {
                var rec = store.getAt( i );
                var columnId = rec.get( 'columnId' );
                var direction = rec.get( 'direction' );

                if ( Ext.isEmpty( columnId ) || Ext.isEmpty( direction ) ) {
                    showWarn( getTranslation( 'Zdefiniuj wszystkie pola.' ) );
                    return;
                }

              sorters.push( {
                    columnId: columnId,
                    direction: direction
                } );
            }
        }

        Ext.getCmp( 'form_grid_definition_panel' ).setSorters( sorters );
        this.close();
    },
    closeWindow: function() {
        this.close();
    }
} );