Ext.ux.suncode.DTActionsWindow = function( config ) {
    var actions = config.actions;

    var sources = [ [ 'DT_EVENT_STORE_add', 'Store add' ], [ 'DT_EVENT_STORE_beforeload', 'Store beforeload' ],
                    [ 'DT_EVENT_STORE_beforeprefetch', 'Store beforeprefetch' ], [ 'DT_EVENT_STORE_beforesync', 'Store beforesync' ],
                    [ 'DT_EVENT_STORE_bulkremove', 'Store bulkremove' ], [ 'DT_EVENT_STORE_clear', 'Store clear' ],
                    [ 'DT_EVENT_STORE_datachanged', 'Store datachanged' ], [ 'DT_EVENT_STORE_filterchange', 'Store filterchange' ],
                    [ 'DT_EVENT_STORE_groupchange', 'Store groupchange' ], [ 'DT_EVENT_STORE_load', 'Store load' ],
                    [ 'DT_EVENT_STORE_metachange', 'Store metachange' ], [ 'DT_EVENT_STORE_prefetch', 'Store prefetch' ],
                    [ 'DT_EVENT_STORE_refresh', 'Store refresh' ], [ 'DT_EVENT_STORE_remove', 'Store remove' ],
                    [ 'DT_EVENT_STORE_update', 'Store update' ], [ 'DT_EVENT_STORE_write', 'Store write' ],
                    [ 'DT_EVENT_GRID_activate', 'Grid activate' ], [ 'DT_EVENT_GRID_add', 'Grid add' ], [ 'DT_EVENT_GRID_added', 'Grid added' ],
                    [ 'DT_EVENT_GRID_afterlayout', 'Grid afterlayout' ], [ 'DT_EVENT_GRID_afterrender', 'Grid afterrender' ],
                    [ 'DT_EVENT_GRID_beforeactivate', 'Grid beforeactivate' ], [ 'DT_EVENT_GRID_beforeadd', 'Grid beforeadd' ],
                    [ 'DT_EVENT_GRID_beforecellclick', 'Grid beforecellclick' ],
                    [ 'DT_EVENT_GRID_beforecellcontextmenu', 'Grid beforecellcontextmenu' ],
                    [ 'DT_EVENT_GRID_beforecelldblclick', 'Grid beforecelldblclick' ],
                    [ 'DT_EVENT_GRID_beforecellkeydown', 'Grid beforecellkeydown' ],
                    [ 'DT_EVENT_GRID_beforecellmousedown', 'Grid beforecellmousedown' ],
                    [ 'DT_EVENT_GRID_beforecellmouseup', 'Grid beforecellmouseup' ], [ 'DT_EVENT_GRID_beforeclose', 'Grid beforeclose' ],
                    [ 'DT_EVENT_GRID_beforecollapse', 'Grid beforecollapse' ], [ 'DT_EVENT_GRID_beforecontainerclick', 'Grid beforecontainerclick' ],
                    [ 'DT_EVENT_GRID_beforecontainercontextmenu', 'Grid beforecontainercontextmenu' ],
                    [ 'DT_EVENT_GRID_beforecontainerdblclick', 'Grid beforecontainerdblclick' ],
                    [ 'DT_EVENT_GRID_beforecontainermousedown', 'Grid beforecontainermousedown' ],
                    [ 'DT_EVENT_GRID_beforecontainermouseout', 'Grid beforecontainermouseout' ],
                    [ 'DT_EVENT_GRID_beforecontainermouseover', 'Grid beforecontainermouseover' ],
                    [ 'DT_EVENT_GRID_beforecontainermouseup', 'Grid beforecontainermouseup' ],
                    [ 'DT_EVENT_GRID_beforedeactivate', 'Grid beforedeactivate' ], [ 'DT_EVENT_GRID_beforedeselect', 'Grid beforedeselect' ],
                    [ 'DT_EVENT_GRID_beforedestroy', 'Grid beforedestroy' ], [ 'DT_EVENT_GRID_beforeedit', 'Grid beforeedit' ],
                    [ 'DT_EVENT_GRID_beforeexpand', 'Grid beforeexpand' ], [ 'DT_EVENT_GRID_beforehide', 'Grid beforehide' ],
                    [ 'DT_EVENT_GRID_beforeitemclick', 'Grid beforeitemclick' ],
                    [ 'DT_EVENT_GRID_beforeitemcontextmenu', 'Grid beforeitemcontextmenu' ],
                    [ 'DT_EVENT_GRID_beforeitemdblclick', 'Grid beforeitemdblclick' ],
                    [ 'DT_EVENT_GRID_beforeitemmousedown', 'Grid beforeitemmousedown' ],
                    [ 'DT_EVENT_GRID_beforeitemmouseenter', 'Grid beforeitemmouseenter' ],
                    [ 'DT_EVENT_GRID_beforeitemmouseleave', 'Grid beforeitemmouseleave' ],
                    [ 'DT_EVENT_GRID_beforeitemmouseup', 'Grid beforeitemmouseup' ], [ 'DT_EVENT_GRID_beforereconfigure', 'Grid beforereconfigure' ],
                    [ 'DT_EVENT_GRID_beforeremove', 'Grid beforeremove' ], [ 'DT_EVENT_GRID_beforerender', 'Grid beforerender' ],
                    [ 'DT_EVENT_GRID_beforeselect', 'Grid beforeselect' ], [ 'DT_EVENT_GRID_beforeshow', 'Grid beforeshow' ],
                    [ 'DT_EVENT_GRID_beforestaterestore', 'Grid beforestaterestore' ], [ 'DT_EVENT_GRID_beforestatesave', 'Grid beforestatesave' ],
                    [ 'DT_EVENT_GRID_blur', 'Grid blur' ], [ 'DT_EVENT_GRID_boxready', 'Grid boxready' ],
                    [ 'DT_EVENT_GRID_cellclick', 'Grid cellclick' ], [ 'DT_EVENT_GRID_cellcontextmenu', 'Grid cellcontextmenu' ],
                    [ 'DT_EVENT_GRID_celldblclick', 'Grid celldblclick' ], [ 'DT_EVENT_GRID_cellkeydown', 'Grid cellkeydown' ],
                    [ 'DT_EVENT_GRID_cellmousedown', 'Grid cellmousedown' ], [ 'DT_EVENT_GRID_cellmouseup', 'Grid cellmouseup' ],
                    [ 'DT_EVENT_GRID_close', 'Grid close' ], [ 'DT_EVENT_GRID_collapse', 'Grid collapse' ],
                    [ 'DT_EVENT_GRID_columnhide', 'Grid columnhide' ], [ 'DT_EVENT_GRID_columnmove', 'Grid columnmove' ],
                    [ 'DT_EVENT_GRID_columnresize', 'Grid columnresize' ], [ 'DT_EVENT_GRID_columnschanged', 'Grid columnschanged' ],
                    [ 'DT_EVENT_GRID_columnshow', 'Grid columnshow' ], [ 'DT_EVENT_GRID_containerclick', 'Grid containerclick' ],
                    [ 'DT_EVENT_GRID_containercontextmenu', 'Grid containercontextmenu' ],
                    [ 'DT_EVENT_GRID_containerdblclick', 'Grid containerdblclick' ], [ 'DT_EVENT_GRID_containermouseout', 'Grid containermouseout' ],
                    [ 'DT_EVENT_GRID_containermouseover', 'Grid containermouseover' ], [ 'DT_EVENT_GRID_containermouseup', 'Grid containermouseup' ],
                    [ 'DT_EVENT_GRID_deactivate', 'Grid deactivate' ], [ 'DT_EVENT_GRID_deselect', 'Grid deselect' ],
                    [ 'DT_EVENT_GRID_destroy', 'Grid destroy' ], [ 'DT_EVENT_GRID_disable', 'Grid disable' ],
                    [ 'DT_EVENT_GRID_dockedadd', 'Grid dockedadd' ], [ 'DT_EVENT_GRID_dockedremove', 'Grid dockedremove' ],
                    [ 'DT_EVENT_GRID_enable', 'Grid enable' ], [ 'DT_EVENT_GRID_expand', 'Grid expand' ],
                    [ 'DT_EVENT_GRID_filterchange', 'Grid filterchange' ], [ 'DT_EVENT_GRID_float', 'Grid float' ],
                    [ 'DT_EVENT_GRID_focus', 'Grid focus' ], [ 'DT_EVENT_GRID_glyphchange', 'Grid glyphchange' ],
                    [ 'DT_EVENT_GRID_headerclick', 'Grid headerclick' ], [ 'DT_EVENT_GRID_headercontextmenu', 'Grid headercontextmenu' ],
                    [ 'DT_EVENT_GRID_headertriggerclick', 'Grid headertriggerclick' ], [ 'DT_EVENT_GRID_hide', 'Grid hide' ],
                    [ 'DT_EVENT_GRID_iconchange', 'Grid iconchange' ], [ 'DT_EVENT_GRID_iconclschange', 'Grid iconclschange' ],
                    [ 'DT_EVENT_GRID_itemclick', 'Grid itemclick' ], [ 'DT_EVENT_GRID_itemcontextmenu', 'Grid itemcontextmenu' ],
                    [ 'DT_EVENT_GRID_itemdblclick', 'Grid itemdblclick' ], [ 'DT_EVENT_GRID_itemmousedown', 'Grid itemmousedown' ],
                    [ 'DT_EVENT_GRID_itemmouseenter', 'Grid itemmouseenter' ], [ 'DT_EVENT_GRID_itemmouseleave', 'Grid itemmouseleave' ],
                    [ 'DT_EVENT_GRID_itemmouseup', 'Grid itemmouseup' ], [ 'DT_EVENT_GRID_lockcolumn', 'Grid lockcolumn' ],
                    [ 'DT_EVENT_GRID_move', 'Grid move' ], [ 'DT_EVENT_GRID_processcolumns', 'Grid processcolumns' ],
                    [ 'DT_EVENT_GRID_reconfigure', 'Grid reconfigure' ], [ 'DT_EVENT_GRID_remove', 'Grid remove' ],
                    [ 'DT_EVENT_GRID_removed', 'Grid removed' ], [ 'DT_EVENT_GRID_render', 'Grid render' ],
                    [ 'DT_EVENT_GRID_resize', 'Grid resize' ], [ 'DT_EVENT_GRID_select', 'Grid select' ],
                    [ 'DT_EVENT_GRID_selectionchange', 'Grid selectionchange' ], [ 'DT_EVENT_GRID_show', 'Grid show' ],
                    [ 'DT_EVENT_GRID_sortchange', 'Grid sortchange' ], [ 'DT_EVENT_GRID_staterestore', 'Grid staterestore' ],
                    [ 'DT_EVENT_GRID_statesave', 'Grid statesave' ], [ 'DT_EVENT_GRID_titlechange', 'Grid titlechange' ],
                    [ 'DT_EVENT_GRID_unfloat', 'Grid unfloat' ], [ 'DT_EVENT_GRID_unlockcolumn', 'Grid unlockcolumn' ],
                    [ 'DT_EVENT_GRID_validateedit', 'Grid validateedit' ], [ 'DT_EVENT_GRID_viewready', 'Grid viewready' ],
                    [ 'DT_EVENT_SM_focuschange', 'Selection model focuschange' ],
                    [ 'DT_EVENT_SM_selectionchange', 'Selection model selectionchange' ] ];

    var record = Ext.data.Record.create( [ {
        name: 'source',
        type: 'string'
    }, {
        name: 'func',
        type: 'string'
    }, {
        name: 'functionDefinition',
        type: 'string'
    } ] );

    var reader = new Ext.data.JsonReader( {
        fields: record
    } );

    var store = new Ext.data.Store( {
        reader: reader,
        fields: record
    } );

    if ( actions && actions.length ) {
        var rec = store.recordType;

        Ext.each( actions, function( a, index, as ) {
            var actionRec = new rec( {
                source: a.source,
                func: a.func,
                functionDefinition: 'scripts'
            } );
            store.add( actionRec );
        } );

        store.commitChanges();
    }

    var sourceChooser = new Ext.form.ComboBox( {
        triggerAction: 'all',
        mode: 'local',
        store: new Ext.data.ArrayStore( {
            fields: [ 'source', 'sourceName' ],
            data: sources
        } ),
        valueField: 'source',
        displayField: 'sourceName',
        forceSelection: true,
        resizable: true
    } );

    config = Ext.apply( {
        title: getTranslation( 'Akcje tabeli dynamicznej' ),
        autoWidth: true,
        autoHeight: true,
        frame: false,
        modal: true,
        constrain: true,
        shadow: false,
        resizable: false,
        items: [ {
            xtype: 'editorgrid',
            store: store,
            border: false,
            height: 300,
            width: 600,
            enableColumnResize: true,
            columnLines: true,
            autoScroll: true,
            ref: 'actionsGrid',
            colModel: new Ext.grid.ColumnModel( {
                defaults: {
                    sortable: true,
                    menuDisabled: false
                },
                columns: [ {
                    id: 'source',
                    header: getTranslation( 'Źródło' ),
                    dataIndex: 'source',
                    align: 'left',
                    editor: sourceChooser,
                    renderer: Ext.util.Format.ComboBoxRenderer( sourceChooser )
                }, {
                    id: 'func',
                    header: getTranslation( 'Funkcja' ),
                    dataIndex: 'func',
                    align: 'left',
                    editor: new Ext.form.TextField( {
                        inputType: 'text',
                        maskRe: /[a-zA-Z0-9_$]/
                    } )
                }, {
                    id: 'functionDefinition',
                    header: getTranslation( 'Definicja' ),
                    dataIndex: 'functionDefinition',
                    editable: false,
                    align: 'center',
                    width: 40,
                    renderer: imageCell
                } ]
            } ),
            viewConfig: new Ext.ux.suncode.StandardGridView( {
                emptyText: getTranslation( 'Brak akcji' )
            } ),
            sm: new Ext.grid.RowSelectionModel( {
                singleSelect: true
            } ),
            tbar: new Ext.Toolbar( {
                buttons: [ '->', {
                    cls: 'x-btn-icon',
                    icon: getPluginImgPath( 'add' ),
                    tooltip: getTranslation( 'Dodaj' ),
                    handler: function() {
                        var grid = this.ownerCt.ownerCt;
                        var store = grid.getStore();
                        var a = store.recordType;
                        var rec = new a( {
                            source: '',
                            func: '',
                            functionDefinition: 'scripts'
                        } );
                        grid.stopEditing();
                        store.add( rec );
                        store.commitChanges();
                        grid.updateTitle();
                    }
                }, {
                    cls: 'x-btn-icon',
                    icon: getPluginImgPath( 'delete' ),
                    tooltip: getTranslation( 'Usuń' ),
                    handler: function() {
                        var grid = this.ownerCt.ownerCt;
                        var selModel = grid.getSelectionModel();
                        var rows = selModel.getSelections();
                        if ( rows.length == 0 ) {
                            showWarn( getTranslation( 'Wybierz akcję do usunięcia.' ) );
                            return;
                        }
                        removeRowAndMarkNext( grid, rows[0] );
                        grid.getView().refresh();
                        grid.updateTitle();
                    }
                } ]
            } ),
            updateTitle: function() {
                var tbar = this.getTopToolbar();
                var txtInfo = tbar.items.first();
                txtInfo.setText( '<font ' + getTotalStyle() + '><b>' + getTranslation( 'Ilość akcji' ) + ': ' + this.getStore().getCount()
                                + '</b></font>' );
            },
            listeners: {
                scope: this,
                afteredit: function( e ) {
                    e.grid.getStore().commitChanges();
                },
                cellclick: this.showJSCodingWindow
            }
        } ],
        tbar: new Ext.Toolbar( {
            width: 600,
            buttons: [ {
                cls: 'x-btn-icon',
                ref: 'saveBtn',
                icon: getPluginImgPath( 'save' ),
                tooltip: getTranslation( 'Zapisz' ),
                handler: function() {
                    var store = this.actionsGrid.getStore();
                    var newActions = new Array();
                    if ( store.getCount() == 0 ) {
                        Ext.getCmp( 'form_grid_definition_panel' ).setActions( newActions );
                        this.close();
                        return;
                    }

                    for ( var i = 0; i < store.getCount(); i++ ) {
                        var rec = store.getAt( i );
                        var source = rec.get( 'source' );
                        var func = rec.get( 'func' );

                        if ( Ext.isEmpty( source ) || Ext.isEmpty( func ) ) {
                            showWarn( getTranslation( 'Zdefiniuj wszystkie pola.' ) );
                            return;
                        }

                        newActions.push( {
                            source: source,
                            func: func
                        } );
                    }

                    Ext.getCmp( 'form_grid_definition_panel' ).setActions( newActions );
                    this.close();
                },
                scope: this
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'close' ),
                tooltip: getTranslation( 'Zamknij' ),
                handler: this.closeWindow,
                scope: this
            } ]
        } )
    }, config );

    Ext.ux.suncode.DTActionsWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.DTActionsWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.DTActionsWindow.superclass.initComponent.call( this );

        this.on( 'afterrender', this.onAfterRender, this );
    },
    onAfterRender: function() {
        var actionsGrid = this.actionsGrid;
        var actionsStore = actionsGrid.getStore();

        var tbar = actionsGrid.getTopToolbar();
        tbar.insert( 0, '<font ' + getTotalStyle() + '><b>' + getTranslation( 'Ilość akcji' ) + ': ' + actionsStore.getCount() + '</b></font>' );
    },
    showJSCodingWindow: function( grid, rowIndex, columnIndex, e ) {
        var colId = grid.getColumnModel().getColumnId( columnIndex );

        if ( colId != 'functionDefinition' ) {
            return;
        }

        var store = grid.getStore();
        var rec = store.getAt( rowIndex );
        var source = rec.get( 'source' );
        var functionName = rec.get( 'func' );

        if ( Ext.isEmpty( source ) ) {
            showWarn( getTranslation( 'Wybierz źródło akcji.' ) );
            return;
        }

        if ( Ext.isEmpty( functionName ) ) {
            showWarn( getTranslation( 'Podaj nazwę funkcji.' ) );
            return;
        }

        var win = new Ext.ux.suncode.JsCodingWindow( {
            winTitle: getTranslation( 'Definicja funkcji akcji na zdarzeniach' ),
            sourceCodeType: 'JS_DT_EVENT',
            functionName: functionName,
            options: {
                parameters: Ext.ux.suncode.DTActionsParams.getActionParamsAsTable( source )
            }
        } );
        win.show();
    },
    closeWindow: function() {
        this.close();
    }
} );