Ext.ux.suncode.ProcessDocumentationHistoryWindow = function( config ) {
    var windowWidth = Ext.getBody().getViewSize().width * 0.4;
    var mainPanel = Ext.getCmp( 'main_panel' );

    config = Ext.apply( {
        AV: mainPanel.getAdvancedView()
    }, config );

    config = Ext.apply( {
        modal: true,
        width: windowWidth,
        title: getTranslation( 'Historia dokumentacji' ),
        items: [ new Ext.ux.suncode.ProcessDocumentationHistoryPanel( config ) ],
        closable: true,
        disableCloseValidation: true,
        tbar: new Ext.Toolbar( {
            buttons: [ new Ext.ux.suncode.CloseWindowButton( {
            	win: this
            } ) ]
        } )
    }, config );

    Ext.ux.suncode.ProcessDocumentationHistoryWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ProcessDocumentationHistoryWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.ProcessDocumentationHistoryWindow.superclass.initComponent.call( this );
    },
    closeWindow: function() {
        this.close();
    }
} );

Ext.ux.suncode.ProcessDocumentationHistoryPanel = function( config ) {
    config = Ext.apply( {
        layoutConfig: {
            trackLabels: true
        },
        labelWidth: 200,
        autoHeight: true,
        frame: false,
        border: false,
        bodyCssClass: 'x-Module-container-padding',
        buttonAlign: 'center',
        items: [ {
            xtype: 'displayfield',
            fieldLabel: getTranslation( 'Identyfikator pakietu' ),
            anchor: '100%',
            value: config.packageId,
            hidden: !config.AV
        }, {
            xtype: 'displayfield',
            fieldLabel: getTranslation( 'Nazwa pakietu' ),
            anchor: '100%',
            value: config.packageName
        }, {
            xtype: 'displayfield',
            fieldLabel: getTranslation( 'Wersja pakietu' ),
            anchor: '100%',
            value: config.packageVersion
        }, new Ext.ux.suncode.PackageProcessesChooser( config ) ],
        buttons: [ {
            cls: 'x-btn-text',
            text: getTranslation( 'Pobierz' ),
            tooltip: getTranslation( 'Pobierz dokumentację procesu' ),
            handler: this.downloadDocumentation,
            scope: this
        } ]
    }, config );

    Ext.ux.suncode.ProcessDocumentationHistoryPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ProcessDocumentationHistoryPanel, Ext.FormPanel, {
    initComponent: function() {
        Ext.ux.suncode.ProcessDocumentationHistoryPanel.superclass.initComponent.call( this );
    },
    downloadDocumentation: function() {
        var form = this.getForm();

        if ( form.isValid() ) {
            if ( Ext.getCmp( 'main_panel' ).isSaved() ) {
                executeNewXpdl();
                this.executeDownloadDocumentation();
            } else {
                Ext.Msg.show( {
                    title: getTranslation( 'Uwaga' ),
                    msg: getTranslation( 'Plik jest niezapisany. Zapisać przed wykonaniem operacji?' ),
                    buttons: {
                        yes: getTranslation( 'Tak' ),
                        no: getTranslation( 'Nie' ),
                        cancel: getTranslation( 'Anuluj' )
                    },
                    scope: this,
                    fn: function( buttonId ) {
                        switch ( buttonId ) {
                            case 'yes':
                                var me = this;
                                saveXpdl( function() {
                                  executeNewXpdl();
                                  me.executeDownloadDocumentation();
                                } );
                                break;
                            case 'no':
                            	resetAutoSaved();
                                executeNewXpdl();
                                this.executeDownloadDocumentation();
                                break;
                            default:
                                break;
                        }
                    },
                    icon: Ext.Msg.QUESTION
                } );
            }
        }
    },
    executeDownloadDocumentation: function() {
        var processDefId = this.packageProcessesItem.getValue();

        var formPanel = new Ext.FormPanel( {
            renderTo: document.body,
            hidden: true,
            items: [ {
                xtype: 'textfield',
                name: 'packageId',
                value: this.initialConfig.packageId
            }, {
                xtype: 'textfield',
                name: 'packageVersion',
                value: this.initialConfig.packageVersion
            } ]
        } );
        var form = formPanel.getForm();
        form.submit( {
            url: 'api/xpdl/openPackageVersion',
            waitMsg: getTranslation( 'Trwa przetwarzanie pliku...' ),
            waitTitle: getTranslation( 'Proszę czekać' ),
            method: 'POST',
            timeout: 600,
            scope: this,
            success: function( form, action ) {
                if ( action.result.success ) {
                    this.ownerCt.close();
                    executeOpen( action.result );
                    Ext.ux.suncode.DocumentationService.generateDocumentation( processDefId, new Ext.ux.suncode.RunnableTask( {
                        handler: executeNewXpdl
                    } ) );
                } else {
                    showWarn( getTranslation( 'Wystąpił błąd.' ) );
                }
            },
            failure: function( form, action ) {
            	showServerFailure( action.response );
            }
        } );

        var task = new Ext.util.DelayedTask( function() {
            formPanel.destroy();
        }, this );
        task.delay( 3000 );
    }
} );

Ext.ux.suncode.PackageProcessesChooser = function( config ) {
    var record = Ext.data.Record.create( [ {
        name: 'processDefId',
        type: 'string'
    }, {
        name: 'processName',
        type: 'string'
    } ] );

    var store = new Ext.data.JsonStore( {
        proxy: new Ext.data.HttpProxy( {
            method: 'GET',
            url: 'api/xpdl/getProcesses',
            listeners: {
            	exception: function( proxy, type, action, options, response, arg ) {
            		showServerFailure( response );
            	}
            }
        } ),
        reader: new Ext.data.JsonReader( {
            fields: record
        } ),
        autoDestroy: true,
        batch: true,
        fields: record,
        root: 'data',
        baseParams: {
            packageId: config.packageId,
            packageVersion: config.packageVersion
        }
    } );

    config = Ext.apply( {
        ref: 'packageProcessesItem',
        fieldLabel: getTranslation( 'Proces' ),
        anchor: '100%',
        resizable: true,
        allowBlank: false,
        blankText: getTranslation( 'Wybierz proces' ),
        store: store,
        triggerAction: 'all',
        mode: 'remote',
        forceSelection: true,
        displayField: 'processName',
        valueField: 'processDefId'
    }, config );

    Ext.ux.suncode.PackageProcessesChooser.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.PackageProcessesChooser, Ext.form.ComboBox, {
    initComponent: function() {
        Ext.ux.suncode.PackageProcessesChooser.superclass.initComponent.call( this );
    }
} );
